/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gJA7
 */

//
//	一番近い仲良しの点と繋がるよ！！
//	友達の多い点は調子にのって大きくなるよ！
//
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 * ...
	 * @author okoi
	 */
	public class Main extends Sprite 
	{
		private static const PATH_NUM:int = 700;
		private var paths:Array = new Array();
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			var i:uint = 0;
			for ( i = 0; i < PATH_NUM; i++ )
			{
				paths.push( new Path(stage) );
			}
			
			addEventListener( Event.ENTER_FRAME, EnterFrame );
		}
		
		private function EnterFrame(e:Event):void 
		{
			var i:int = 0;
			var j:int = 0;
			for ( i = 0; i < PATH_NUM; i++ )
			{
				paths[i].Update(stage);
				paths[i].jointNo = -1;
				paths[i].jointLen = 99999999;
				paths[i].jointCt = 0;
			}
			for ( i = 0; i < PATH_NUM; i++ )
			{
				var ip:Path = paths[i];
				
				for ( j = 0; j < PATH_NUM; j++ )
				{
					if ( i == j ) continue;
					var jp:Path = paths[j];
					var len:Number = ((jp.posX - ip.posX) * (jp.posX - ip.posX) + (jp.posY - ip.posY) * (jp.posY - ip.posY));
					if ( ip.jointLen > len )
					{
						if( ip.jointNo != -1 ) paths[ip.jointNo].jointCt--;
						ip.jointNo = j;
						ip.jointLen = len;
						jp.jointCt++;
					}
				}
			}			
			
			graphics.clear();
			graphics.beginFill( 0x000000 );
			graphics.drawRect( 0, 0, stage.stageWidth, stage.stageHeight );
			graphics.endFill();
		
			
			for ( i = 0; i < PATH_NUM; i++ )
			{
				var p:Path = paths[i];
				p.Draw(graphics,paths);
			}
		}
		
	}
	
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
import flash.display.Graphics;
import flash.display.Stage;

class Path {
	
	public var posX:Number;
	public var posY:Number;
	public var moveX:Number;
	public var moveY:Number;
	
	public var jointNo:int = -1;
	public var jointLen:Number = 99999999;
	public var jointCt:int = 0;
	
	public	function Path(stage:Stage) {
		Init(stage);
	}
	
	public	function Init(stage:Stage):void 
	{
		posX = Math.random() * stage.stageWidth;
		posY = Math.random() * stage.stageHeight;
		
		var angle:Number = Math.random() * 360;
		var speed:Number = Math.random() * 2 + 0.1;
		
		moveX = Math.cos( angle * Math.PI / 180.0 ) * speed;
		moveY = Math.sin( angle * Math.PI / 180.0 ) * speed;
	}
	
	public	function Update(stage:Stage):void 
	{
		posX += moveX;
		posY += moveY;
		if ( posX < 0 )	posX = stage.stageWidth;
		if ( posX > stage.stageWidth ) posX = 0;
		if ( posY < 0 ) posY = stage.stageHeight;
		if ( posY > stage.stageHeight ) posY = 0;
	}
	
	public	function Draw(g:Graphics,paths:Array):void
	{
		g.lineStyle(0);
		g.beginFill( 0xFFFFFF );
		g.drawCircle( posX, posY, 2+jointCt );
		g.endFill();
		
		if ( jointNo != -1 )
		{
			g.lineStyle(1, 0xFFFFFF);
			g.moveTo(posX, posY);
			g.lineTo(paths[jointNo].posX, paths[jointNo].posY);
		}
		
	}
}
