/**
 * Copyright sion0303 ( http://wonderfl.net/user/sion0303 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gJ1O
 */

// 3次元リサージュ図形を描いてみた
package {
	import flash.events.Event;
	import org.papervision3d.core.effects.BitmapLayerEffect;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;

	[SWF(backgroundColor=0x0)]
	public class PV3D_Lissajous extends BasicView
	{
		private var A:Number = 300;
		private var B:Number = 300;
		private var C:Number = 300;
		private var w1:Number = 0.99;
		private var w2:Number = 0.98;
		private var w3:Number = 0.97;
		private var _alpha:Number = 0;
		private var _beta:Number = 0;
		private var _ganma:Number = 0;
		private var pixels:Pixels;
		private var layer:BitmapEffectLayer;
		private var cnt:Number = 0;
		public function PV3D_Lissajous()
		{
			// ビットマップエフェクトレイヤー作成
			layer = new BitmapEffectLayer(viewport, 1024, 768);
			viewport.containerSprite.addLayer(layer);
			layer.clearBeforeRender = true;
			
			// Pixels作成
			pixels = new Pixels(layer);
			scene.addChild(pixels);
			
			/*
				3次元リサージュ曲線の公式
				x = A * sin(w1 * t + _alpha)
				y = B * sin(w2 * t + _beta)
				z = C * sin(w3 * t + _ganma)
				A, B, Cは振幅, w1, w2, w3は振動数, _alpha, _beta, _ganmaは位相
			*/
			for(var i:int = 0; i < 3000; i++) {
				var t:Number = (i / 50) * 360 * Math.PI / 180;
				var pointX:Number = A * Math.sin(w1*t+_alpha);
				var pointY:Number = B * Math.sin(w2*t+_beta);
				var pointZ:Number = C * Math.sin(w3*t+_ganma);
				var pixel:Pixel3D = new Pixel3D(0xffff9900, pointX, pointY, pointZ);
				pixels.addPixel3D(pixel);				
			}
			
			startRendering();
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		private function onEnterFrame(e:Event):void
		{			
			cnt+=0.02;
			camera.x = 1000 * Math.sin(cnt);
			camera.z = 1000 * Math.cos(cnt);		
		}
	}
}
