/**
 * Copyright goodbyegirl1974 ( http://wonderfl.net/user/goodbyegirl1974 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gJ0q
 */

// forked from goodbyegirl1974's Dot Editor
package {
    import flash.events.Event;
    import flash.utils.ByteArray;
    import flash.geom.Rectangle;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import fl.controls.Button;
    public class DotEditor extends Sprite {
        public static const MODE_DRAW:String = "draw";
        public static const MODE_ERASE:String = "erase";
        public static const MODE_RESET:String = "reset";
        
        private const COLOR_HEADER:String = "0x";
        private var _colorAlpha:uint = 255;
        private var _horizonalGridNum:int = 20;
        private var _verticalGridNum:int = 20;
        private var _gridWidth:Number = 20.0;
        private var _gridHeight:Number = 20.0;
        private var _mouseDownFlg:Boolean = false;
        private var _mode:String = DotEditor.MODE_DRAW;
        private var _allGridArray:Array = [];
        private var _modePointer:Sprite;
        private var _outPutWindow:Sprite;
        private var _outPutTextField:TextField;
        private var _outPutBitMap:Bitmap;
        
        private var _nowColor:String = "0x000000";
        
        //以下、カラーエディタのスライドバー関連
        private const _SLIDE_BAR_MIN_X_NUM:Number = 50;
        private const _SLIDE_BAR_MIN_Y_NUM:Number = 50;
        private const _SLIDE_BAR_SPACE_NUM:Number = 30;
        private const COLOR_MAX_NUM:uint = 255;
        private var _slideBarA:SlideBar;
        private var _resultFieldA:TextField;
        private var _slideBarR:SlideBar;
        private var _resultFieldR:TextField;
        private var _slideBarG:SlideBar;
        private var _resultFieldG:TextField;
        private var _slideBarB:SlideBar;
        private var _resultFieldB:TextField;
        private var _resultSprite:Sprite;
        private var _logField:TextField;
        private var _colorSelectWindowSprite:Sprite;
        
        /**
        *    コンストラクタ。
        **/
        public function DotEditor() {
            // write as3 code here..
            init();
        }
        
        private function init():void
        {
            //とりあえず、20×20のグリッドを表示。
            var i:int = 0;
            for(i; i < _verticalGridNum; i++)
            {
                var j:int = 0;
                var targetArray:Array = [];
                for(j; j < _horizonalGridNum; j++)
                {
                    var sprite:GridSprite = new GridSprite(_gridWidth, _gridHeight);
                    sprite.x = _gridWidth * j;
                    sprite.y = _gridHeight * i;
                    addChild(sprite);
                    sprite.addEventListener(MouseEvent.MOUSE_DOWN, gridMouseDownHandler);
                    sprite.addEventListener(MouseEvent.MOUSE_UP, gridMouseUpHandler);
                    sprite.addEventListener(MouseEvent.ROLL_OVER, gridRollOverFunction);
                    stage.addEventListener(MouseEvent.MOUSE_UP, gridMouseUpHandler);
                    targetArray.push(sprite);
                }
                this._allGridArray.push(targetArray);
            }
            //ボタンを3つ配置。
            var drawButton:Sprite = makeBtn(80, 20, "描画");
            drawButton.x = 40;
            drawButton.y = 420;
            addChild(drawButton);
            drawButton.addEventListener(MouseEvent.CLICK, modeButtonClickHandler);
            var eraseButton:Sprite = makeBtn(80, 20, "消去");
            eraseButton.x = 140;
            eraseButton.y = 420;
            addChild(eraseButton);
            eraseButton.addEventListener(MouseEvent.CLICK, modeButtonClickHandler);
            var resetButton:Sprite = makeBtn(80, 20, "リセット");
            resetButton.x = 240;
            resetButton.y = 420;
            addChild(resetButton);
            resetButton.addEventListener(MouseEvent.CLICK, modeButtonClickHandler);
            drawButton.name = DotEditor.MODE_DRAW;
            eraseButton.name = DotEditor.MODE_ERASE;
            resetButton.name = DotEditor.MODE_RESET;
            _modePointer = new Sprite();
            _modePointer.graphics.lineStyle(0, 0xcc0000);
            _modePointer.graphics.beginFill(0xcc0000);
            _modePointer.graphics.drawRect(-40, -2, 80, 4);
            _modePointer.graphics.endFill();
            _modePointer.x = drawButton.x;
            _modePointer.y = drawButton.y + 15;
            addChild(_modePointer);
            
            var showOutPutButton:Sprite = makeBtn(80, 20, "出力");
            showOutPutButton.x = 340;
            showOutPutButton.y = 420;
            addChild(showOutPutButton);
            showOutPutButton.addEventListener(MouseEvent.CLICK, showOutPutButtonClickHandler);
            
            //出力用ウィンドウの生成。
            _outPutWindow = new Sprite();
            var w:Number = 400;
            var h:Number = 400;
            _outPutWindow.graphics.lineStyle(1, 0x333333, 0.5);
            _outPutWindow.graphics.beginFill(0xffffff, 0.5);
            _outPutWindow.graphics.moveTo(0, 0);
            _outPutWindow.graphics.lineTo(0, h);
            _outPutWindow.graphics.lineTo(w, h);
            _outPutWindow.graphics.lineTo(w, 0);
            _outPutWindow.graphics.endFill();
            var btnClose:Sprite = this.makeBtn(80, 20, "閉じる");
            _outPutWindow.addChild(btnClose);
            btnClose.x = w / 2;
            btnClose.y = h - 30;
            btnClose.addEventListener(MouseEvent.CLICK, btnCloseClickHandler);
            _outPutWindow.visible = false;
            this._outPutTextField = new TextField();
            _outPutTextField.autoSize = TextFieldAutoSize.LEFT;
            _outPutWindow.addChild(_outPutTextField);
            addChild(_outPutWindow);
            
            makeColorSelectWindow();
        }
        
        private function makeColorWindowButtonClickHandler(event:MouseEvent):void
        {
            if(_colorSelectWindowSprite != null)
            {
                if(_colorSelectWindowSprite.visible)
                {
                    this.removeEventListener(Event.ENTER_FRAME, this.colorSelectWindowEnterFrameHandler);
                    _colorSelectWindowSprite.visible = false;
                }
                else
                {
                    this.addEventListener(Event.ENTER_FRAME, this.colorSelectWindowEnterFrameHandler);
                    _colorSelectWindowSprite.visible = true;
                }
            }
            
        }

        
        private function makeColorSelectWindow():void
        {
            if(_colorSelectWindowSprite == null)
            {
                _colorSelectWindowSprite = new Sprite();
                this.addChild(_colorSelectWindowSprite);
                _colorSelectWindowSprite.visible = false;
            }
            _colorSelectWindowSprite.graphics.beginFill(0x666666, 0.7);
            _colorSelectWindowSprite.graphics.drawRect(0, 0, 400, 400);
            _colorSelectWindowSprite.graphics.endFill();
            
            _slideBarA = new SlideBar();
            _slideBarA.makeSlideBar(200, 10, _SLIDE_BAR_MIN_X_NUM, _SLIDE_BAR_MIN_Y_NUM);
            _colorSelectWindowSprite.addChild(_slideBarA);
            _resultFieldA = new TextField();
            _resultFieldA.autoSize = TextFieldAutoSize.LEFT;
            _resultFieldA.x = _slideBarA.x + _slideBarA.width + 20;;
            _resultFieldA.y = _slideBarA.y - _slideBarA.height / 2;
            _resultFieldA.text = "出力結果";
            var _titleFieldA:TextField = new TextField();
            _titleFieldA.text = "A:"
            _colorSelectWindowSprite.addChild(_titleFieldA);
            _titleFieldA.x = _SLIDE_BAR_MIN_X_NUM - 30;
            _titleFieldA.y = _resultFieldA.y;
            _titleFieldA.autoSize = TextFieldAutoSize.LEFT;
            _colorSelectWindowSprite.addChild(_resultFieldA);
            
            //R設定
            _slideBarR = new SlideBar();
            _slideBarR.makeSlideBar(200, 10, _SLIDE_BAR_MIN_X_NUM, _SLIDE_BAR_MIN_Y_NUM + _SLIDE_BAR_SPACE_NUM * 1);
            _colorSelectWindowSprite.addChild(_slideBarR);
            _resultFieldR = new TextField();
            _resultFieldR.autoSize = TextFieldAutoSize.LEFT;
            _resultFieldR.x = _slideBarR.x + _slideBarR.width + 20;;
            _resultFieldR.y = _slideBarR.y - _slideBarR.height / 2;
            _resultFieldR.text = "出力結果";
            _colorSelectWindowSprite.addChild(_resultFieldR);
            var _titleFieldR:TextField = new TextField();
            _titleFieldR.text = "R:"
            _colorSelectWindowSprite.addChild(_titleFieldR);
            _titleFieldR.x = _SLIDE_BAR_MIN_X_NUM - 30;
            _titleFieldR.y = _resultFieldR.y;
            _titleFieldR.autoSize = TextFieldAutoSize.LEFT;
            _colorSelectWindowSprite.addChild(_resultFieldR);
            
            //G設定
            _slideBarG = new SlideBar();
            _slideBarG.makeSlideBar(200, 10, _SLIDE_BAR_MIN_X_NUM, _SLIDE_BAR_MIN_Y_NUM + _SLIDE_BAR_SPACE_NUM * 2);
            _colorSelectWindowSprite.addChild(_slideBarG);
            _resultFieldG = new TextField();
            _resultFieldG.autoSize = TextFieldAutoSize.LEFT;
            _resultFieldG.x = _slideBarG.x + _slideBarG.width + 20;;
            _resultFieldG.y = _slideBarG.y - _slideBarG.height / 2;
            _resultFieldG.text = "出力結果";
            _colorSelectWindowSprite.addChild(_resultFieldG);
            var _titleFieldG:TextField = new TextField();
            _titleFieldG.text = "G:"
            _colorSelectWindowSprite.addChild(_titleFieldG);
            _titleFieldG.x = _SLIDE_BAR_MIN_X_NUM - 30;
            _titleFieldG.y = _resultFieldG.y;
            _titleFieldG.autoSize = TextFieldAutoSize.LEFT;
            _colorSelectWindowSprite.addChild(_resultFieldG);
            
            //B設定
            _slideBarB = new SlideBar();
            _slideBarB.makeSlideBar(200, 10, _SLIDE_BAR_MIN_X_NUM, _SLIDE_BAR_MIN_Y_NUM + _SLIDE_BAR_SPACE_NUM * 3);
            _colorSelectWindowSprite.addChild(_slideBarB);
            _resultFieldB = new TextField();
            _resultFieldB.autoSize = TextFieldAutoSize.LEFT;
            _resultFieldB.x = _slideBarB.x + _slideBarB.width + 20;;
            _resultFieldB.y = _slideBarB.y - _slideBarB.height / 2;
            _resultFieldB.text = "出力結果";
            _colorSelectWindowSprite.addChild(_resultFieldB);
            var _titleFieldB:TextField = new TextField();
            _titleFieldB.text = "B:"
            _colorSelectWindowSprite.addChild(_titleFieldB);
            _titleFieldB.x = _SLIDE_BAR_MIN_X_NUM - 30;
            _titleFieldB.y = _resultFieldB.y;
            _titleFieldB.autoSize = TextFieldAutoSize.LEFT;
            _colorSelectWindowSprite.addChild(_resultFieldB);
            
            //出力結果
            _resultSprite = new Sprite();
            _colorSelectWindowSprite.addChild(_resultSprite);
            _resultSprite.x = _SLIDE_BAR_MIN_X_NUM;
            _resultSprite.y = _SLIDE_BAR_MIN_Y_NUM + _SLIDE_BAR_SPACE_NUM * 4;
            
            //_colorSelectWindowSprite.addEventListener(MouseEvent.CLICK, makeColorWindowButtonClickHandler);
            
            
            _logField = new TextField();
            _colorSelectWindowSprite.addChild(this._logField);
            this._logField.x = _SLIDE_BAR_MIN_X_NUM;
            this._logField.y = 400;
            _logField.text = "色情報";
            
            //this.addEventListener(Event.ENTER_FRAME, this.colorSelectWindowEnterFrameHandler);
            
            var makeColorWindowButton:Sprite = makeBtn(80, 20, "カラー");
            makeColorWindowButton.x = 340;
            makeColorWindowButton.y = 450;
            addChild(makeColorWindowButton);
            makeColorWindowButton.addEventListener(MouseEvent.CLICK, makeColorWindowButtonClickHandler);
            
        }
        
        private function colorSelectWindowEnterFrameHandler(event:Event):void
        {
            var aNum:Number = 1 - _slideBarA.getDragBarPositionRatio();
            var rNum:int = Math.floor(_slideBarR.getDragBarPositionRatio() * COLOR_MAX_NUM);
            var gNum:int = Math.floor(_slideBarG.getDragBarPositionRatio() * COLOR_MAX_NUM);
            var bNum:int = Math.floor(_slideBarB.getDragBarPositionRatio() * COLOR_MAX_NUM);
            
            var rString:String = String("0" + rNum.toString(16)).substr(-2, 2);
            var gString:String = String("0" + gNum.toString(16)).substr(-2, 2);
            var bString:String = String("0" + bNum.toString(16)).substr(-2, 2);
            
            _resultFieldA.text = "出力結果 = " + String(Math.floor(aNum * 100)).substr(0, 3) + "%";
            _resultFieldR.text = "出力結果 = " + rString;
            _resultFieldG.text = "出力結果 = " + gString;
            _resultFieldB.text = "出力結果 = " + bString;
            
            var rectColor:uint = uint("0x" + rString + gString + bString);
            
            _logField.text = "0x" + rString + gString + bString;
            
            _resultSprite.graphics.clear();
            _resultSprite.graphics.lineStyle(1, 0x999999);
            _resultSprite.graphics.beginFill(rectColor, aNum);
            _resultSprite.graphics.drawRect(0, 0, 200, 200)
            _resultSprite.graphics.endFill();
            this._nowColor = "0x" + rString + gString + bString;
            this._colorAlpha = 255 * aNum;
        }

        
        private function btnCloseClickHandler(event:MouseEvent):void
        {
            _outPutWindow.visible = false;
            _outPutWindow.removeChild(_outPutBitMap);
        }

        
        /**
        *    出力ボタンをクリックした際のファンクション。
        **/
        private function showOutPutButtonClickHandler(event:MouseEvent):void
        {
            _outPutTextField.text = "";
            //出力用配列の生成。Gridの数だけ0を格納した配列を作成する。
            var outPutArray:Array = [];
            var i:int = 0;
            for(i; i < _horizonalGridNum; i++)
            {
                var array:Array = [];
                var j:int = 0;
                for(j; j < _verticalGridNum; j++)
                {
                    array.push("0");
                }
                outPutArray.push(array);
            }
            //全グリッドの走査。
            var targetArray:Array;
            for each(targetArray in _allGridArray)
            {
                var targetGrid:GridSprite;
                var arrayIndexNum:int = _allGridArray.indexOf(targetArray);
                for each(targetGrid in targetArray)
                {
                    if(targetGrid.type == "clicked")
                    {
                        var gridIndexNum:int = targetArray.indexOf(targetGrid);
                        outPutArray[arrayIndexNum][gridIndexNum] = this.COLOR_HEADER + _colorAlpha.toString(16) + targetGrid.colorString;
                    }
                }
            }
            
            //全配列の再チェックしてトリミング。
            //Step1:上段から順に走査。何か表示が出た時点で処理をとめる。
            var stringInArray:String;
            var totalNum:Number = 0;
            for (i = 0; i < outPutArray.length; i++)
            {
                targetArray = outPutArray[0];
                totalNum = 0;
                for each(stringInArray in targetArray)
                {
                    totalNum += Number(stringInArray);
                }

                //if(targetArray.indexOf(1) == -1)
                if(totalNum == 0)
                {
                    //1が含まれていない、つまり何も描画されていない。
                    outPutArray.splice(0, 1);
                }
                else
                {
                    break;
                }
            }
            //Step2:下段から順に走査。何か表示が出た時点で処理をとめる。
            for (i = outPutArray.length - 1; i >= 0; i--)
            {
                targetArray = outPutArray[i];
                totalNum = 0;
                for each(stringInArray in targetArray)
                {
                    totalNum += Number(stringInArray);
                }
                //if(targetArray.indexOf(1) == -1)
                if(totalNum == 0)
                {
                    //1が含まれていない、つまり何も描画されていない。
                    var indexNum:int = outPutArray.indexOf(targetArray);
                    outPutArray.splice(indexNum, 1);
                }
                else
                {
                    break;
                }
            }
            //Step3：左列から順に走査。何か表示が出た時点で処理をとめる。
            for (i = 0; i < outPutArray[0].length; i++)
            {
                totalNum = 0;
                for each(targetArray in outPutArray)
                {
                    totalNum += targetArray[0];
                }
                if(totalNum != 0)
                {
                    break;
                }
                else
                {
                    //1が含まれていない、つまり何も描画されていない。
                    for each(targetArray in outPutArray)
                    {
                        targetArray.splice(0, 1);
                    }
                }
            }
            //Step4：右列から順に走査。何か表示が出た時点で処理をとめる。
            for (i = outPutArray[0].length - 1; i >= 0; i--)
            {
                totalNum = 0;
                for each(targetArray in outPutArray)
                {
                    totalNum += targetArray[i];
                }
                if(totalNum != 0)
                {
                    break;
                }
                else
                {
                    //1が含まれていない、つまり何も描画されていない。
                    for each(targetArray in outPutArray)
                    {
                        targetArray.splice(i, 1);
                    }
                }
            }
            //トリミング終了後の配列をテキストフィールドに出力。
            for each(targetArray in outPutArray)
            {
                _outPutTextField.appendText("[" + String(targetArray) + "]," + "\n");
            }
            _outPutWindow.visible = true;
            _outPutBitMap = setBmpData(outPutArray, 2, 2);
            _outPutWindow.addChild(_outPutBitMap);
            _outPutBitMap.x = 300;
        }
        
        /**
        *    モード選択ボタンをクリックした際のファンクション。
        **/
        private function modeButtonClickHandler(event:MouseEvent):void
        {
            var targetButton:Sprite = event.currentTarget as Sprite;
            var selectedMode:String = targetButton.name;
            this._mode = selectedMode;
            if(this._mode == DotEditor.MODE_DRAW || this._mode == DotEditor.MODE_ERASE)
                this._modePointer.x = targetButton.x;
            if(this._mode == DotEditor.MODE_RESET)
            {
                var targetArray:Array;
                for each(targetArray in _allGridArray)
                {
                    var targetGrid:GridSprite;
                    for each(targetGrid in targetArray)
                    {
                        targetGrid.changeColor(DotEditor.MODE_ERASE, _nowColor);
                    }
                }
                this._mode = DotEditor.MODE_DRAW;
            }
        }

        /**
        *    ボタンを生成するファンクション。
        **/
        private function makeBtn(widthNum:Number, heightNum:Number, btnLabel:String = "btn"):Sprite
        {
            var btnSprite:Sprite = new Sprite();
            btnSprite.graphics.lineStyle(1, 0x999999);
            btnSprite.graphics.beginFill(0xcccccc);
            btnSprite.graphics.moveTo(-widthNum / 2, -heightNum / 2);
            btnSprite.graphics.lineTo(-widthNum / 2, heightNum / 2);
            btnSprite.graphics.lineTo(widthNum / 2, heightNum / 2);
            btnSprite.graphics.lineTo(widthNum / 2, -heightNum / 2);
            btnSprite.graphics.endFill();
            var labelField:TextField = new TextField();
            labelField.text = btnLabel;
            labelField.autoSize = TextFieldAutoSize.CENTER;
            labelField.x = -labelField.width / 2;
            labelField.y = -labelField.height / 2;
            labelField.selectable = false;
            labelField.mouseEnabled = false;
            btnSprite.addChild(labelField);
            this.buttonMode = true;
            return btnSprite;
        }

        /**
        *    グリッド上でマウスダウンした際のファンクション。
        **/
        private function gridMouseDownHandler(event:MouseEvent):void
        {
            _mouseDownFlg = true;
            var targetGrid:GridSprite = event.currentTarget as GridSprite;
            targetGrid.changeColor(this._mode, _nowColor);
        }
        
        /**
        *    グリッド上でマウスアップした際のファンクション。
        **/
        private function gridMouseUpHandler(event:MouseEvent):void
        {
            _mouseDownFlg = false;
        }
        
        /**
        *    グリッドにロールオーバーした際のファンクション。
        **/
        private function gridRollOverFunction(event:MouseEvent):void
        {
            if(!_mouseDownFlg)
                return;
            var targetGrid:GridSprite = event.currentTarget as GridSprite;
            targetGrid.changeColor(this._mode, _nowColor);
        }
        
        /**
        *    出力結果をビットマップに反映させるファンクション。
        **/
        private function setBmpData(outPutArray:Array, pixWidth:uint = 1, pixHeight:uint = 1):Bitmap
        {
            var horizonalPixelNum:uint = outPutArray[0].length;
            var verticalPixelNum:uint = outPutArray.length;
            var bmd:BitmapData = new BitmapData(pixWidth * horizonalPixelNum, pixHeight * verticalPixelNum, true, 0x00ffffff);
            //var colorBmd:BitmapData = new BitmapData(pixWidth, pixHeight, true, 0xff000000);
            var colorBmd:BitmapData;
            var emptyBmd:BitmapData = new BitmapData(pixWidth, pixHeight, true, 0x00ffffff);
            var bmp:Bitmap = new Bitmap(bmd);
            var i:int = 0;
            for(i; i < outPutArray.length; i++)
            {
                var targetArray:Array = outPutArray[i];
                var j:int = 0;
                for(j; j < targetArray.length; j++)
                {
                    colorBmd = null;
                    //0か1かの結果を取得する。
                    var colorNum:uint = uint(targetArray[j]);
                    var rect:Rectangle = new Rectangle(j * pixWidth, i * pixHeight, pixWidth, pixHeight);
                    var bytes:ByteArray;
                    if(colorNum != 0)
                    {
                        colorBmd = new BitmapData(pixWidth, pixHeight, true, colorNum);
                        bytes = colorBmd.getPixels(new Rectangle(0, 0, pixWidth, pixHeight));
                    }
                    else if(colorNum == 0)
                    {
                        bytes = emptyBmd.getPixels(new Rectangle(0, 0, pixWidth, pixHeight));
                    }
                    bytes.position = 0;
                    bmd.setPixels(rect, bytes);
                }
            }
            return bmp;
        }

    }
}
import flash.geom.Rectangle;
import flash.events.MouseEvent;
import flash.display.Sprite;

class GridSprite extends Sprite
{
    private const TYPE_DEFAULT:String = "default";
    private const TYPE_CLICKED:String = "clicked";
    private var _type:String = TYPE_DEFAULT;
    private var _colorNum:uint = 0xcccccc;
    private var _colorString:String = "0xcccccc";
    private var _widthNum:Number;
    private var _heightNum:Number;
    
    /**
    *    コンストラクタ。
    **/
    public function GridSprite(widthNum:Number, heightNum:Number)
    {
        init(widthNum, heightNum);
    }
    
    private function init(widthNum:Number, heightNum:Number):void
    {
        buttonMode = true;
        _widthNum = widthNum;
        _heightNum = heightNum;
        drawGrid(widthNum, heightNum);
    }
    
    /**
    *    色を変化させるファンクション。
    **/
    public function changeColor(type:String, color:String):void
    {
        if(this._type == type)
            return;
        _colorString = color.substr(2);
        _colorNum = uint(color);
        switch(type)
        {
            case DotEditor.MODE_DRAW:
                this._type = TYPE_CLICKED;
                break;
            case DotEditor.MODE_ERASE:
                this._type = TYPE_DEFAULT;
                _colorNum = 0xcccccc;
                break;
        }
        //this._type = type;
        drawGrid(this._widthNum, this._heightNum);
    }
    
    private function drawGrid(width:Number, height:Number):void
    {
        /*
        var color:uint = _colorNum;
        switch(this._type)
        {
            case TYPE_DEFAULT:
                color = 0xcccccc;
                break;
            case TYPE_CLICKED:
                color = _colorNum;
                break;
        }*/
        graphics.clear();
        graphics.lineStyle(1 , 0xaaaaaa);
        graphics.beginFill(_colorNum);
        /*
        graphics.moveTo(0 , 0);
        graphics.lineTo(0 , height);
        graphics.lineTo(width , height);
        graphics.lineTo(width , 0);
        */
        graphics.drawRect(0, 0, width, height);
        graphics.endFill();
    }
    
    /**
    *    _typeを取得するゲッター。
    **/
    public function get type():String
    {
        return this._type;
    }
    
    public function get colorNum():uint
    {
        return this._colorNum;
    }
    
    public function get colorString():String
    {
        return this._colorString;
    }

}

class ColorObj{
    
    private var _colorNum:uint;
    private var _indexNum:uint;
    public function ColorObj(colorNumValue:uint, indexNumValue:uint)
    {
        _colorNum = colorNumValue;
        _indexNum = indexNumValue;
    }
    
    public function get colorNum():uint
    {
        return this._colorNum;
    }
    
    public function set colorNum(value:uint):void
    {
        this._colorNum = value;
    }

    public function get indexNum():uint
    {
        return this._indexNum;
    }
    
    public function set indexNum(value:uint):void
    {
        this._indexNum = value;
    }
}

class SlideBar extends Sprite
{
    private var _dragBarSprite:Sprite;
    private var _dragBarBackSprite:Sprite;
    //private var _slideBarAllSprite:Sprite;
    private var _dragRectangle:Rectangle;
    
    public function SlideBar()
    {
        
    }
    
    public function makeSlideBar(widthNum:Number, heightNum:Number, xNum:Number = 100, yNum:Number = 200):void
    {
        var slideBarAllSprite:Sprite = new Sprite();
        this.addChild(slideBarAllSprite);
        x = xNum;
        y = yNum;
        _dragBarBackSprite = new Sprite()
        _dragBarBackSprite.graphics.lineStyle(1);
        _dragBarBackSprite.graphics.beginFill(0xdedede);
        _dragBarBackSprite.graphics.drawRect(0, -heightNum / 2, widthNum, heightNum);
        _dragBarBackSprite.graphics.endFill();
        slideBarAllSprite.addChild(_dragBarBackSprite);
        _dragBarSprite = new Sprite;
        _dragBarSprite.graphics.lineStyle(1);
        _dragBarSprite.graphics.beginFill(0xaaaaaa);
        _dragBarSprite.graphics.drawRect(-heightNum, -heightNum, heightNum * 2, heightNum * 2);
        _dragBarSprite.graphics.endFill();
        slideBarAllSprite.addChild(_dragBarSprite);
        _dragBarSprite.addEventListener(MouseEvent.MOUSE_DOWN, dragBarSpriteMouseDownHandler);
        _dragRectangle = new Rectangle();
        _dragRectangle.x = _dragBarBackSprite.x;
        _dragRectangle.y = _dragBarBackSprite.y;
        _dragRectangle.width = _dragBarBackSprite.width;
        _dragRectangle.height = 0;
    }
    
    private function dragBarSpriteMouseDownHandler(event:MouseEvent):void
    {
        _dragBarSprite.removeEventListener(MouseEvent.MOUSE_DOWN, dragBarSpriteMouseDownHandler);
        _dragBarSprite.startDrag(false, _dragRectangle);
        this.stage.addEventListener(MouseEvent.MOUSE_UP, dragBarSpriteMouseUpHandler);
    }
    
    private function dragBarSpriteMouseUpHandler(event:MouseEvent):void
    {
        _dragBarSprite.stopDrag();
        _dragBarSprite.addEventListener(MouseEvent.MOUSE_DOWN, dragBarSpriteMouseDownHandler);
        this.stage.removeEventListener(MouseEvent.MOUSE_UP, dragBarSpriteMouseUpHandler);
    }
    
    public function getDragBarPositionRatio():Number
    {
        var ratio:Number = (this._dragBarSprite.x - this._dragBarBackSprite.x)/_dragBarBackSprite.width;
        return ratio;
    }

}
