/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gIyw
 */

// forked from tepe's flash on 2011-3-19
package {
    import flash.events.*;
    import flash.display.*;
    import flash.text.*;
    //[SWF(backgroundColor=0, width=465, height=465)]
    public class FlashTest extends Sprite {
        private var node1:node = new node();
        private var text1:TextField = new TextField();
        private var box:Tsumiki = new Tsumiki();
        private var sd:SimpleDrawing = new SimpleDrawing();
        private var m:Main =new Main();
        
        public function FlashTest() {
            
            
            
            sd.y = 1000;
            sd.x = 10000;
            sd.alpha =0.5;
            
            
            box.x = 10000;
            node1.map.addChild(box);
            node1.map.addChild(sd);
            node1.map.addChild(m);
            
            //パラボラ曲線の描画
            
            var s2:Shape = new Shape();
            s2.x = 1000;
            s2.y = 3000;
            var st:int = 100; 
            var a:Number =-0.001;
            var i:int;
            with(s2.graphics){
                lineStyle(0,0x00ff00);
                moveTo(st,a*(st*st));
                lineTo(0,0.25/a);
                moveTo(-st,a*(st*st));
                lineTo(0,0.25/a);
                beginFill(0x00ff00);
                drawCircle(0,0.25/a,5);
                endFill();
                lineStyle(0,0xff0000);
                moveTo(-st,a*(st*st));
            
                for(i = -st;i<st;i++){
                    //放物線:y = ax^2
                    lineTo(i,a*(i*i));
                    moveTo(i,a*(i*i));
                }
                    
                lineTo(st,a*(st*st));
            }
            
            node1.map.addChild(s2);
            addChild(node1);
            text1.selectable = false;
            text1.height = 20;
            text1.width = 20;
            text1.textColor = 0xff00ff;
            //text1.border = true;
            addChild(text1);
            //stage.showDefaultContextMenu=false;
            stage.addEventListener(KeyboardEvent.KEY_DOWN,screenMode);
            addEventListener(Event.ENTER_FRAME,function():void{
                
                text1.text = String(node1.scaleSize);
            });


                
        }
        
        private function screenMode(e:KeyboardEvent):void{      
            
            if(e.keyCode == 13){
                if(node1.IsBrowseMode == true)node1.browseOff();
                else node1.browseOn();
                
            }
            else if(e.keyCode == 66){
                node1.returnHome();
            }

            else if(e.keyCode == 71){
                node1.map.removeChild(box);
            }
            else if(e.keyCode == 72){
                node1.map.addChild(box);
            }
            else if(e.keyCode == 73){
                if(stage.displayState == StageDisplayState.FULL_SCREEN){
                    stage.displayState = StageDisplayState.NORMAL;//元に戻す               
                }
                else{
                    stage.displayState = StageDisplayState.FULL_SCREEN;//フルスクリーンモード        
                }
            }


            //e.stopPropagation();//イベントの伝播を止める            
        }
    }
}
//--------------------------------------------------------------------------
// forked from ProjectNya's FlickrMultiLoader [一括読み込み]
// forked from ProjectNya's FlickrMultiLoader
////////////////////////////////////////////////////////////////////////////////
// FlickrMultiLoader [一括読み込み]
//
// [AS3.0] FlickrMultiLoaderクラスだ！ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1033
////////////////////////////////////////////////////////////////////////////////



    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    class Main extends Sprite {
        private var provider:DataProvider;
        private var loader:FlickrMultiLoader;
        private var photoList:Array;
        private var holder:Sprite;
        private var panel:Sprite;
        private var fullscreenBtn:Btn;
        private var normalBtn:Btn;
        private var tags:TextField;
        private static var fontType:String = "_ゴシック";
        private var searchBtn:Btn;

        public function Main() {
            //Wonderfl.capture_delay(10);
            //stage.scaleMode = StageScaleMode.NO_SCALE;
            //stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            graphics.beginFill(0x333333);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            panel = new Sprite();
            addChild(panel);
            panel.x = 232;
            panel.y = 20;
            fullscreenBtn = new Btn();
            panel.addChild(fullscreenBtn);
            fullscreenBtn.x = -110;
            fullscreenBtn.init({label: "full screen", type: 2, width: 100});
            fullscreenBtn.addEventListener(MouseEvent.CLICK, fullscreen, false, 0, true);
            normalBtn = new Btn();
            panel.addChild(normalBtn);
            normalBtn.x = -110;
            normalBtn.init({label: "normal", type: 2, width: 100});
            normalBtn.addEventListener(MouseEvent.CLICK, normal, false, 0, true);
            normalBtn.visible = false;
            var base:Shape = new Shape();
            panel.addChild(base);
            base.graphics.beginFill(0x000000);
            base.graphics.drawRoundRect(-40, -10, 140, 20, 10);
            base.graphics.endFill();
            tags = new TextField();
            panel.addChild(tags);
            tags.x = -30;
            tags.y = -9;
            tags.width = 120;
            tags.height = 19;
            tags.type = TextFieldType.INPUT;
            tags.selectable = true;
            //tags.embedFonts = true;
            //tags.antiAliasType = AntiAliasType.ADVANCED;
            var tf:TextFormat = new TextFormat();
            tf.font = fontType;
            tf.size = 12;
            tf.align = TextFormatAlign.LEFT;
            tags.defaultTextFormat = tf;
            tags.textColor = 0xCCCCCC;
            tags.text = "landscape";
            searchBtn = new Btn();
            panel.addChild(searchBtn);
            searchBtn.x = 130;
            searchBtn.init({label: "search", type: 2});
            searchBtn.addEventListener(MouseEvent.CLICK, search, false, 0, true);
            provider = new DataProvider();
            provider.addEventListener(DataProvider.COMPLETE, complete, false, 0, true);
            loader = new FlickrMultiLoader();
            addChild(loader);
            loader.size(75, 6, 35, 16, 240, 500);
            var colorList:Array = [0xCC0000, 0xFF9900, 0xFFCC00, 0x669900, 0x3399CC, 0x9966CC];
            loader.color = colorList;
            loader.addEventListener(FlickrMultiLoader.ALL_COMPLETE, allComplete, false, 0, true);
            loader.addEventListener(FlickrMultiLoader.ALL_FADE_OUT, allFadeOut, false, 0, true);
            loader.addEventListener(FlickrMultiLoader.UPDATE, update, false, 0, true);
            loader.addEventListener(FlickrMultiLoader.FULL_SCREEN, screenMode, false, 0, true);
            loader.addEventListener(FlickrMultiLoader.NORMAL, screenMode, false, 0, true);
        }
        private function search(evt:MouseEvent):void {
            searchBtn.clicked = true;
            loader.reset();
            provider.search(tags.text, 100);
        }
        private function complete(evt:Event):void {
            var data:Object = evt.target.data;
            loader.dataProvider(data.s, data.m, data.p, data.i);
            loader.start();
        }
        private function allComplete(evt:Event):void {
            trace("allComplete");
        }
        private function allFadeOut(evt:Event):void {
            searchBtn.clicked = false;
        }
        private function update(evt:Event = null):void {
            panel.x = stage.stageWidth*0.5;
        }
        private function screenMode(evt:Event = null):void {
            switch (evt.type) {
                case FlickrMultiLoader.FULL_SCREEN :
                    fullscreenBtn.visible = false;
                    normalBtn.visible = true;
                    break;
                case FlickrMultiLoader.NORMAL :
                    fullscreenBtn.visible = true;
                    normalBtn.visible = false;
                    break;
            }
        }
        private function fullscreen(evt:MouseEvent):void {
            loader.screenMode(true);
        }
        private function normal(evt:MouseEvent):void {
            loader.screenMode(false);
        }

    }




//////////////////////////////////////////////////
// FlickrMultiLoaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Stage;
import flash.display.StageDisplayState;
import flash.display.Shape;
import flash.display.DisplayObject;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.DropShadowFilter;
import flash.filters.BlurFilter;

class FlickrMultiLoader extends Sprite {
    private var bWidth:uint;
    private var cols:uint;
    private var xPos:uint;
    private var distance:uint;
    private var pWidth:uint;
    private var xOffset:uint;
    private var mw:uint;
    private var pw:uint;
    private var photoList:Array;
    private var showList:Array;
    private var mlist:Array;
    private var plist:Array;
    private var infoList:Array;
    private var photo:Sprite;
    private var container:Sprite;
    private var base:Shape;
    private var loader:ProgressLoader;
    private var holderList:Array;
    private var loaderList:Array;
    private var loaded:uint;
    private var completed:uint;
    private var colorList:Array;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private var shade:DropShadowFilter;
    private var enabled:Boolean = true;
    private var nextID:uint;
    private static var deceleration:Number = 0.5;
    private var fullscreen:Boolean = false;
    private var flickr:FlickrBar;
    private var help:HelpPanel;
    public static const ALL_COMPLETE:String = "allcomplete";
    public static const ALL_FADE_OUT:String = "allfadeout";
    public static const UPDATE:String = "update";
    public static const FULL_SCREEN:String = "fullscreen";
    public static const NORMAL:String = "normal";

    public function FlickrMultiLoader() {
        photo = new Sprite();
        loader = new ProgressLoader();
        loader.prog(ProgressBar);
        loader.photo = 16;
        container = loader.container;
        loader.addEventListener(ProgressLoader.INIT, initializePhoto, false, 0, true);
        loader.addEventListener(ProgressLoader.IO_ERROR, ioerrorPhoto, false, 0, true);
        loader.addEventListener(ProgressLoader.COMPLETE, completePhoto, false, 0, true);
        loader.addEventListener(ProgressLoader.FADE_OUT, fadeOutPhoto, false, 0, true);
        loader.addEventListener(ProgressLoader.BAR_FADE_OUT, barFadeOutPhoto, false, 0, true);
        photo.addChild(loader);
        flickr = new FlickrBar();
        if (stage) resize();
        else addEventListener(Event.ADDED_TO_STAGE, resize, false, 0, true);
    }

    private function resize(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, resize);
        stage.addEventListener(Event.RESIZE, update, false, 0, true);
    }
    public function size(w:uint, c:uint, x:uint, d:uint, m:uint, p:uint):void {
        bWidth = w;
        cols = c;
        xPos = x + w*0.5;
        distance = d;
        mw = m;
        pw = p;
        pWidth = mw;
        xOffset = pw;
    }
    public function set color(param:Array):void {
        colorList = param;
    }
    public function dataProvider(pList:Array, m:Array, p:Array, i:Array):void {
        photoList = pList;
        mlist = m;
        plist = p;
        showList = mlist;
        infoList = i;
        init();
    }
    private function init():void {
        shade = new DropShadowFilter(1, 90, sColor, 0.5, 4, 4, 3, 3, false, false);
        holderList = new Array();
        loaderList = new Array();
        for (var n:uint = 0; n < photoList.length; n++) {
            var holder:Sprite = new Sprite();
            holder.name = String(n);
            addChild(holder);
            holderList.push(holder);
            holder.mouseChildren = false;
            var loader:ProgressLoader = new ProgressLoader();
            loader.prog(ProgressArc);
            loader.photo = 4;
            loader.addEventListener(ProgressLoader.INIT, initialize, false, 0, true);
            loader.addEventListener(ProgressLoader.IO_ERROR, ioerror, false, 0, true);
            loader.addEventListener(ProgressLoader.COMPLETE, complete, false, 0, true);
            loader.addEventListener(ProgressLoader.FADE_OUT, fadeOut, false, 0, true);
            loader.addEventListener(ProgressLoader.BAR_FADE_OUT, barFadeOut, false, 0, true);
            holder.addChild(loader);
            loaderList.push(loader);
            var progArc:ProgressArc = ProgressArc(loader.progressBar);
            progArc.color(colorList[n%colorList.length]);
        }
        addChild(photo);
        photo.visible = false;
        photo.mouseChildren = false;
        flickr.y = 135;
        addChild(flickr);
        update();
        help = new HelpPanel();
        addChild(help);
        help.init({width: 120, height: 60, type: 2});
    }
    public function start():void {
        //loaded = 0;
        flickr.init();
        completed = 0;
        //load(loaded);
        for (var n:uint = 0; n < photoList.length; n++) {
            load(n);
        }
    }
    private function load(id:uint):void {
        var loader:ProgressLoader = loaderList[id];
        loader.load(photoList[id]);
    }
    private function count():void {
        loaded++;
        flickr.progress(loaded, photoList.length);
        /*
        if (loaded < photoList.length) {
            load(loaded);
        } else {
            dispatchEvent(new Event(FlickrMultiLoader.ALL_COMPLETE));
        }
        */
        if (loaded > photoList.length - 1) {
            dispatchEvent(new Event(FlickrMultiLoader.ALL_COMPLETE));
        }
    }
    public function reset():void {
        if (completed == 0) return;
        for (var n:uint = 0; n < photoList.length; n++) {
            var loader:ProgressLoader = loaderList[n];
            loader.unload();
        }
    }
    private function initialize(evt:Event):void {
        //evt.target.removeEventListener(ProgressLoader.INIT, initialize);
    }
    private function ioerror(evt:Event):void {
        //evt.target.removeEventListener(ProgressLoader.IO_ERROR, ioerror);
        loadComplete();
        count();
    }
    private function complete(evt:Event):void {
        //evt.target.removeEventListener(ProgressLoader.COMPLETE, complete);
    }
    private function fadeOut(evt:Event):void {
        //evt.target.removeEventListener(ProgressLoader.FADE_OUT, fadeOut);
        var loader:ProgressLoader = ProgressLoader(evt.target);
        var container:Sprite = loader.container;
        var holder:Sprite = Sprite(loader.parent);
        container.visible = true;
        holder.buttonMode = true;
        holder.mouseEnabled = true;
        holder.useHandCursor = true;
        holder.addEventListener(MouseEvent.CLICK, click, false, 0, true);
        holder.addEventListener(MouseEvent.MOUSE_OVER, showHelp, false, 0, true);
        holder.addEventListener(MouseEvent.MOUSE_OUT, hideHelp, false, 0, true);
        count();
    }
    private function barFadeOut(evt:Event):void {
        //evt.target.removeEventListener(ProgressLoader.BAR_FADE_OUT, barFadeOut);
        loadComplete();
    }
    private function loadComplete():void {
        completed++;
        if (completed >= photoList.length) {
            dispatchEvent(new Event(FlickrMultiLoader.ALL_FADE_OUT));
        }
    }
    private function click(evt:MouseEvent):void {
        if (!enabled) return;
        var id:uint = uint(evt.target.name);
        nextID = id;
        slideOut();
    }
    private function loadPhoto(id:uint):void {
        loader.unload();
        if (fullscreen) {
            showList = plist;
        } else {
            showList = mlist;
        }
        loader.load(showList[id]);
        photo.visible = true;
        enable(false);
    }
    private function clickOutSide():void {
        stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown, false, 0, true);
    }
    private function clearOutSide():void {
        stage.removeEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
    }
    private function mouseDown(evt:MouseEvent):void {
        if (!enabled) return;
        if (!photo.hitTestPoint(stage.mouseX, stage.mouseY, true)) {
            clearOutSide();
            nextID = photoList.length;
            slideOut();
        }
    }
    private function enable(flag:Boolean):void {
        enabled = flag;
        for (var n:uint = 0; n < photoList.length; n++) {
            var holder:Sprite = holderList[n];
            holder.mouseEnabled= enabled;
            holder.useHandCursor = enabled;
        }
        stage.mouseChildren= enabled;
    }
    private function initializePhoto(evt:Event):void {
        //evt.target.removeEventListener(ProgressLoader.INIT, initializePhoto);
        photo.visible = true;
    }
    private function ioerrorPhoto(evt:Event):void {
        //evt.target.removeEventListener(ProgressLoader.IO_ERROR, ioerrorPhoto);
        photo.visible = true;
        enable(true);
        clickOutSide();
    }
    private function completePhoto(evt:Event):void {
        //evt.target.removeEventListener(ProgressLoader.COMPLETE, completePhoto);
    }
    private function fadeOutPhoto(evt:Event):void {
        //evt.target.removeEventListener(ProgressLoader.FADE_OUT, fadeOutPhoto);
        container.visible = true;
        var targetPos:int = stage.stageWidth*0.5 + xOffset;
        container.x = - targetPos;
        slideIn();
    }
    private function barFadeOutPhoto(evt:Event):void {
        //evt.target.removeEventListener(ProgressLoader.BAR_FADE_OUT, barFadeOutPhoto);
        enable(true);
        clickOutSide();
    }
    private function slideOut():void {
        if (loader.content) {
            stage.addEventListener(Event.ENTER_FRAME, slideOutPhoto, false, 0, true);
        } else {
            nextPhoto();
        }
    }
    private function slideIn():void {
        stage.addEventListener(Event.ENTER_FRAME, slideInPhoto, false, 0, true);
    }
    private function slideOutPhoto(evt:Event):void {
        var targetPos:int = stage.stageWidth*0.5 + xOffset;
        container.x += (targetPos - container.x)*deceleration;
        var percent:Number = Math.abs(targetPos - container.x)/stage.stageWidth*2;
        blur(percent);
        if (Math.abs(targetPos - container.x) < 0.5) {
            container.x = - targetPos;
            blur(0);
            stage.removeEventListener(Event.ENTER_FRAME, slideOutPhoto);
            nextPhoto();
        }
    }
    private function slideInPhoto(evt:Event):void {
        var targetPos:int = 0;
        container.x += (targetPos - container.x)*deceleration;
        var percent:Number = Math.abs(targetPos - container.x)/stage.stageWidth*2;
        blur(percent);
        if (Math.abs(targetPos - container.x) < 0.5) {
            container.x = targetPos;
            blur(0);
            stage.removeEventListener(Event.ENTER_FRAME, slideInPhoto);
        }
    }
    private function blur(percent:Number):void {
        if (percent > 0) {
            var bx:uint = Math.floor(64*percent);
            var blurX:BlurFilter = new BlurFilter(bx, 0, 3);
            container.filters = [blurX];
        } else {
            container.filters = [];
        }
    }
    private function nextPhoto():void {
        if (nextID < photoList.length) {
            loadPhoto(nextID);
        } else {
            photo.visible = false;
            clearOutSide();
        }
    }
    private function showHelp(evt:MouseEvent):void {
        var id:uint = uint(evt.target.name);
        var title:String = "[" + (id+1) + "] "+ infoList[id].title;
        var type:String;
        if (id%cols == 0) {
            type = "left";
        } else if (id%cols == cols-1) {
            type = "right";
        } else {
            type = "center";
        }
        help.show(title, type);
    }
    private function hideHelp(evt:MouseEvent):void {
        help.hide();
    }
    private function update(evt:Event = null):void {
        dispatchEvent(new Event(FlickrMultiLoader.UPDATE));
        if (stage.displayState == StageDisplayState.FULL_SCREEN) {
            fullscreen = true;
            dispatchEvent(new Event(FlickrMultiLoader.FULL_SCREEN));
            pWidth = mw;
        } else {
            fullscreen = false;
            dispatchEvent(new Event(FlickrMultiLoader.NORMAL));
            pWidth = pw;
        }
        if (!contains(photo)) return;
        var sw:uint = stage.stageWidth;
        var sh:uint = stage.stageHeight;
        cols = Math.floor((sw - distance)/(bWidth + distance));
        xPos = Math.floor((sw - bWidth*cols - distance*(cols-1))*0.5) + bWidth*0.5;
        for (var n:uint = 0; n < photoList.length; n++) {
            var holder:Sprite = holderList[n];
            holder.x = xPos + (bWidth+distance)*(n%cols);
            holder.y = Math.floor(50 + bWidth*0.5) + (bWidth+distance)*Math.floor(n/cols);
        }
        photo.x = sw*0.5;
        photo.y = (sh - 50)*0.5 + 50;
        flickr.x = sw*0.5;
    }
    public function screenMode(mode:Boolean):void {
        if (stage.displayState == StageDisplayState.NORMAL) {
            fullscreen = true;
            stage.displayState = StageDisplayState.FULL_SCREEN;
            dispatchEvent(new Event(FlickrMultiLoader.FULL_SCREEN));
            pWidth = pw;
        } else {
            fullscreen = false;
            stage.displayState = StageDisplayState.NORMAL;
            dispatchEvent(new Event(FlickrMultiLoader.NORMAL));
            pWidth = mw;
        }
    }

}


//////////////////////////////////////////////////
// ProgressLoaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.filters.DropShadowFilter;

class ProgressLoader extends Sprite {
    private var loader:Loader;
    private var info:LoaderInfo;
    public var container:Sprite;
    public var content:*;
    private var base:Shape;
    private var corner:uint;
    private var smoothing:Boolean;
    private var ProgressBar:Class;
    public var progressBar:*;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private var shade:DropShadowFilter;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;
    //public static const FADE_OUT:String = ProgressBar.FADE_OUT;
    //public static const BAR_FADE_OUT:String = ProgressBar.BAR_FADE_OUT;
    public static const FADE_OUT:String = "fadeOut";
    public static const BAR_FADE_OUT:String = "barFadeOut";

    public function ProgressLoader() {
        container = new Sprite();
        addChild(container);
        base = new Shape();
        container.addChild(base);
        shade = new DropShadowFilter(1, 90, sColor, 0.5, 4, 4, 3, 3, false, false);
        base.filters = [shade];
        loader = new Loader();
        container.addChild(loader);
        info = loader.contentLoaderInfo;
    }

    public function prog(Bar:Class):void {
        ProgressBar = Bar;
        progressBar = new ProgressBar();
    }
    public function init(x:int = 0, y:int = 0):void {
        progressBar.x = x;
        progressBar.y = y;
    }
    public function set photo(c:uint):void {
        corner = c;
    }
    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        progressBar.addEventListener(ProgressBar.FADE_OUT, fadeOut, false, 0, true);
        progressBar.addEventListener(ProgressBar.BAR_FADE_OUT, barFadeOut, false, 0, true);
        addChild(progressBar);
        try {
            loader.load(new URLRequest(file));
            progressBar.init();
        } catch (err:Error) {
            progressBar.error(err.message);
        }
    }
    public function unload():void {
        loader.unload();
        if (contains(progressBar)) removeChild(progressBar);
        base.graphics.clear();
    }
    private function progress(evt:ProgressEvent):void {
        progressBar.progress(evt.bytesLoaded, evt.bytesTotal);
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        progressBar.error(evt.type);
        dispatchEvent(new Event(ProgressLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(ProgressLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(ProgressLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        if (smoothing) {
            content = Bitmap(info.content);
            content.smoothing = true;
        } else {
            content = info.content;
        }
        centerize();
        container.visible = false;
        dispatchEvent(new Event(ProgressLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        dispatchEvent(new Event(ProgressLoader.COMPLETE));
    }
    private function fadeOut(evt:Event):void {
        evt.target.removeEventListener(ProgressBar.FADE_OUT, fadeOut);
        dispatchEvent(new Event(ProgressBar.FADE_OUT));
    }
    private function barFadeOut(evt:Event):void {
        evt.target.removeEventListener(ProgressBar.BAR_FADE_OUT, barFadeOut);
        removeChild(progressBar);
        dispatchEvent(new Event(ProgressBar.BAR_FADE_OUT));
    }
    private function centerize():void {
        var w:uint = content.width;
        var h:uint = content.height;
        var cx:int = -uint(w*0.5);
        var cy:int = -uint(h*0.5);
        content.x = cx;
        content.y = cy;
        base.graphics.beginFill(bColor);
        base.graphics.drawRect(cx-corner, cy-corner, w+corner*2, h+corner*2);
        base.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// ProgressBarクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class ProgressBar extends Sprite {
    private var base:Shape;
    private var bar:Sprite;
    private var stripe:Shape;
    private var prog:Shape;
    private var inner:Shape;
    private var title:TextField;
    private var txt:TextField;
    private var total:TextField;
    private static var label:String = "loading...";
    private static var fontType:String = "_ゴシック";
    private static var _width:uint = 220;
    private static var _height:uint = 40;
    private static var bHeight:uint = 10;
    private static var tWidth:uint = 55;
    private static var tHeight:uint = 20;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var tColor:uint = 0x999999;
    private static var s1Color:uint = 0xABCDFB;
    private static var s2Color:uint = 0x71A8F1;
    private static var e1Color:uint = 0xFFFF00;
    private static var e2Color:uint = 0x333333;
    private var baseShade:DropShadowFilter;
    private var barShade:DropShadowFilter;
    private var _percent:Number = 0;
    private var targetPercent:Number;
    private var basePos:Number;
    private static var interval:uint = 500;
    private static var deceleration:Number = 0.4;
    private var timer:Timer;
    public static const FADE_OUT:String = "fadeOut";
    public static const BAR_FADE_OUT:String = "barFadeOut";

    public function ProgressBar() {
        draw();
        percent = 0;
        visible = false;
    }

    private function draw():void {
        createChildren();
        createText();
    }
    private function createChildren():void {
        baseShade = new DropShadowFilter(0, 90, sColor, 0.5, 4, 4, 1.5, 2, false, false);
        barShade = new DropShadowFilter(0, 90, sColor, 0.3, 4, 4, 1.5, 2, true, false);
        base = new Shape();
        bar = new Sprite();
        inner = new Shape();
        stripe = new Shape();
        prog = new Shape();
        addChild(base);
        addChild(bar);
        bar.addChild(inner);
        bar.addChild(stripe);
        bar.addChild(prog);
        createBase(base, -_width*0.5, -_height*0.5, _width, _height, bColor);
        base.filters = [baseShade];
        bar.x = -_width*0.5 + 10;
        bar.y = -2;
        bar.filters = [barShade];
        createBase(inner, 0, 0, _width-20, bHeight, bColor);
        createStripe(stripe, _width-20, bHeight, [s1Color, s2Color]);
        createBase(prog, 0, 0, _width-20, bHeight, sColor);
        stripe.mask = prog;
    }
    private function createText():void {
        title = new TextField();
        txt = new TextField();
        total = new TextField();
        addChild(title);
        addChild(txt);
        addChild(total);
        title.x = -tWidth;
        title.y = -_height*0.5 + 2;
        title.width = tWidth;
        title.height = tHeight - 2;
        title.type = TextFieldType.DYNAMIC;
        title.selectable = false;
        //title.embedFonts = true;
        //title.antiAliasType = AntiAliasType.ADVANCED;
        var tfl:TextFormat = new TextFormat();
        tfl.font = fontType;
        tfl.size = 10;
        tfl.align = TextFormatAlign.LEFT;
        title.defaultTextFormat = tfl;
        title.text = label;
        txt.x = 0;
        txt.y = -_height*0.5 + 2;
        txt.width = tWidth;
        txt.height = tHeight - 2;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tfr:TextFormat = new TextFormat();
        tfr.font = fontType;
        tfr.size = 10;
        tfr.align = TextFormatAlign.RIGHT;
        txt.defaultTextFormat = tfr;
        total.x = -tWidth;
        total.y = 8;
        total.width = tWidth*2;
        total.height = 12;
        total.type = TextFieldType.DYNAMIC;
        total.selectable = false;
        //total.embedFonts = true;
        //total.antiAliasType = AntiAliasType.ADVANCED;
        var tfc:TextFormat = new TextFormat();
        tfc.font = fontType;
        tfc.size = 8;
        tfc.align = TextFormatAlign.CENTER;
        total.defaultTextFormat = tfc;
        total.textColor = tColor;
    }
    public function init():void {
        basePos = y;
        alpha = 1;
        total.text = "0KB";
        createStripe(stripe, _width-20, bHeight, [s1Color, s2Color]);
        percent = 0;
        visible = true;
    }
    public function error(e:String):void {
        alpha = 1;
        txt.text = "0%";
        total.text = e;
        createStripe(stripe, _width-20, bHeight, [e1Color, e2Color]);
        prog.scaleX = 1;
        visible = true;
    }
    public function progress(l:Number, t:Number):void {
        total.text = Math.ceil(t/1024) + "KB";
        targetPercent = Math.round(l/t*100);
        addEventListener(Event.ENTER_FRAME, progressTo, false, 0, true);
    }
    private function progressTo(evt:Event):void {
        percent += (targetPercent - percent)*deceleration;
        if (Math.abs(targetPercent - percent) < 0.5) {
            percent = targetPercent;
            removeEventListener(Event.ENTER_FRAME, progressTo);
        }
        if (percent >= 100) {
            dispatchEvent(new Event(ProgressBar.FADE_OUT));
            timer = new Timer(interval, 1);
            timer.addEventListener(TimerEvent.TIMER, fadeOut, false, 0, true);
            timer.start();
        }
    }
    private function fadeOut(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER, fadeOut);
        addEventListener(Event.ENTER_FRAME, barFadeOut, false, 0, true);
    }
    private function barFadeOut(evt:Event):void {
        var speed:Number = 0.05;
        y += 20*speed;
        alpha -= speed;
        if (alpha <= 0) {
            removeEventListener(Event.ENTER_FRAME, barFadeOut);
            y = basePos;
            alpha = 0;
            visible = false;
            dispatchEvent(new Event(ProgressBar.BAR_FADE_OUT));
        }
    }
    public function get percent():Number {
        return _percent;
    }
    public function set percent(param:Number):void {
        _percent = param;
        manage(_percent);
    }
    private function manage(p:Number):void {
        txt.text = String(Math.round(p)) + "%";
        prog.scaleX = p/100;
    }
    private function createBase(target:Shape, x:int, y:int, w:uint, h:uint, color:uint):void {
        target.graphics.beginFill(color);
        target.graphics.drawRect(x, y, w, h);
        target.graphics.endFill();
    }
    private function createStripe(target:Shape, w:uint, h:uint, colors:Array):void {
        target.graphics.clear();
        for (var n:uint = 0; n <= Math.ceil(w/h); n++) {
            target.graphics.beginFill(colors[n%2]);
            target.graphics.moveTo(h*(n-1), 0);
            target.graphics.lineTo(h*n, h);
            target.graphics.lineTo(h*(n+1), h);
            target.graphics.lineTo(h*n, 0);
            target.graphics.lineTo(h*(n-1), 0);
            target.graphics.endFill();
        }
    }

}


//////////////////////////////////////////////////
// ProgressArcクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.geom.Point;
import flash.display.Graphics;

class ProgressArc extends Sprite {
    private var base:Shape;
    private var prog:Shape;
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private static var radius:uint = 20;
    private static var thickness:uint = 10;
    private static var outer:uint;
    private static var inner:uint;
    private static var tWidth:uint = 80;
    private var aColor:uint;
    private static var eColor:Number = 0x666666;
    private static var tColor:Number = 0xFFFFFF;
    private static var sColor:Number = 0x000000;
    private var shade:DropShadowFilter;
    private var _percent:Number = 0;
    private var targetPercent:Number = 0;
    private static var interval:uint = 500;
    private static var deceleration:Number = 0.4;
    private var timer:Timer;
    public static const FADE_OUT:String = "fadeOut";
    public static const BAR_FADE_OUT:String = "barFadeOut";

    public function ProgressArc() {
        outer = radius + thickness/2;
        inner = radius - thickness/2;
        draw();
        percent = 0;
        visible = false;
    }

    private function draw():void {
        createChildren();
        createText();
    }
    private function createChildren():void {
        shade = new DropShadowFilter(1, 90, sColor, 0.3, 4, 4, 2, 3, false, false);
        base = new Shape();
        prog = new Shape();
        addChild(base);
        addChild(prog);
        prog.filters = [shade];
    }
    private function createText():void {
        txt = new TextField();
        addChild(txt);
        txt.x = -tWidth/2;
        txt.y = -6;
        txt.width = tWidth;
        txt.height = 14;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 10;
        tf.align = TextFormatAlign.CENTER;
        txt.textColor = tColor;
        txt.defaultTextFormat = tf;
    }
    public function init():void {
        alpha = 1;
        percent = 0;
        visible = true;
    }
    public function error(e:String):void {
        alpha = 1;
        txt.text = e;
        createArc(prog, 1, eColor);
        visible = true;
    }
    public function progress(l:Number, t:Number):void {
        targetPercent = Math.round(l/t*100);
        addEventListener(Event.ENTER_FRAME, progressTo, false, 0, true);
    }
    private function progressTo(evt:Event):void {
        percent += (targetPercent - percent)*deceleration;
        if (Math.abs(targetPercent - percent) < 0.5) {
            percent = targetPercent;
            removeEventListener(Event.ENTER_FRAME, progressTo);
        }
        if (percent >= 100) {
            dispatchEvent(new Event(ProgressArc.FADE_OUT));
            timer = new Timer(interval, 1);
            timer.addEventListener(TimerEvent.TIMER, fadeOut, false, 0, true);
            timer.start();
        }
    }
    private function fadeOut(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER, fadeOut);
        addEventListener(Event.ENTER_FRAME, barFadeOut, false, 0, true);
    }
    private function barFadeOut(evt:Event):void {
        var speed:Number = 0.05;
        alpha -= speed;
        if (alpha <= 0) {
            removeEventListener(Event.ENTER_FRAME, barFadeOut);
            alpha = 0;
            visible = false;
            dispatchEvent(new Event(ProgressArc.BAR_FADE_OUT));
        }
    }
    public function get percent():Number {
        return _percent;
    }
    public function set percent(param:Number):void {
        _percent = param;
        manage(_percent);
    }
    private function manage(p:Number):void {
        txt.text = String(Math.round(p)) + "%";
        createArc(prog, p/100, aColor);
    }
    //円弧(ドーナツ型)を描く
    private function createArc(target:Shape, percent:Number, color:uint):void {
        target.graphics.clear();
        target.graphics.beginFill(color);
        drawRing(target, 0, 0, outer, inner, 360*percent, -90);
        target.graphics.endFill();
    }
    private function drawRing(target:Shape, x:Number, y:Number, outerRadius:Number, innerRadius:Number, degree:Number=360, fromDegree:Number=0, split:Number=36):void {
        var points:Array = getRingPoints(x, y, outerRadius, innerRadius, degree, fromDegree, split);
        drawLines(target, points, true);
    }
    private function getRingPoints(x:Number, y:Number, outerRadius:Number, innerRadius:Number, degree:Number=360, fromDegree:Number=0, split:Number=36):Array {
        var fromRad:Number = fromDegree*Math.PI/180;
        var dr:Number = (degree* Math.PI/180)/split;
        var pt:Point;
        var imax:int = split +1;
        var rad:Number;
        var points:Array = new Array();
        for(var i:int=0; i < imax; i++) {
            pt = new Point();
            rad = fromRad + dr*i;
            pt.x = Math.cos(rad)*outerRadius+x;
            pt.y = Math.sin(rad)*outerRadius+y;
            points.push(pt);
        }
        var points2:Array = [];
        for(i=0; i<imax; i++){
            pt = new Point();
            rad = fromRad + dr*i;
            pt.x = Math.cos(rad)*innerRadius+x;
            pt.y = Math.sin(rad)*innerRadius+y;
            points2.push(pt);
        }
        points2.reverse();
        points = points.concat(points2);
        return points;
    }
    private function drawLines(target:Shape, points:Array, close:Boolean=false):void {
        var imax:Number = points.length;
        target.graphics.moveTo(points[0].x, points[0].y);
        for(var i:Number=1; i<imax; i++) {
            target.graphics.lineTo(points[i].x, points[i].y);
        }
        if(close) target.graphics.lineTo(points[0].x, points[0].y);
    }
    public function color(param:uint):void {
        aColor = param;
    }

}


//////////////////////////////////////////////////
// FlickrBarクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class FlickrBar extends Sprite {
    private var base:Shape;
    private var bar:Sprite;
    private var stripe:Shape;
    private var prog:Shape;
    private var inner:Shape;
    private var title:TextField;
    private var txt:TextField;
    private var total:TextField;
    private static var label:String = "loading...";
    private static var fontType:String = "_ゴシック";
    private static var _width:uint = 220;
    private static var _height:uint = 40;
    private static var bHeight:uint = 10;
    private static var tWidth:uint = 55;
    private static var tHeight:uint = 20;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var tColor:uint = 0x999999;
    private static var s1Color:Number = 0xCCE6FF;
    private static var s2Color:Number = 0x0280FD;
    private static var s3Color:Number = 0xFD3EB0;
    private static var e1Color:Number = 0xFFFF00;
    private static var e2Color:Number = 0x333333;
    private static var e3Color:Number = 0x333333;
    private var baseShade:DropShadowFilter;
    private var barShade:DropShadowFilter;
    private var _percent:Number = 0;
    private var targetPercent:Number;
    private var basePos:Number;
    private static var interval:uint = 500;
    private static var deceleration:Number = 0.4;
    private var timer:Timer;
    public static const FADE_OUT:String = "fadeOut";
    public static const BAR_FADE_OUT:String = "barFadeOut";

    public function FlickrBar() {
        draw();
        percent = 0;
        visible = false;
    }

    private function draw():void {
        createChildren();
        createText();
    }
    private function createChildren():void {
        baseShade = new DropShadowFilter(0, 90, sColor, 0.5, 4, 4, 1.5, 2, false, false);
        barShade = new DropShadowFilter(0, 90, sColor, 0.3, 4, 4, 1.5, 2, true, false);
        base = new Shape();
        bar = new Sprite();
        inner = new Shape();
        stripe = new Shape();
        prog = new Shape();
        addChild(base);
        addChild(bar);
        bar.addChild(inner);
        bar.addChild(stripe);
        bar.addChild(prog);
        createBase(base, -_width*0.5, -_height*0.5, _width, _height, bColor);
        base.filters = [baseShade];
        bar.x = -_width*0.5 + 10;
        bar.y = -2;
        bar.filters = [barShade];
        createBase(inner, 0, 0, _width-20, bHeight, bColor);
        createStripe(stripe, _width-20, bHeight, [s1Color, s2Color, s3Color]);
        createBase(prog, 0, 0, _width-20, bHeight, sColor);
        stripe.mask = prog;
    }
    private function createText():void {
        title = new TextField();
        txt = new TextField();
        total = new TextField();
        addChild(title);
        addChild(txt);
        addChild(total);
        title.x = -tWidth;
        title.y = -_height*0.5 + 2;
        title.width = tWidth;
        title.height = tHeight - 2;
        title.type = TextFieldType.DYNAMIC;
        title.selectable = false;
        //title.embedFonts = true;
        //title.antiAliasType = AntiAliasType.ADVANCED;
        var tfl:TextFormat = new TextFormat();
        tfl.font = fontType;
        tfl.size = 10;
        tfl.align = TextFormatAlign.LEFT;
        title.defaultTextFormat = tfl;
        title.text = label;
        txt.x = 0;
        txt.y = -_height*0.5 + 2;
        txt.width = tWidth;
        txt.height = tHeight - 2;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tfr:TextFormat = new TextFormat();
        tfr.font = fontType;
        tfr.size = 10;
        tfr.align = TextFormatAlign.RIGHT;
        txt.defaultTextFormat = tfr;
        total.x = -tWidth;
        total.y = 8;
        total.width = tWidth*2;
        total.height = 14;
        total.type = TextFieldType.DYNAMIC;
        total.selectable = false;
        //total.embedFonts = true;
        //total.antiAliasType = AntiAliasType.ADVANCED;
        var tfc:TextFormat = new TextFormat();
        tfc.font = fontType;
        tfc.size = 8;
        tfc.align = TextFormatAlign.CENTER;
        total.defaultTextFormat = tfc;
        total.textColor = tColor;
        total.text = "photos";
    }
    public function init():void {
        basePos = y;
        alpha = 1;
        createStripe(stripe, _width-20, bHeight, [s1Color, s2Color, s3Color]);
        percent = 0;
        visible = true;
    }
    public function error(e:String):void {
        alpha = 1;
        txt.text = "0%";
        createStripe(stripe, _width-20, bHeight, [e1Color, e2Color, e3Color]);
        prog.scaleX = 1;
        visible = true;
    }
    public function progress(l:Number, t:Number):void {
        targetPercent = Math.round(l/t*100);
        addEventListener(Event.ENTER_FRAME, progressTo, false, 0, true);
    }
    private function progressTo(evt:Event):void {
        percent += (targetPercent - percent)*deceleration;
        if (Math.abs(targetPercent - percent) < 0.5) {
            percent = targetPercent;
            removeEventListener(Event.ENTER_FRAME, progressTo);
        }
        if (percent >= 100) {
            dispatchEvent(new Event(FlickrBar.FADE_OUT));
            timer = new Timer(interval, 1);
            timer.addEventListener(TimerEvent.TIMER, fadeOut, false, 0, true);
            timer.start();
        }
    }
    private function fadeOut(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER, fadeOut);
        addEventListener(Event.ENTER_FRAME, barFadeOut, false, 0, true);
    }
    private function barFadeOut(evt:Event):void {
        var speed:Number = 0.05;
        y += 20*speed;
        alpha -= speed;
        if (alpha <= 0) {
            removeEventListener(Event.ENTER_FRAME, barFadeOut);
            y = basePos;
            alpha = 0;
            visible = false;
            dispatchEvent(new Event(FlickrBar.BAR_FADE_OUT));
        }
    }
    public function get percent():Number {
        return _percent;
    }
    public function set percent(param:Number):void {
        _percent = param;
        manage(_percent);
    }
    private function manage(p:Number):void {
        txt.text = String(Math.round(p)) + "%";
        prog.scaleX = p/100;
    }
    private function createBase(target:Shape, x:int, y:int, w:uint, h:uint, color:uint):void {
        target.graphics.beginFill(color);
        target.graphics.drawRect(x, y, w, h);
        target.graphics.endFill();
    }
    private function createStripe(target:Shape, w:uint, h:uint, colors:Array):void {
        target.graphics.clear();
        for (var n:uint = 0; n <= Math.ceil(w/h); n++) {
            if (n == Math.ceil(w/h) - 1) {
                target.graphics.beginFill(colors[2]);
            } else {
                target.graphics.beginFill(colors[n%2]);
            }
            target.graphics.moveTo(h*(n-1), 0);
            target.graphics.lineTo(h*n, h);
            target.graphics.lineTo(h*(n+1), h);
            target.graphics.lineTo(h*n, 0);
            target.graphics.lineTo(h*(n-1), 0);
            target.graphics.endFill();
        }
    }

}


//////////////////////////////////////////////////
// HelpPanelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.events.Event;
import flash.events.MouseEvent;

class HelpPanel extends Sprite {
    private var base:Sprite;
    private var panel:Shape;
    private var arrow:Shape;
    private var board:Shape;
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var px:uint;
    private var py:uint;
    private var _width:uint = 100;
    private var _height:uint = 60;
    private var type:uint = 1;
    private static var xOffset:uint = 15;
    private static var yOffset:uint = 10;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var cColor:uint = 0xEEEEEE;
    private static var tColor:uint = 0x000000;
    private var shade:DropShadowFilter;
    private static var typeL:String = "left";
    private static var typeC:String = "center";
    private static var typeR:String = "right";
    private var _type:String = typeC;
    private var deceleration:Number = 0.25;
    private var step:uint = 10;
    private var _visible:Boolean = false;

    public function HelpPanel() {
        if (stage) initialize();
        else addEventListener(Event.ADDED_TO_STAGE, initialize, false, 0, true);
    }

    public function init(option:Object):void {
        if (option.width != undefined) _width = option.width;
        if (option.height != undefined) _height = option.height;
        if (option.type != undefined) type = option.type;
        if (option.dec) deceleration = option.dec;
        if (option.step) step = option.step;
        draw();
    }
    private function draw():void {
        switch (type) {
            case 1 :
                bColor = 0xFFFFFF;
                cColor = 0xEEEEEE;
                tColor = 0x000000;
                break;
            case 2 :
                bColor = 0x000000;
                cColor = 0x333333;
                tColor = 0xFFFFFF;
                break;
        }
        shade = new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 1.5, 2, false, false);
        base = new Sprite();
        panel = new Shape();
        arrow = new Shape();
        board = new Shape();
        txt = new TextField();
        addChild(base);
        base.addChild(panel);
        base.addChild(arrow);
        base.addChild(board);
        base.addChild(txt);
        createBox(panel, -_width*0.5, -_height, _width, _height, 4);
        createArrow(arrow, 6, 8);
        createBase(board, -_width*0.5+5, -_height+5, _width-10, _height-10);
        base.y = - yOffset;
        txt.x = -_width*0.5 + 8;
        txt.y = -_height + 8;
        txt.width = _width - 16;
        txt.height = _height - 16;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        txt.multiline = true;
        txt.wordWrap = true;
        txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 10;
        tf.align = TextFormatAlign.LEFT;
        txt.defaultTextFormat = tf;
        txt.textColor = tColor;
        filters = [shade];
    }
    private function initialize(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, initialize);
        visible = false;
        x = stage.stageWidth*0.5;
        y = stage.stageHeight*0.5;
        stage.addEventListener(Event.ENTER_FRAME, move, false, 0, true);
        mouseChildren = false;
        mouseEnabled = false;
    }
    private function update(t:String):void {
        switch (t) {
            case typeL :
                base.x = _width*0.5 - xOffset;
                arrow.x = - _width*0.5 + xOffset;
                break;
            case typeC :
                base.x = 0;
                arrow.x = 0;
                break;
            case typeR :
                base.x = - _width*0.5 + xOffset;
                arrow.x = _width*0.5 - xOffset;
                break;
        }
    }
    private function move(evt:Event):void {
        var xMouse:uint = stage.mouseX;
        var yMouse:uint = stage.mouseY;
        if (xMouse >= 0 && xMouse <= stage.stageWidth) {
            px += (xMouse - px)*deceleration;
            py += (yMouse - py)*deceleration;
        }
        x = Math.round(px);
        y = Math.round(py);
        showPanel();
    }
    private function showPanel():void {
        var a:Number = 1/step;
        if (_visible) {
            visible = true;
            alpha += a;
            if (alpha >= 1) alpha = 1;
            update(_type);
        } else {
            alpha -= a;
            if (alpha <= 0) {
                alpha = 0;
                visible = false;
            }
        }
    }
    public function show(t:String, tp:String):void {
        txt.text = t;
        _visible = true;
        setType(tp);
    }
    public function hide():void {
        _visible = false;
    }
    private function setType(param:String):void {
        switch (param) {
            case typeL :
            case typeC :
            case typeR :
                _type = param;
                break;
            default :
                _type = typeC;
                break;
        }
    }
    private function createBox(target:Shape, x:int, y:int, w:uint, h:uint, c:uint):void {
        target.graphics.beginFill(bColor);
        target.graphics.drawRoundRect(x, y, w, h, c*2);
        target.graphics.endFill();
    }
    private function createArrow(target:Shape, w:uint, h:uint):void {
        target.graphics.beginFill(bColor);
        target.graphics.moveTo(0, 0);
        target.graphics.lineTo(-w*0.5, 0);
        target.graphics.lineTo(0, h);
        target.graphics.lineTo(w*0.5, 0);
        target.graphics.lineTo(0, 0);
        target.graphics.endFill();
    }
    private function createBase(target:Shape, x:int, y:int, w:uint, h:uint):void {
        target.graphics.beginFill(cColor);
        target.graphics.drawRect(x, y, w, h);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// DataProviderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.system.Security;
import flash.events.Event;

class DataProvider extends Sprite {
    private var loader:TextLoader;
    private var dataXML:XML;
    public var data:Object;
    private var sList:Array;
    private var tList:Array;
    private var mList:Array;
    private var pList:Array;
    private var oList:Array;
    private var iList:Array;
    private static var reqURL:String = "http://api.flickr.com/services/rest/";
    private static var method:String = "method=flickr.photos.search";
    private static var key:String = "7a4e79f1dbe398cd714ecd6dbe6a9cbb";
    private var flickrURL:String;
    public static const COMPLETE:String = Event.COMPLETE;
    public static const ERROR:String = "error";

    public function DataProvider() {
        Security.loadPolicyFile("http://api.flickr.com/crossdomain.xml");
        Security.loadPolicyFile("http://farm1.static.flickr.com/crossdomain.xml");
        Security.loadPolicyFile("http://farm2.static.flickr.com/crossdomain.xml");
        Security.loadPolicyFile("http://farm3.static.flickr.com/crossdomain.xml");
        Security.loadPolicyFile("http://farm4.static.flickr.com/crossdomain.xml");
        Security.loadPolicyFile("http://farm5.static.flickr.com/crossdomain.xml");
        init();
    }

    private function init():void {
        sList = new Array();
        tList = new Array();
        mList = new Array();
        pList = new Array();
        oList = new Array();
        iList = new Array();
        loader = new TextLoader();
        loader.addEventListener(TextLoader.COMPLETE, complete, false, 0, true);
    }
    public function search(tags:String, n:uint):void {
        var option:String = "&license=1,2,3,4,5,6&sort=interestingness-desc&per_page=" + n;
        flickrURL = reqURL + "?" + method +"&api_key=" + key + "&tags=" + tags + option;
        try {
            loader.load(flickrURL);
        } catch (err:Error) {
            dispatchEvent(new Event(DataProvider.ERROR));
        }
    }
    private function complete(evt:Event):void {
        var xml:XML = new XML(evt.target.data);
        xml.ignoreWhite = true;
        for (var n:uint = 0; n < xml.photos.photo.length(); n++) {
            var element:XML = xml.photos.photo[n];
            var farm:String = element.@farm;
            var server:String = element.@server;
            var id:String = element.@id;
            var secret:String = element.@secret;
            var title:String = element.@title;
            var owner:String = element.@owner;
            var basePath:String = "http://farm" + farm + ".static.flickr.com/" + server +"/" + id + "_" + secret;
            sList[n] = basePath + "_s.jpg";
            tList[n] = basePath + "_t.jpg";
            mList[n] = basePath + "_m.jpg";
            pList[n] = basePath + ".jpg";
            oList[n] = basePath + "_o.jpg";
            iList[n] = {title: title, owner: owner};
        }
        data = {s: sList, t: tList, m: mList, p: pList, o: oList, i:iList};
        dispatchEvent(new Event(DataProvider.COMPLETE));
    }

}


//////////////////////////////////////////////////
// TextLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.net.URLLoader;
import flash.net.URLLoaderDataFormat;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;

class TextLoader extends EventDispatcher {
    private var loader:URLLoader;
    private var _data:*;
    public static const TEXT:String = URLLoaderDataFormat.TEXT;
    public static const BINARY:String = URLLoaderDataFormat.BINARY;
    public static const COMPLETE:String = "complete";

    public function TextLoader() {
        loader = new URLLoader();
    }

    public function load(file:String, format:String = TextLoader.TEXT):void {
        loader.dataFormat = format;
        loader.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        loader.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        loader.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    private function ioerror(evt:IOErrorEvent):void {
        trace(evt.text);
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        trace(evt.status);
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        trace(evt.text);
    }
    private function complete(evt:Event):void {
        loader.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        loader.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        loader.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        loader.removeEventListener(Event.COMPLETE, complete);
        _data = evt.target.data;
        dispatchEvent(new Event(TextLoader.COMPLETE));
    }
    public function get data():* {
        return _data;
    }

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}





//--------------------------------------------------------------------------------


    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.*;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;

    class Tsumiki extends Sprite {
        private var DRAW_SCALE:Number = 100;
        private var world:b2World;
        private var boxBegin:Point = new Point();
        private var rect:Sprite = new Sprite();
        
        private var s2:Sprite = new Sprite();
        
        public function Tsumiki():void {
            var s:Sprite = new Sprite();
                s.graphics.beginFill(0x000000,1)
                s.graphics.drawRect(-5000,-5000,10000,10000);
                s.graphics.endFill();
            
            addChild(s);
            addChild(s2);
            ////////////////////////////////////////
            // 物理エンジンのセットアップ
            
            // 外枠を定義する
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100, -100);
            worldAABB.upperBound.Set(100, 100);
            
            // 重力を下方向に10m/s^2とする
            var gravity:b2Vec2 = new b2Vec2(0, 10);
            
            // 外枠と重力を指定して、物理エンジン全体をセットアップする
            world = new b2World(worldAABB, gravity, true);
            
            ////////////////////////////////////////
            // 床の設置
            // 床は画面の下のほうに設置します
            
            // 床の位置を左から2.5m、上から3mとする
            var floorBodyDef:b2BodyDef = new b2BodyDef();
            floorBodyDef.position.Set(2.5, 3);
            
            // 床の形を、幅4m、厚さ20cmとする
            // 指定するのはその半分の値
            var floorShapeDef:b2PolygonDef = new b2PolygonDef();
            floorShapeDef.SetAsBox(2, 0.1);
            
            // 床を動かない物体として作る
            var floor:b2Body = world.CreateBody(floorBodyDef);
            floor.CreateShape(floorShapeDef);
            
            ////////////////////////////////////////
            // 描画設定
            
            var debugDraw:b2DebugDraw = new b2DebugDraw();
            debugDraw.m_sprite = s2;//this;
            debugDraw.m_drawScale = DRAW_SCALE; // 1mを100ピクセルにする
            debugDraw.m_fillAlpha = 0.3; // 不透明度
            debugDraw.m_lineThickness = 1; // 線の太さ
            debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
            world.SetDebugDraw(debugDraw);
            
            // イベントハンドラを登録する
            this.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);//矩形生成開始
            this.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);//矩形生成
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            //stage.addEventListener(MouseEvent.MOUSE_WHEEL,onWheel);//ズーム
            addChild(rect);
        }

        
        private function mouseDownHandler(event:MouseEvent):void {
            // マウスが押された場所を記憶しておく
            boxBegin.x = mouseX;
            boxBegin.y = mouseY;
            stage.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
            addChild(rect);
            
           
        }
        //矩形描画
        private function onMove(e:MouseEvent):void{
            rect.graphics.clear();
            rect.graphics.lineStyle(1,0xffffff,0.5);
            rect.graphics.beginFill(0xffffff,0.2);
            rect.graphics.drawRect(boxBegin.x,boxBegin.y,mouseX-boxBegin.x,mouseY-boxBegin.y);
            rect.graphics.endFill();
        }

        //オブジェクト生成
        private function mouseUpHandler(event:MouseEvent):void {
            rect.graphics.clear();
            removeChild(rect);
            
            stage.removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            // 箱の場所と大きさを計算する
            var x:Number = (mouseX + boxBegin.x ) / 2 / DRAW_SCALE ;
            var y:Number = (mouseY + boxBegin.y) / 2 / DRAW_SCALE ; 
            var halfWidth:Number = Math.abs(mouseX - boxBegin.x ) / 2 / DRAW_SCALE ;
            var halfHeight:Number = Math.abs(mouseY - boxBegin.y) / 2 / DRAW_SCALE ;
            
            // 小さすぎる箱ができるのを防ぐ
            if (halfWidth < 0.05 || halfHeight < 0.05) {
                return;
            }
            
            // 箱の場所を設定する
            var bodyDef:b2BodyDef = new b2BodyDef();
            bodyDef.position.Set(x, y);
            
            // 箱の大きさなどを設定する
            var shapeDef:b2PolygonDef= new b2PolygonDef();
            shapeDef.SetAsBox(halfWidth, halfHeight);
            shapeDef.density = 1;     // 密度 [kg/m^2]
            shapeDef.restitution = 0.1;  // 反発係数、通常は0～1
            shapeDef.friction = 1.5;
            
            // 箱を動く物体として作る
            var body:b2Body = world.CreateBody(bodyDef);
            body.CreateShape(shapeDef);//形状描画
            body.SetMassFromShapes();//動く
            
            
            var Image:Sprite = new Sprite();
            //Image.graphics.lineStyle(1,0x000000);
            Image.graphics.beginFill(0xffff00,0);            
            
            Image.graphics.drawRect(0, 0, Math.abs(mouseX - boxBegin.x), Math.abs(mouseY - boxBegin.y));
            Image.graphics.endFill();
            
            
            //Image.width = 0.3 * DRAW_SCALE;
            //Image.height = 0.3 * DRAW_SCALE;
            Image.x = -Image.width / 2;
            Image.y = -Image.height / 2;
            body.m_userData = new Sprite();
            body.GetUserData().x = body.GetWorldCenter().x * DRAW_SCALE;
            body.GetUserData().y = body.GetWorldCenter().y * DRAW_SCALE;
            body.GetUserData().addChild(Image);
            addChild(body.GetUserData());
            body.GetUserData().addEventListener(MouseEvent.MOUSE_OVER,function():void{
                var w:Number = Image.width-1;
                
                var h:Number = Image.height-1;
                Image.graphics.clear();
                //Image.graphics.lineStyle(1,0x000000);
                Image.graphics.beginFill(0x00ff00,0);            
            
                Image.graphics.drawRect(0, 0, w, h);
                Image.graphics.endFill();
            });

            
            
        }
        
        private function enterFrameHandler(event:Event):void {
            
             // ワールド内の全てのb2Bodyに対する処理
            for (var b:b2Body = world.GetBodyList(); b; b = b.GetNext()) {
                if (b.GetUserData() is Sprite) {
                    // 物理エンジン内での位置と回転角度を反映させる
                    b.GetUserData().x = b.GetWorldCenter().x * DRAW_SCALE;
                    b.GetUserData().y = b.GetWorldCenter().y * DRAW_SCALE;
                    b.GetUserData().rotation = b.GetAngle() * 180 / Math.PI;
                    if(b.IsFrozen() == true){
                        world.DestroyBody(b);
                        removeChild(b.m_userData);
                    }

                }
                
            }
            
            // Flashはデフォルトで秒間24フレームなので、
            // 物理シミュレーションを1/24秒進める
            world.Step(1 / 24, 10);
        }
    }




//------------------------------------------------------------------------------

//------------------------------------------------------




// forked from naoto5959's お絵描きツール

    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    
class SimpleDrawing extends Sprite{
        private static const CANVAS_WIDTH:Number = 435;
        private static const CANVAS_HEIGHT:Number = 465;
        private static const RECOVERBLE:Number = 10;//リドゥ回数
        
        public function SimpleDrawing()
        {
            var bitmapData:BitmapData = new BitmapData(2, 2, true, 0x33AB7C10);
            bitmapData.setPixel(0, 0, 0x33ffffff);
            var background:Sprite = new Sprite();
            //background.graphics.lineStyle(0,0x000000);
            background.graphics.beginFill(0xffffff);
            background.graphics.drawRect(0,0,CANVAS_WIDTH, CANVAS_HEIGHT);
            background.graphics.endFill();
            //background.graphics.beginBitmapFill(bitmapData);
            //background.graphics.drawRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
            
            var canvas:Canvas = new Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, background, RECOVERBLE);
            canvas.attach("pen", new PenTool());
            canvas.change("pen");
            canvas.options = {thickness:2, color:0x000000};
            canvas.activate();

            addChild(canvas);

            var btn_recover:Sprite = new Sprite();
            btn_recover.graphics.beginFill(0xff0000);
            btn_recover.graphics.drawRect(0,0,30, 30);
            btn_recover.x = canvas.width;
            btn_recover.y = 0;
            btn_recover.addEventListener(MouseEvent.CLICK,
            function(event:MouseEvent):void
            {
                    canvas.recover();
            }
            );
            var txt_recover:TextField = new TextField();
            txt_recover.x = txt_recover.y = 0;
            txt_recover.autoSize = TextFieldAutoSize.LEFT;
            txt_recover.text = "戻す";
            txt_recover.mouseEnabled = false;
            btn_recover.addChild(txt_recover);
            addChild(btn_recover);

            var btn_recoverAll:Sprite = new Sprite();
            btn_recoverAll.graphics.beginFill(0x00ff00);
            //btn_recoverAll.graphics.drawRect(0,0,30, 30);
            btn_recoverAll.graphics.drawRoundRect(0,0,30,30,10)
            btn_recoverAll.x = canvas.width;
            btn_recoverAll.y = btn_recover.height;
            btn_recoverAll.addEventListener(MouseEvent.CLICK,
            function(event:MouseEvent):void
            {
                    canvas.recoverAll();
            }
            );
            var txt_recoverAll:TextField = new TextField();
            txt_recoverAll.x = txt_recoverAll.y = 0;
            txt_recoverAll.autoSize = TextFieldAutoSize.LEFT;
            txt_recoverAll.text = "消す";
            txt_recoverAll.mouseEnabled = false;
            btn_recoverAll.addChild(txt_recoverAll);

            addChild(btn_recoverAll);
        }
}    







import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.IBitmapDrawable;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

/**
 * drawing canvas
 * @author naoto koshikawa
 */
class Canvas extends Sprite{
    private var _cache:Sprite;
    private var _mask:Shape;
    private var _background:Bitmap;
    private var _original:BitmapData;
    private var _history:Array;
    private var _length:int;
    private var _recoverableCount:uint;
    private var _width:Number;
    private var _height:Number;
    
    private var _currentTool:ITool;
    public function get currentTool():ITool
    {
        return _currentTool;
    }
    
    private var _tools:Object;
    public function set options(options:Object):void
    {
        if (_currentTool) _currentTool.options = options;
    }
    
    public function get recoverable():Boolean
    {
        return (_length) ? true:false;
    }
    
    private var _recoverableAll:Boolean;
    public function get recoverableAll():Boolean
    {
        return _recoverableAll;
    }
    
    public function Canvas(w:Number, h:Number, background:IBitmapDrawable, recoverableCount:uint = 0) 
    {
        _tools = { };
        _history = [];
        _recoverableAll = false;
        _recoverableCount = recoverableCount;
        _width = w;
        _height = h;
        _cache = new Sprite();
        _cache.graphics.beginFill(0, 0);
        _cache.graphics.drawRect(0, 0, _width, _height);
        addChildAt(_cache, 0);
        
        _mask = new Shape();
        _mask.graphics.beginFill(0, 0);
        _mask.graphics.drawRect(0, 0, _width, _height);
        mask = _mask;
        addChildAt(_mask, 0);
        
        if (background) updateBackground(background);
    }
    
    public function activate():void
    {
        addEventListener(MouseEvent.MOUSE_DOWN, mouseDownListener);
    }
    
    public function inactivate():void
    {
        removeEventListener(MouseEvent.MOUSE_DOWN, mouseDownListener);
        removeEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
        removeEventListener(MouseEvent.MOUSE_OUT, mouseUpListener);
        removeEventListener(Event.ENTER_FRAME, enterFrameListener);
    }
    
    public function getDrawingData():BitmapData
    {
        return getBitmapData(this);
    }
    
    public function stack(displayObject:DisplayObject):void
    {
        _history.push(displayObject);
        _length = _history.length;
        if (_length <= _recoverableCount) return;
        
        var i:uint;
        for (i = 1; i < _length; i++)
        {
            _history[i]["visible"] = false;
        }
        updateBackground(this);
        _history.shift();
        _length--;
        _cache.removeChildAt(0);
        
        for (i = 0; i < _length; i++)
        {
            _history[i]["visible"] = true;
        }
    }
    
    public function attach(key:String, tool:ITool):String
    {
        if (!_tools[key]) _tools[key] = tool;
        return key;
    }
    
    public function change(key:String):void
    {
        if (_tools[key]) _currentTool = _tools[key];
    }
    
    public function recover():void
    {
        if (_length) 
        {
            trace(_length);
            _cache.removeChildAt(--_length);
            _history.pop();
        }
    }
    
    public function recoverAll():void
    {
        for (var i:uint = 0; i < _length; i++)
        {
            _cache.removeChildAt(0);
        }
        _history = [];
        _length = 0;
        
        if (_background && contains(_background)) removeChild(_background);
        _background = new Bitmap(_original);
        addChildAt(_background, 0);
        _recoverableAll = false;
    }
    
    private function updateBackground(background:IBitmapDrawable):void
    {
        var bitmapData:BitmapData = getBitmapData(background);
        if (!_original) _original = bitmapData;
        if (_background && contains(_background)) removeChildAt(0);
        _background = new Bitmap(bitmapData);
        addChildAt(_background, 0);
    }
    
    private function getBitmapData(background:IBitmapDrawable):BitmapData
    {
        var bitmapData:BitmapData = new BitmapData(_width, _height);
        bitmapData.draw(background);
        return bitmapData;
    }
    
    // _____________________________________________________ Listener
    /**
     * MouseEvent.MOUSE_DOWN
     * @param    event
     */
    private function mouseDownListener(event:MouseEvent):void
    {
        var e:DrawingEvent = new DrawingEvent(DrawingEvent.START_DRAWING, true, true, mouseX, mouseY);
        dispatchEvent(e);
        if (!e.isDefaultPrevented())
        {
            addEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
            addEventListener(MouseEvent.MOUSE_OUT, mouseUpListener);
            addEventListener(Event.ENTER_FRAME, enterFrameListener);
            if (_currentTool) 
            {
                _currentTool.start(mouseX, mouseY);
                _cache.addChildAt(_currentTool.displayObject, _length);
                _recoverableAll = true;
            }
        }
    }
    
    /**
     * Event.ENTER_FRAME
     * @param    event
     */
    private function enterFrameListener(event:Event):void
    {
        var e:DrawingEvent = new DrawingEvent(DrawingEvent.MOVE_DRAWING, true, true, mouseX, mouseY);
        dispatchEvent(e);
        if (!e.isDefaultPrevented())
        {
            if (_currentTool) _currentTool.move(mouseX, mouseY);
        }
    }
    
    /**
     * MouseEvent.MOUSE_UP
     * @param    event
     */
    private function mouseUpListener(event:MouseEvent):void
    {
        var e:DrawingEvent = new DrawingEvent(DrawingEvent.STOP_DRAWING, true, true, mouseX, mouseY);
        dispatchEvent(e);
        if (!e.isDefaultPrevented())
        {
            inactivate();
            activate();
            if (_currentTool)
            {
                stack(_currentTool.displayObject);
                _currentTool.stop(mouseX, mouseY);
            }
        }
    }
}


import flash.events.Event;

/**
 * drawing event
 * @author naoto koshikawa
 */
class DrawingEvent extends Event 
{
    public static const START_DRAWING:String = "startDrawing";
    public static const MOVE_DRAWING:String = "moveDrawing";
    public static const STOP_DRAWING:String = "stopDrawing";
    
    private var _x:Number;
    public function get x():Number
    {
        return _x;
    }
    
    private var _y:Number;
    public function get y():Number
    {
        return _y;
    }
    
    public function DrawingEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false, x:Number = 0, y:Number = 0) 
    { 
        super(type, bubbles, cancelable);
        _x = x;
        _y = y;
    } 
    
    public override function clone():Event 
    { 
        return new DrawingEvent(type, bubbles, cancelable, _x, _y);
    } 
    
    public override function toString():String 
    { 
        return formatToString("DrawingEvent", "type", "bubbles", "cancelable", "eventPhase", "x", "y"); 
    }
    
}

import flash.display.DisplayObject;

/**
 * jp.ppworks.drawing.simple
 * パッケージで使用できるツールのインターフェースです
 * 
 * @author naoto koshikawa
 */
interface ITool 
{
    function get displayObject():DisplayObject;
    function set options(options:Object):void;
    function get options():Object;
    function start(x:Number, y:Number):void;
    function move(x:Number, y:Number):void;
    function stop(x:Number, y:Number):void;
}

import flash.display.DisplayObject;
import flash.display.Shape;

/**
 * Pen Tool
 * @author naoto koshikawa
 */
class PenTool implements ITool
{
    private var _displayObject:Shape;
    public function get displayObject():DisplayObject
    {
        return _displayObject;
    }
    
    private var _options:Object;
    public function get options():Object
    {
        return _options;
    }
    public function set options(options:Object):void
    {
        if (options && options.thickness) _options.thickness = options.thickness;
        if (options && options.color) _options.color = options.color;
    }
    
    // _____________________________________________________ Method
    public function PenTool() 
    {
        _options = {
            thickness:3,
            color:0x000000
        };
    }
    
    public function start(x:Number, y:Number):void
    {
        _displayObject = new Shape();
        _displayObject.graphics.lineStyle(
            _options.thickness,
            _options.color
        );
        _displayObject.graphics.moveTo(x, y);
    }
    
    public function move(x:Number, y:Number):void
    {
        if (!_displayObject) return;
        _displayObject.graphics.lineTo(x, y);
    }
    
    public function stop(x:Number, y:Number):void
    {
        if (!_displayObject) return;
        if (_displayObject.width == _options.thickness
            && _displayObject.height == _options.thickness)
        {
            _displayObject.graphics.clear();
            _displayObject.graphics.beginFill(_options.color);
            _displayObject.graphics.drawCircle(x, y, _options.thickness/2);
        }
        else
        {
            move(x, y);
        }
    }
}

//---------------------------------------



import flash.geom.*;
import flash.display.*;
import flash.text.*;
import flash.events.*;

class node extends Sprite{
        
        private var scale:Number = 1;
        
        public var wheel:int;//ホイール回転量
        private var zoom:Number = 1.0;//拡大率
        
        private var mapBase:Sprite;
        public var map:Sprite;//フィールド
        
        private var scrFocusX:Number=0; 
        private var scrFocusY:Number=0; 

        private var mapscale:int=0;
        
        private var dragPanel:Sprite = new Sprite();
                
        //ozmap状態フラグ
        private const testMode:Boolean = false;//テスト表示
        private var mapBrowseMode:Boolean;//マップ移動操作
        private var mapDragMode:Boolean;//マップドラッグ中はtrue
        private var mapRotationMode:Boolean;//マップ回転操作
        
        
        //コンストラクタ 
        public function node():void{
            
            mapBase = new Sprite();//ズーム中心
            
            if(testMode == true){ 
                with( mapBase.graphics ){
                    lineStyle(1,0x00ff00,0.3);
                    moveTo(-100,0);
                    lineTo(100,0);
                    moveTo(0,-100);
                    lineTo(0,100);
                }
            }
            addChild(mapBase);
 
            
            //マップ上への配置
            map = new Sprite();
            
            if(testMode == true){
                var t3:TextField = new TextField();
                with(t3){
                    textColor = 0x0000ff;
                    selectable = false;
                    y = -20;
                    text = "map 0,0";
                }
                map.addChild(t3);
                with( map.graphics ){
                    lineStyle(1,0x0000ff,0.3);
                    moveTo(-100,0);
                    lineTo(100,0);
                    moveTo(0,-100);
                    lineTo(0,100);
                }
            } 
            
            browseOn();
 
            mapBase.addChildAt(map,0); 
            map.addChild(dragPanel);
            dragPanel.doubleClickEnabled = true;

            update();
    
        }
        
        public function get scaleSize():int{
            return mapscale;
        }
        
        //マップ移動操作状態
        public function get IsBrowseMode():Boolean{
            return mapBrowseMode;
        }
        //マップドラッグスクロール状態
        public function get IsDragMode():Boolean{
            return mapDragMode;
        }        
        //マップ回転操作状態
        public function get IsRotationMode():Boolean{
            return mapRotationMode;
        }

        //
        public function returnHome():void{
            map.x = 0;
            map.y = 0;
            map.scaleX = map.scaleY = 1.0;
            mapscale = 0;
            update();
            
        }

        
        
        //画面移動操作の受付　ON・OFF切り替え
        public function browseOn():void{
            
            mapBrowseMode = true;
            map.addEventListener(MouseEvent.MOUSE_DOWN,down);
            map.addEventListener(MouseEvent.MOUSE_UP,up);
            dragPanel.addEventListener(MouseEvent.DOUBLE_CLICK,onDouble);
            this.addEventListener(MouseEvent.MOUSE_WHEEL,on_wheel,true);//ホイール操作 
            map.addChild(dragPanel);
        }
        public function browseOff():void{
            wheel = 0;
            mapBrowseMode = false;
            map.removeEventListener(MouseEvent.MOUSE_DOWN,down);
            map.removeEventListener(MouseEvent.MOUSE_UP,up);
            dragPanel.removeEventListener(MouseEvent.DOUBLE_CLICK,onDouble);
            this.removeEventListener(MouseEvent.MOUSE_WHEEL,on_wheel,true);//ホイール操作 
            map.removeChild(dragPanel);
        }
        
        //ダブルクリックでマップブラウズモード解除　⇒　オブジェクト操作モードに移行
        private function onDouble(e:MouseEvent):void{
            browseOff();
            //ホイール操作でブラウズモードに移行
            stage.addEventListener(MouseEvent.MOUSE_WHEEL,function():void{
                browseOn();
            });
        }


  
        //マップドラッグ開始
        private function down(e:MouseEvent):void{
            wheel=0;//ズーム操作ストップ

      　    e.currentTarget.startDrag();
      　    addEventListener(MouseEvent.MOUSE_MOVE,onMove);
      　    stage.removeEventListener(Event.ENTER_FRAME,onFrame);
      　    e.stopPropagation();//イベントの伝播を止める
      　    
        }
        
        private function up(e:MouseEvent):void{
            e.currentTarget.stopDrag();
            removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            e.stopPropagation();//イベントの伝播を止める
        }
        
        //マップドラッグ中
        private function onMove(e:MouseEvent):void{
            update();
        }

        //ホイール操作
        private function on_wheel(e:MouseEvent):void{  
            
            wheel += e.delta;
            
            if(wheel != 0)addEventListener(Event.ENTER_FRAME,onFrame);
            //else removeEventListener(Event.ENTER_FRAME,onFrame);
        }
  
        private function onFrame(e:Event):void {
            if(wheel==0){
                removeEventListener(Event.ENTER_FRAME,onFrame);
            }

            on_zoom(1+(0.005*wheel));
        }
        
        
        //マップ表示位置を更新
        private function update(z:Number=1, x:Number=0, y:Number=0, a:Number=0):void{
            var mX:int,mY:int;
            
            if(1<=z){//ズームイン
                mX = mouseX;
                mY = mouseY;//カーソル位置 
            }
            else{//ズームアウト
                mX = this.root.loaderInfo.width/2;
                mY = this.root.loaderInfo.height/2;//カーソル位置
            }
            
            //ズーム中心
            mapBase.x = mX;
            mapBase.y = mY; 
            //マップ位置
            map.x -= (mX-scrFocusX)/zoom;
            map.y -= (mY-scrFocusY)/zoom;
            //フォーカス位置
            scrFocusX = mX;
            scrFocusY = mY;
            

            //フィールドドラッグ用
            with(dragPanel.graphics){
                clear();
                beginFill(0xffffff,0.2);
                drawCircle( -map.x/map.scaleX, -map.y/map.scaleY, 1200/(zoom*map.scaleX) );
                
                endFill();
            }
            if(true){
                var i:int;
                var c:uint = 0x00aa00;
                const j:int = 32;
                with(dragPanel.graphics){
                    for(i= -20-(map.y/j);i<20-(map.y/j);i++){
                        if(Math.abs(i)%2 == 1)lineStyle(0,c,(zoom*0.5)-0.5);
                        else lineStyle(0,c,0.5);
                        moveTo((-600-map.x)/map.scaleX , i*j/map.scaleX);
                        lineTo((1600-map.x)/map.scaleX , i*j/map.scaleX);
                    }
                    for(i=-20-(map.x/j);i<20-(map.x/j);i++){
                        if(Math.abs(i)%2 == 1)lineStyle(0,c,(zoom*0.5)-0.5);
                        else lineStyle(0,c,0.5);
                        moveTo(i*j/map.scaleX, (-600-map.y)/map.scaleX);
                        lineTo(i*j/map.scaleX, (1600-map.y)/map.scaleX);
                    }
                }
            }
      
        }

        //ズーム処理
        private function on_zoom(z:Number=0):void{
            if(z==0)return;
            zoom *= z;    
                
            if(2 < zoom){
                with(map){
                    x+=x; y+=y;
                    scaleX = scaleY *= 2;
                }
                zoom /= 2;      
                mapscale--;
                
            }
            else if(zoom < 1.0){
                with(map){
                    x-=x/2; y-=y/2;
                    scaleX = scaleY /= 2;
                }        
                zoom *= 2;    
                mapscale++;
                    
            }
            
            with(mapBase){
                scaleX = scaleY = zoom;
            }
            update(z);//基準点更新      
          
        }
        
    }
    

    
    
    

