/**
 * Copyright hrtsgt ( http://wonderfl.net/user/hrtsgt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gInd
 */

// forked from abakane's Scratch スクラッチカード的なの
package
{
    import com.bit101.components.*;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.Security;
    [SWF(width=465,height=465,backgroundColor=0x0,frameRate=30)]

    public class Scratch extends Sprite
    {
        private var loader:Loader;
        private var _loader:Loader;
        private var bmp:Bitmap;//_canvas用
        private var _bmp:Bitmap;//_alpha用
        private var _alpha:BitmapData;
        private var _canvas:BitmapData;
        private var _source:BitmapData;
        private var shape:Shape;
        private var toggleButton:PushButton;
        private var clearButton:PushButton;
        private var brushSize:Number = 80.0;
        private var brushStrength:Number = 0.5;//0.0〜1.0
        
        public function Scratch()
        {
            Security.loadPolicyFile( "http://t.args.in/crossdomain.xml");
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onComplete);//
            loader.load( new URLRequest("http://t.args.in/lab/lib/einstein.jpg") );
        }
        
        private function onComplete( e:Event ):void
        {
            loader.contentLoaderInfo.removeEventListener( Event.COMPLETE, onComplete);//
            addChild( loader );
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener( Event.COMPLETE, _onComplete);//
            _loader.load( new URLRequest("http://t.args.in/lab/lib/monalisa.jpg") );
        }
        private function _onComplete( e:Event ):void
        {
            _loader.contentLoaderInfo.addEventListener( Event.COMPLETE, _onComplete);//
            //addChild( _loader );
            _source = Bitmap( LoaderInfo(e.target).loader.content ).bitmapData;            
            _alpha = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0x0);
            _canvas = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0x0);
            bmp = new Bitmap(_canvas);
            addChild( bmp );
            _bmp = new Bitmap(_alpha);
            
            shape = new Shape();            
            clearButton = new PushButton( this, 5, 5, "CLEAR");
            clearButton.addEventListener( MouseEvent.CLICK, onClear);//
            toggleButton = new PushButton( this, clearButton.width+10, 5, "Canvas BitmapData");
            toggleButton.addEventListener( MouseEvent.CLICK, onSelect);//
            toggleButton.toggle = true;
            stage.addEventListener( MouseEvent.MOUSE_DOWN, onDown);//
            stage.addEventListener( MouseEvent.MOUSE_UP, onUp);//
        }
        
        private function onDown( e:MouseEvent):void{ stage.addEventListener( MouseEvent.MOUSE_MOVE, onMove); }
        private function onUp( e:MouseEvent ):void{ stage.removeEventListener( MouseEvent.MOUSE_MOVE, onMove); }
        private function onMove( e:MouseEvent ):void
        {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox( brushSize, brushSize, 0, mouseX-brushSize*0.5, mouseY-brushSize*0.5);
            shape.graphics.clear();
            shape.graphics.beginGradientFill( GradientType.RADIAL, [0xFFFFFF, 0xFFFFFF], [brushStrength, 0], [0x80, 0xFF], matrix, SpreadMethod.PAD);
            shape.graphics.drawCircle(mouseX, mouseY, brushSize*0.5);
            shape.graphics.endFill();
            _alpha.draw( shape, null, null, null, null, true);
            _canvas.fillRect( _canvas.rect, 0x0);
            _canvas.copyPixels(_source, _source.rect, new Point(0,0), _alpha, null, true);
        }
        
        private function onSelect( e:MouseEvent ):void
        {
            if( toggleButton.selected ){
                removeChild( bmp );
                addChild( _bmp );
                toggleButton.label = "Alpha BitmapData";
            }else{
                removeChild( _bmp );
                addChild( bmp );
                toggleButton.label = "Canvas BitmapData";
            }
        }
        private function onClear( e:MouseEvent ):void
        {
            _alpha.fillRect( _alpha.rect, 0x0);
            _canvas.fillRect( _canvas.rect, 0x0);
        }
    }
}