/**
 * Copyright 883108 ( http://wonderfl.net/user/883108 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gI42
 */

package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.geom.Point;
	public class CurveLineDrawerDocument extends Sprite {
		private var _maxNum:uint = 10;

		public function CurveLineDrawerDocument() {
			init();
		}

		private function init():void {
			var tex:TextField = new TextField  ;
			addChild(tex);
			tex.width = 450;
			tex.x = tex.y = 10;
			tex.multiline = true;
			tex.text = 'ランダムに生成されたポイントに対して滑らかに曲線を引きます。\nただし、曲線同士が鋭角的につながる可能性が残っています。';
			
			// ランダムにポイントを生成し、配列に格納
			var points:Array = [];
			for (var i:uint = 0; i< _maxNum; i++) {
				points[i] = new Point(Math.random() * stage.stageWidth | 0,Math.random() * stage.stageHeight | 0);
			}
			graphics.lineStyle(0);
			graphics.moveTo(points[0].x, points[0].y);
			// 残りの点をループ処理し、各中間点まで曲線を描く
			var xt:Number,yt:Number;
			for (i = 0; i< _maxNum-1; i++) {
				xt = (points[i].x + points[i+1].x) / 2;
				yt = (points[i].y + points[i+1].y) / 2;
				graphics.curveTo(points[i].x, points[i].y, xt, yt);
			}
			// 終点と始点を結び、終了
			graphics.curveTo(points[_maxNum-1].x, points[_maxNum-1].y, points[0].x, points[0].y);
		}
	}
}