/**
 * Copyright ruiko ( http://wonderfl.net/user/ruiko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gHZp
 */

// forked from ruiko's flash on 2010-7-31
package {
    import flash.trace.Trace;
    import flash.ui.Mouse;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.ui.Keyboard;
    [SWF(width="640", height="400", backgroundColor="0xffffff", frameRate="24")]

    public class Main extends Sprite {
        
        private var inputText:TextField = new TextField();  
        private var screen:Sprite = new Sprite();
        //private var s:Sprite = new Sprite();
        private var flag:int = 1;
        private var right:Sprite = new Sprite();
        private var left:Sprite = new Sprite();
        private var cover:Cover= new Cover();
        
        public function Main():void {
            trace("const");
            //画面（最下層）設定
            screen= new Sprite();
            screen.graphics.beginFill(0xffffff,1);
            screen.graphics.drawRect(0,0,stage.stageWidth*3,stage.stageHeight);
            screen.graphics.endFill();
            screen.x = -stage.stageWidth;
            
            addChild(screen);
            //移動ボタン描画
            drawMoveButton();
            
            // クリックイベントを監視する
            stage.addEventListener("click", stageClick);
            right.addEventListener("click", moveRight);
            left.addEventListener("click", moveLeft);
            //ダブルクリック
            //cover.addEventListener(MouseEvent.DOUBLE_CLICK, moveLeft);
        }
        
        //右に移動（オブジェクトを左にずらす）
        private function moveLeft(event:MouseEvent):void {
            trace("migi");
            if(flag>0){
                screen.x+=stage.stageWidth;
                flag-=1;
            }
            //移動ボタン描画
            drawMoveButton();
        }
        
        //左に移動（オブジェクトを右にずらす）
        private function moveRight(event:MouseEvent):void {
            trace("hidari");
            if(flag<2){
                screen.x -= stage.stageWidth; 
                flag+=1;
            }
            //移動ボタン描画
            drawMoveButton();
        }

        
        //イベントハンドラ
        private function stageClick(event:MouseEvent):void {
            trace("click");
            if (event.target == screen) {
                
            
            // 四角を作成
            var s:Memo = new Memo();
            
            screen.addChild(s.createMemo(Math.random() * 0x1000000));
            // 四角をクリックされた位置に移動
            s.x = event.stageX+(stage.stageWidth*flag);
            s.y = event.stageY;
            
            s.doubleClickEnabled = true;

            //マウスボタンダウン
           // s.addEventListener(MouseEvent.CLICK, rectSingleClick);
           
            s.addEventListener(MouseEvent.MOUSE_DOWN, rectClickDown);
            //マウスボタンアップ
            s.addEventListener(MouseEvent.MOUSE_UP, rectClickUp);
            //ダブルクリック
            s.addEventListener(MouseEvent.DOUBLE_CLICK, rectDoubleClick(s));
            }
            else if (event.target == cover) {
                screen.removeChild(cover);
                this.drawMoveButton();
            }
           
        }
        
        private function rectSingleClick(event:MouseEvent):void 
        {
            //event.target.y = 0;
        }
        
        //ドラッグ開始
        private function rectClickDown(event:MouseEvent):void {
            
            trace(event.target);
            event.target.startDrag( );
        }
        //ドラッグ終了
        private function rectClickUp(event:MouseEvent):void {
            
            event.target.stopDrag( );
        }
        //ダブルクリック
        private function rectDoubleClick(memo:Memo):Function {
            return function ( event:MouseEvent ):void{  
            
                trace(memo.inputText);
            right.graphics.clear();
            left.graphics.clear();
            cover = new Cover();
             
            screen.addChild(cover.createCover(memo.inputText, stage.stageWidth, stage.stageHeight, memo, flag));
            //消す
            //screen.removeChild(DisplayObject(event.target));
            
            }
        }

        /**
         * 画面移動ボタン描画
         */
        public function drawMoveButton():void {

           
           if(flag==0 || flag==1){
                right.graphics.beginFill(0x000000);
                right.graphics.drawCircle(stage.stageWidth-25,stage.stageHeight-40,20);
                right.graphics.endFill();
                addChild(right);;
            }else{
                right.graphics.clear();
            }

            if(flag==1 || flag==2){
                left.graphics.beginFill(0x000000);
                left.graphics.drawCircle(25,stage.stageHeight-40,20);
                left.graphics.endFill();
                addChild(left); 
            }else{
                left.graphics.clear();
            }
        }
   }
}
    import flash.display.Sprite;
    import flash.text.*;
    class Memo extends Sprite {
        public var colorNum:uint;
        public var inputText:String = "テスト";
        public var tf:TextField = new TextField();

        public function createMemo(color:uint):Memo{
            var s:Sprite = new Sprite();
            colorNum = color;
            inputText = colorNum.toString();
            
            this.graphics.beginFill(colorNum);
            this.graphics.drawRect(this.x,this.y,120,50);
            this.graphics.endFill();
            
            
            tf.defaultTextFormat = new TextFormat("", 10, 0x0, true);
            tf.text = inputText;
            tf.selectable = false;
            tf.mouseEnabled = false
            tf.autoSize = TextFieldAutoSize.LEFT;
            this.addChild(tf);
            
            
            return(this);
        }

    }
    
    import flash.display.Sprite;
    import flash.text.*;
    class Cover extends Sprite {
        public var colorNum:uint;
        public var inputText:String = "テスト";
        public var tf:TextField = new TextField();

        public function createCover(text:String, width:int, height:int, memo:Memo, flag:int):Cover {
            this.graphics.beginFill(0x555555,0.3);
            this.graphics.drawRect(0,0,width,height);
            this.graphics.endFill();   
              //テキストボックス
            tf = new TextField();
            tf.border = true;
            tf.type = "input";
            tf.text = memo.inputText;
            tf.x = width * flag;
            this.addChild(tf);
            trace(width);
     
            return(this);
            
        }

    }
