/**
 * Copyright matthewpeterson.net ( http://wonderfl.net/user/matthewpeterson.net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gGyL
 */

package {
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.geom.Point;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            var tf:TextField = new TextField();
            tf.border = true;
            addChild(tf);
            tf.selectable = true;
            tf.type = "input";
            
            var pointA:Point = new Point(10,10);
            var pointB:Point = new Point(100,100);
            var pointC:Point = new Point(20,300);
            var pointD:Point = new Point(100,100);
            graphics.lineStyle(1,0);
            graphics.moveTo(pointA.x, pointA.y);
            graphics.lineTo(pointB.x, pointB.y);
            
            graphics.moveTo(pointC.x, pointC.y);
            graphics.lineTo(pointD.x, pointD.y);
            
            var pointE:Point = lineIntersectLine(pointA,pointB,pointC,pointD,false);
            
            graphics.drawCircle(pointE.x,pointE.y,5);
        }
        
        //---------------------------------------------------------------
        //Checks for intersection of Segment if as_seg is true.
        //Checks for intersection of Line if as_seg is false.
        //Return intersection of Segment AB and Segment EF as a Point
        //Return null if there is no intersection
        //---------------------------------------------------------------
        private function lineIntersectLine(A:Point,B:Point,E:Point,F:Point,as_seg:Boolean=true):Point {
            var ip:Point;
            var a1:Number;
            var a2:Number;
            var b1:Number;
            var b2:Number;
            var c1:Number;
            var c2:Number;
         
            a1= B.y-A.y;
            b1= A.x-B.x;
            c1= B.x*A.y - A.x*B.y;
            a2= F.y-E.y;
            b2= E.x-F.x;
            c2= F.x*E.y - E.x*F.y;
         
            var denom:Number=a1*b2 - a2*b1;
            if (denom == 0) {
                return null;
            }
            ip=new Point();
            ip.x=(b1*c2 - b2*c1)/denom;
            ip.y=(a2*c1 - a1*c2)/denom;
         
            //---------------------------------------------------
            //Do checks to see if intersection to endpoints
            //distance is longer than actual Segments.
            //Return null if it is with any.
            //---------------------------------------------------
            if(as_seg){
                if(Math.pow(ip.x - B.x, 2) + Math.pow(ip.y - B.y, 2) > Math.pow(A.x - B.x, 2) + Math.pow(A.y - B.y, 2))
                {
                   return null;
                }
                if(Math.pow(ip.x - A.x, 2) + Math.pow(ip.y - A.y, 2) > Math.pow(A.x - B.x, 2) + Math.pow(A.y - B.y, 2))
                {
                   return null;
                }
         
                if(Math.pow(ip.x - F.x, 2) + Math.pow(ip.y - F.y, 2) > Math.pow(E.x - F.x, 2) + Math.pow(E.y - F.y, 2))
                {
                   return null;
                }
                if(Math.pow(ip.x - E.x, 2) + Math.pow(ip.y - E.y, 2) > Math.pow(E.x - F.x, 2) + Math.pow(E.y - F.y, 2))
                {
                   return null;
                }
            }
            return ip;
        }
    }
}