/**
 * Copyright szbzs2004 ( http://wonderfl.net/user/szbzs2004 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gGBR
 */

// http://prog.hu/tudastar/152393/AS3+textField.html
package {
    
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.TextEvent;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.utils.Dictionary;
  
    public class Crossword extends Sprite {

        private const NUMBER_OF_ROWS:int = 15;
        private const NUMBER_OF_COLUMNS:int = 15;
        private const CELL_SIZE:int = 20;

        private var connections:Dictionary = new Dictionary();
        private var direction:Boolean = false;

        public function Crossword() {
           generateCells();
           makeConnections();
        }

        private function tfName(r:int, c:int):String {
            return "tf" + ((r * NUMBER_OF_COLUMNS) + c);
        }

        private function getTfObject(r: int, c: int):TextField {
            return TextField(c <= NUMBER_OF_COLUMNS ? getChildByName(tfName(r, c)) : null);
        }

        private function generateCells():void {
            graphics.beginFill(0);
            for (var row:int = 1; row <= NUMBER_OF_ROWS; ++row) {
                for (var column:int = 1; column <= NUMBER_OF_COLUMNS; ++column) {
                    var p:Point = new Point(column * CELL_SIZE, row * CELL_SIZE);
                    if (Math.random() > 0.6) {
                        var tf:TextField = new TextField();
                        tf.x = p.x;
                        tf.y = p.y;
                        tf.width = tf.height = CELL_SIZE;
                        tf.border = true;
                        tf.type = TextFieldType.INPUT;
                        tf.tabEnabled = false;
                        tf.name = tfName(row, column);
                        addChild(tf);
                    } else {
                        graphics.drawRect(p.x, p.y, CELL_SIZE, CELL_SIZE); 
                    }
                }
            }
        }
 
        private function makeConnections():void {
            for (var row:int = 1; row <= NUMBER_OF_ROWS; ++row) {
                for (var column:int = 1; column <= NUMBER_OF_COLUMNS; ++column) {
                    var currentField:TextField = getTfObject(row, column);
                    if (currentField != null) {
                        addConnection(currentField, getTfObject(row, column + 1), getTfObject(row + 1, column));
/*                        
                        var neighbourRight:TextField = getTfObject(row, column + 1);
                        var neighbourDown:TextField  = getTfObject(row + 1, column);
                        if (neighbourRight != null) {
                            if (neighbourDown != null) {
                                addConnection(currentField, neighbourRight, neighbourDown);                    
                            } else {
                                addConnection(currentField, neighbourRight, null);
                            }
                        } else if (neighbourDown != null) {
                            addConnection(currentField, null, neighbourDown);
                        } else {
                            addConnection(currentField, null, null);
                        }
*/                        
                    }
                }
            }
        }
 
        private function addConnection(from:TextField, toHorizontal:TextField, toVertical:TextField):void {
            connections[from] = { "false": toVertical, "true": toHorizontal, defaultDirection: toHorizontal != null};
            from.addEventListener(TextEvent.TEXT_INPUT, textInputHandler);
            from.addEventListener(MouseEvent.CLICK, clickHandler);
        }

        private function textInputHandler(e:TextEvent):void {
            if (/[a-zA-Z]/.test(e.text)) {
                e.target.text = e.text;
                var nextField:TextField = connections[e.target][direction.toString()];
                if (nextField != null) {
                    stage.focus = nextField;
                }
            }
            e.preventDefault();
        }

        private function clickHandler(e:MouseEvent):void {
            direction = connections[e.target].defaultDirection;
        }

    }
}