/**
 * Copyright naoto5959 ( http://wonderfl.net/user/naoto5959 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gG6a
 */

// forked from HaraMakoto's Arpeggiatorを使う
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import net.user1.reactor.IClient;
	import net.user1.reactor.Reactor;
	import net.user1.reactor.ReactorEvent;
	import net.user1.reactor.Room;
	import net.user1.reactor.RoomEvent;
	
	import org.si.sion.SiONData;
	import org.si.sion.SiONDriver;
	import org.si.sion.events.SiONEvent;
	import org.si.sion.utils.Scale;
	import org.si.sion.utils.SiONPresetVoice;
	import org.si.sound.Arpeggiator;
	
	[SWF(width="465", height="465", backgroundColor="#000000", frameRate=60)]
	public class UseArpeggiatorUnion extends Sprite
	{
		private var host:String = "tryunion.com";
		private var reactor:Reactor;
		private var room:Room;
		
		private var clickX:Number = 0;
		private var clickY:Number = 0;
		
		private var arpeggiator:Arpeggiator;
        public var driver:SiONDriver = new SiONDriver();
        private var rythmLoop:SiONData;
        private var presetVoice:SiONPresetVoice = new SiONPresetVoice();
        private var px:Number=0;
        private var py:Number=0;
        
		public function UseArpeggiatorUnion()
		{
			reactor = new Reactor(null, false);
			reactor.addEventListener(ReactorEvent.READY, 
			function(event:ReactorEvent):void
			{
				room = reactor.getRoomManager().createRoom("net.wonderfl.naoto5959.usearpeggiator");
				room.addMessageListener("click", onClickMessage);
				room.addEventListener(RoomEvent.JOIN,
				function(event:RoomEvent):void
				{
					initSound();
					soundStart();
				});
				room.join();
			});
			reactor.connect(host, 9100);
		}
		
		private function initSound():void {
			var mml:String = "t132;";
            rythmLoop = driver.compile(mml);
            rythmLoop.setVoice(0, presetVoice["valsound.percus1"]);
            
        	arpeggiator = new Arpeggiator(new Scale("o1Ajap"), 1, [0,1,2,5,4,3]);
        	arpeggiator.voice = presetVoice["valsound.piano8"];
        	arpeggiator.quantize = 4;
            arpeggiator.volume = 0.3;
            arpeggiator.noteQuantize = 8;
            
            
            driver.addEventListener(SiONEvent.STREAM, onStreamHandler);
            driver.play(rythmLoop);
            
            //bug??
            arpeggiator.noteOn();
            arpeggiator.noteOff();
            arpeggiator.pattern = [0, 1, 2, 5, 4, 3];
			
			stage.addEventListener(MouseEvent.CLICK,
			function(event:MouseEvent):void
			{
				room.sendMessage("click", true, null, mouseX, mouseY);
			});
		}
		
		
		private function onStreamHandler(e:SiONEvent):void {
			// update arpeggiator pitch and length
			setPxPy();
			arpeggiator.scaleIndex = px * 32;
            arpeggiator.noteLength = [0.5,1,1,2,4][int(py * 4 + 0.99)];
		}
		
		public function soundStart():void {
			setPxPy();
			arpeggiator.scaleIndex = px*32;
            arpeggiator.noteLength = [0.5,1,1,2,4][int(py * 4 + 0.99)];
            // start arpeggio
            arpeggiator.play();
		}
		
		private function setPxPy():void {
			px = clickX / 465;
			py = clickY / 465;
			if(px<0)px=0;
			if(px>0.9)px=0.9;
			if(py<0)py=0;
			if(py>0.9)py=0.9;
		}
		
		private function onClickMessage(fromClient:IClient, x:Number, y:Number):void
		{
			clickX = x;
			clickY = y;
		}

	}
}