/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gFmA
 */

package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const N:uint = 10;
    static private const M:uint = 10000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + M + " * " + N + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        _measure("カラ運転", function ():void
        {
            for(var j : uint = 0;j < N;j++){
                var a : Array = new Array(M);
                for (var i:uint = 0; i < M; i++) {
                    Math.random();
                    Math.random();
                    Math.random();
                }
            }
        });
        
        _measure("Object格納", function ():void
        {
            for(var j : uint = 0;j < N;j++){
                var a : Array = new Array(M);
                for (var i:uint = 0; i < M; i++) {
                    a[i] = {x:Math.random(), y:Math.random(), z:Math.random()};
                }
            }
        });
        
        _measure("Array格納", function ():void
        {
            for(var j : uint = 0;j < N;j++){
                var a : Array = new Array(M);
                for (var i:uint = 0; i < M; i++) {
                    a[i] = [Math.random(), Math.random(), Math.random()];
                }
            }
        });
        
        _measure("Class格納", function ():void
        {
            for(var j : uint = 0;j < N;j++){
                var a : Array = new Array(M);
                for (var i:uint = 0; i < M; i++) {
                    a[i] = new P(Math.random(), Math.random(), Math.random());
                }
            }
        });
        
        _measure("Vector3D格納", function ():void
        {
            for(var j : uint = 0;j < N;j++){
                var a : Array = new Array(M);
                for (var i:uint = 0; i < M; i++) {
                    a[i] = new Vector3D(Math.random(), Math.random(), Math.random());
                }
            }
        });
        
        _measure("Object格納ソート", function ():void
        {
            for(var j : uint = 0;j < N;j++){
                var a : Array = new Array(M);
                for (var i:uint = 0; i < M; i++) {
                    a[i] = {x:Math.random(), y:Math.random(), z:Math.random()};
                }
                a.sortOn("z", Array.NUMERIC);
            }
        });
        
        _measure("Array格納ソート", function ():void
        {
            for(var j : uint = 0;j < N;j++){
                var a : Array = new Array(M);
                for (var i:uint = 0; i < M; i++) {
                    a[i] = [Math.random(), Math.random(), Math.random()];
                }
                a.sortOn("2", Array.NUMERIC);
            }
        });
        
        _measure("Class格納ソート", function ():void
        {
            for(var j : uint = 0;j < N;j++){
                var a : Array = new Array(M);
                for (var i:uint = 0; i < M; i++) {
                    a[i] = new P(Math.random(), Math.random(), Math.random());
                }
                a.sortOn("z", Array.NUMERIC);
            }
        });
        
        _measure("Vector3D格納ソート", function ():void
        {
            for(var j : uint = 0;j < N;j++){
                var a : Array = new Array(M);
                for (var i:uint = 0; i < M; i++) {
                    a[i] = new Vector3D(Math.random(), Math.random(), Math.random());
                }
                a.sortOn("z", Array.NUMERIC);
            }
        });
        
        _debug("\nClass=Vector3D>Array=Object って感じかしら");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}

class P
{
    public var x : Number;
    public var y : Number;
    public var z : Number;
    
    public function P(x_ : Number, y_ : Number, z_ : Number){
        x = x_; y = y_; z = z_;
    }
}
