/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gFeK
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            deb = new TextField();
            deb.mouseEnabled = false;
            deb.width = 320;
            deb.height = 240;
            addChild(deb);         
                
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, kup);           
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
        public function kdown(e:KeyboardEvent):void { if (e.keyCode > 511) { return;}vecKey[e.keyCode]=true; }
        public function kup(e:KeyboardEvent):void { if (e.keyCode > 511) { return;}vecKey[e.keyCode]=false; }
        
        public function isKeyDown(k:int):Boolean { return vecKey[k];  }
        
          public var deb:TextField;
        
         public var cx:Number = 50;
         public var cy:Number = 50;
         public var vx:Number = 0;
         public var vy:Number = 0;
         public var vx2:Number = 0;
         public var vy2:Number = 0;
        
         public var ang:Number = 0;
         
         
         
         public var gx:Number = 200;
         public var gy:Number = 200;
         public var grad:Number = 60;
         
         public function isWall(wx:Number, wy:Number):Boolean
         {
             var dx:Number; var dy:Number;
             dx = gx-wx; dy = gy-wy;
             return Math.sqrt(dx*dx + dy*dy) <= grad;
         }//iswall
         
         
         
         public var keyLeft:Boolean = false;
        public var keyRight:Boolean = false;
        public var keyDown:Boolean = false;
        public var keyUp:Boolean = false;
        public var bStartGround:Boolean = false;
          
         public function getAng(dy:Number, dx:Number):Number
         {  var a:Number;
            a = dx / ((dy<0?-dy:dy)+(dx<0?-dx:dx));
            if (dy < 0) { return (a-1)*1.57075; }
            return (1-a)*1.57075;
         }//getang
         
         public var xrad:Number = 8;
         public var yrad:Number = 16;
            
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);
         
            var ang2:Number;
         
             ang2 =  getAng(gy-cy, gx-cx);
             var kx:Number;
             var ky:Number;
             
             kx = Math.cos(ang2);
             ky = Math.sin(ang2);
             
             
             graphics.beginFill(0,0.2);
             graphics.drawCircle(gx,gy,grad);
             graphics.endFill();
             
             graphics.drawCircle(cx,cy, 8);
             
             
             graphics.moveTo(cx,cy);
             graphics.lineTo(cx+kx*16,cy+ky*16);
            
            
             keyLeft = (isKeyDown(Keyboard.A) || isKeyDown(Keyboard.LEFT));
             keyRight = (isKeyDown(Keyboard.D) || isKeyDown(Keyboard.RIGHT));
             keyUp = (isKeyDown(Keyboard.W) || isKeyDown(Keyboard.UP));
             keyDown = (isKeyDown(Keyboard.S) || isKeyDown(Keyboard.DOWN));

             bStartGround = isWall( cx + kx*(yrad+1), cy+ky*(yrad+1)) || isWall( cx + kx*(yrad+5), cy+ky*(yrad+5)); 
   
             var ms:Number;
             ms = 2.5;
  
  
              //cheating -- 
              //when standing on the planet
              //dont add to the velocity but use a fixed one
             if (bStartGround)
             {           
              vx = 0;
              vy = 0;
              ms = 4;
             } else { ms = 0.2;}
             
              if (keyLeft) { vx += -ky*ms;  vy += kx*ms; }
              if (keyRight) { vx += ky*ms; vy += -kx*ms;}
             
             
            if (keyUp) { vx2 -= kx; vy2 -= ky;}
         
         
             var nx:Number;
             var ny:Number;
             nx = -ky; ny = kx;
             
             vx2 += kx*0.5;
             vy2 += ky*0.5;
             
             graphics.lineStyle(2, 0xFF);
             graphics.moveTo(cx,cy);
             graphics.moveTo(cx+vx, cy+vy);
             
             var vnx:Number;
             var vny:Number;
             var mag:Number;
             mag = Math.sqrt(vx2*vx2 + vy2*vy2);
             if (mag == 0) { mag= 0.00001;}
             vnx = vx2/mag;
             vny = vy2/mag;
             
             //deb.text = " "+(vx*kx)+ " " + (vy+ky);
             if (isWall( cx + kx*yrad+vx2, cy+ky*yrad+vy2))
             { vx2 = 0; vy2 = 0; }
             
             vx *= 0.97;
             vy *= 0.97;
             
             vx2 *= 0.97;
             vy2 *= 0.97;
             
             cx += vx+vx2;
             cy += vy+vy2;
        
        
        
             
             graphics.moveTo(cx,cy);
             graphics.lineTo(cx+vnx*16,cy+vny*16);
        
             deb.text = " "+(vnx*kx + vny*ky);
             deb.appendText("\n " + (bStartGround ? "1":"0"));
         
            if ( (vnx*kx + vny*ky) > 0)
            if (bStartGround) { checkSlope(16); }
  
        }//onenter
        
        
      public function checkSlope(pow:int = 8):void
      {
        var i:int;
        var ang2:Number;
        var kx:Number;
        var ky:Number;   
             
         ang2 =  getAng(gy-cy, gx-cx);
   
         kx = Math.cos(ang2);
         ky = Math.sin(ang2);
      
       //if (isWall( cx + kx*yrad+vx2, cy+ky*yrad+vy2))
        for (i = 0; i < pow; i++)
        {
          if (isWall(cx + kx*(yrad+1), cy+ky*(yrad+1)) == true) { break;  }
          cx += kx; cy+=ky;
        }
        
        //if (isWall(cx,cy+yrad-pow)==false)
        for (i = 0; i < pow; i++)
        {
          if (isWall(cx + kx*(yrad-1), cy+ky*(yrad-1)) == false) { break;  }
          cx -= kx; cy -= ky;
        }
      
    }//checkslop
        
        
    }//classend
}