/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gFcv
 */

package {
  import com.actionscriptbible.Example;
  
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.net.URLLoader;
  import flash.net.URLRequest;
  import flash.printing.PrintJob;
  import flash.system.Security;
  import flash.text.TextField;
  import flash.text.TextFieldAutoSize;

  public class ch19ex1 extends Example {
    private var printableContent:Sprite;
    private var textField:TextField;
    private var loader:URLLoader;

    public function ch19ex1() {
      // Load the text from a text file.
      loader = new URLLoader();
      loader.load(new URLRequest("http://actionscriptbible.com/files/alice-ch1.txt"));
      loader.addEventListener(Event.COMPLETE, onLoadComplete);

      // Create a multiline text field that auto-sizes.
      textField = new TextField();
      textField.multiline = true;
      textField.wordWrap = true;
      textField.autoSize = TextFieldAutoSize.LEFT;
      
      // Create a sprite container for the text field,
      // and add the text field to it.
      printableContent = new Sprite();
      printableContent.addChild(textField);
    }
    
    private function onLoadComplete(event:Event):void {  
      trace("Done. Printing...");
      textField.text = loader.data;
      var printJob:PrintJob = new PrintJob();
      if (!printJob.start()) {
        trace("Printing cancelled!");
        return;
      }
      printJob.addPage(printableContent);
      printJob.send();
      trace("Print job submitted!");
    }
  }
}