/**
 * Copyright king_nomura ( http://wonderfl.net/user/king_nomura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gFLp
 */

package {
	import flash.text.TextFieldType;
	import flash.text.TextField;
	import flash.events.Event;
	import flash.accessibility.Accessibility;
    import flash.display.Sprite;
    
    /**
    * メールアドレス妥当性チェックサンプル
    * 正確さは保証しませんよ
    */
    public class EmailChecker extends Sprite {
    	
    		private var inputArea:TextField;
    		private var resultArea:TextField;
    		
    		// メールアドレス妥当性チェック
    		private static const EMAIL_REG:RegExp = /^[0-9a-z][0-9a-z_\-\.\+]*@[0-9a-z][0-9a-z\-\.]*\.[a-z]{2,6}$/i;
    		// 携帯メールアドレスかどうかの判定
    		// iPhoneを携帯と判断している
    		private static const MOBILE_REG:RegExp = /^.*@((docomo|ezweb|[a-z]\.vodafone|[a-z]\.j\-phone|softbank|disney)\.ne|i\.softbank)\.jp$/i;
    	
        public function EmailChecker() {
            if (stage)
            {
            		f_init();
            }
            else
            {
            		addEventListener(Event.ADDED_TO_STAGE, f_init);
            }
        }
        
        private function f_init(ev:Event = null):void
        {
        		if (ev) removeEventListener(Event.ADDED_TO_STAGE, f_init);

        		var inputLabel:TextField = new TextField();
        		inputLabel.text = "input:";
        		inputLabel.x = 50;
        		inputLabel.y = 50;
        		addChild(inputLabel);
        		
        		inputArea = new TextField();
        		inputArea.type = TextFieldType.INPUT;
        		inputArea.wordWrap = true;
        		inputArea.border = true;
        		inputArea.width = 300;
        		inputArea.height = 50;
        		inputArea.x = 100;
        		inputArea.y = 50;
        		addChild(inputArea);
        		
        		var resultLabel:TextField = new TextField();
        		resultLabel.text = "result:";
        		resultLabel.x = 50;
        		resultLabel.y = 200;
        		addChild(resultLabel);
        		
        		resultArea = new TextField();
        		resultArea.type = TextFieldType.DYNAMIC;
         	resultArea.wordWrap = true;
        		resultArea.width = 300;
        		resultArea.height = 100;
        		resultArea.x = 100;
        		resultArea.y = 200;
        		addChild(resultArea);
       		
       		// 入力ごとにチェックを行う
        		inputArea.addEventListener(Event.CHANGE, textChangeHandler);
        }
        
        /**
        * 変更後の文字列の妥当性をチェックする
        * @param Event
        */
        private function textChangeHandler(ev:Event):void
        {
        		var str:String = TextField(ev.target).text;
        		var result:String = str;
        		result += "\n";
        		result += (EMAIL_REG.exec(str)) ? "true" : "false";
        		result += " ";
        		result += (MOBILE_REG.exec(str)) ? " (mobile)" : " (PC)";
        		resultArea.text = result;
        }
    }
}