/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gEwM
 */

package  
{
    import com.bit101.charts.LineChart;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import com.bit101.components.Style;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    /**
     * alumican の人が言ってた混合率の話。
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "30", width = "465", height = "465")]
    public class Test70 extends Sprite 
    {
        private var lineChartA: LineChart;
        private var lineChartB: LineChart;
        private var lineChartC: LineChart;
        private var lineChartD: LineChart;
        private var chartArea: Sprite;
        private var moveTestArea: Sprite;
        private var box: Shape;
        private var testButton: PushButton;
        private var time: int;
        private var resultData: Array;
        
        public function Test70() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        /**
         * 全体の初期化
         * @param    e
         */
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            // 各種グラフ等の作成
            chartArea = new Sprite();
            Style.fontName = "_ゴシック";
            Style.embedFonts = false;
            Style.fontSize = 12;
            lineChartA = createLineChart(0x0099CC, 0);
            new Label(chartArea, 5, 5, "グラフA(現在、またはベースとなる動き)(縦軸：ｙ、横軸：時間)");
            lineChartB = createLineChart(0x99CC00, 110);
            new Label(chartArea, 5, 115, "グラフB(徐々にこの動きに)(縦軸：ｙ、横軸：時間)");
            lineChartC = createLineChart(0xCC0099, 220);
            new Label(chartArea, 5, 225, "混合率(縦軸：混合率(%)、横軸：時間)");
            lineChartD = createLineChart(0x000000, 330);
            new Label(chartArea, 5, 335, "結果(縦軸：ｙ、横軸：時間)");
            testButton = new PushButton(this, 415, 0, "テスト", onClickButton);
            testButton.width = 50;
            
            initMoveTest();
            initPlot();
            addChild(chartArea);
        }
        
        /**
         * グラフの初期化
         * グラフに点を打っていく。
         */
        private function initPlot(): void 
        {
            var i: uint, n: uint = 100, 
                dataA: Array = [], dataB: Array = [], dataC: Array = [], dataD: Array = [];
            for (i = 0; i < n; i++) 
            {
                // 現在、またはベースとなる動きのグラフ作成　(このあたりを変更するとグラフが変わる)
                dataA[i] = n - i;
                //dataA[i] = 50;
            }
            lineChartA.data = dataA;
            for (i = 0; i < n; i++) 
            {
                // 目的の動きのグラフ　(このあたりを変更するとグラフが変わる)
                dataB[i] = 50 + 20 * Math.sin(i * 0.2);
            }
            lineChartB.data = dataB;
            for (i = 0; i < n; i++) 
            {
                // 混合率 (%)　(このあたりを変更するとグラフが変わる)
                dataC[i] = i * 100 / n;
            }
            lineChartC.data = dataC;
            for (i = 0; i < n; i++) 
            {
                // 結果　= 現在 ＋　(目的 - 現在) * 混合率
                dataD[i] = dataA[i] + (dataB[i] - dataA[i]) * dataC[i] / 100;
            }
            lineChartD.data = dataD;
        }
        
        /**
         * テストムービーを行う。
         * @param    e
         */
        private function loop(e: Event): void 
        {
            if (time >= resultData.length) 
            {
                removeEventListener(Event.ENTER_FRAME, loop);
                chartArea.visible = testButton.enabled = true;
                removeChild(moveTestArea);
                return;
            }
            //box.x = time - resultData.length / 2;
            box.y = resultData[time++];
        }
        
        /**
         * テストボタンがクリックされたら
         * @param    e
         */
        private function onClickButton(e: MouseEvent): void 
        {
            chartArea.visible = testButton.enabled = false;
            time = 0; 
            // 計算した結果を resultData とする。
            resultData = lineChartD.data;
            //box.x = time - resultData.length / 2;
            box.y = resultData[time];
            addChild(moveTestArea);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        /**
         * ムービーのテストを行う際のオブジェクトを初期化
         */
        private function initMoveTest(): void 
        {
            
            var g: Graphics, i: uint, n: uint = 10;
            moveTestArea = new Sprite();
            moveTestArea.x = stage.stageWidth / 2, moveTestArea.y = stage.stageHeight / 2;
            g = moveTestArea.graphics;
            g.lineStyle(1, 0xCCCCCC);
            for (i = 0; i < n; i++) 
            {
                g.moveTo(- 250, (i - n / 2) * 50);
                g.lineTo(  250, (i - n / 2) * 50);
                g.moveTo((i - n / 2) * 50, - 250);
                g.lineTo((i - n / 2) * 50,   250);
            }
            new Label(moveTestArea,    0,    0,    "0");
            new Label(moveTestArea, -200,    0, "-200");
            new Label(moveTestArea, -100,    0, "-100");
            new Label(moveTestArea,  100,    0,  "100");
            new Label(moveTestArea,  200,    0,  "200");
            new Label(moveTestArea,    0, -200, "-200");
            new Label(moveTestArea,    0, -100, "-100");
            new Label(moveTestArea,    0,  100,  "100");
            new Label(moveTestArea,    0,  200,  "200");
            
            box = new Shape();
            g = box.graphics;
            g.beginFill(0x000000);
            g.drawRect( -25, -25, 50, 50);
            
            moveTestArea.addChild(box);
        }
        
        /**
         * チャートを作る。
         * @param    color    : ラインカラー
         * @param    ty        : チャートを addChild する位置
         * @return
         */
        private function createLineChart(color: uint, ty: int): LineChart
        {
            var line: LineChart = new LineChart(chartArea);
            line.autoScale = false;
            line.lineColor = color;
            line.maximum = 100;
            line.minimum = 0;
            line.width = 410;
            line.height = 100;
            line.y = ty;
            return line;
        }
    }
}