/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gEHf
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=95
    public class Euler95 extends Sprite {
        private var _tf : TextField;
        private var _primes : Array;
  
        public function Euler95() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText(solve().toString() + "\n");
            var g : int = getTimer();
            _tf.appendText((g - s).toString() + " ms\n");
        }
        
        private const N : int = 1000000;
        
        private function solve() : int
        {
            _primes = enumPrimes(Math.sqrt(N));
            
            var ar : Array = [0];
            for(var i : int = 1;i <= N;i++){
                ar.push(sumDivisor(i));
            }
            
            var max : int = 0;
            var maxj : int = -1;
            for(var j : int = 2;j <= N;j++){
                var mem : Object = {};
                for(var v : int = j,r : int = 0;v > 1 && v <= N && !mem[v];mem[v] = 1, v = ar[v], r++);
                if(v == j && max < r){ // smallest
                    max = r;
                    maxj = j;
                }
            }
            _tf.appendText(max.toString() + "\n");
            return maxj;
        }
        
        private function sumDivisor(m : int) : int
        {
            var n : int = m;
            var sum : int = 1;
            var sq : int = Math.sqrt(n);
            for each(var i : int in _primes){
                if(i > sq)break;
                for(var j : int = 1;n % i == 0 && n > 1;n /= i,j++);
                if(j > 1){
                    sum *= (Math.pow(i, j) - 1) / (i - 1);
                    sq = Math.sqrt(n);
                }
            }
            if(n > 1){
                sum *= (1 + n);
            }
            return sum - m;
        }
      
        private function enumPrimes(n : int) : Array
        {
            var ret : Array = [];
            
            var j : int = 1;
            for(var i : int = 3;i <= n;i+=2){
                if(i >= (j + 1) * (j + 1)){
                    j++;
                }
                var flag : Boolean = true;
                for each(var v : int in ret){
                    if(v > j)break;
                    if(i % v == 0){
                        flag = false;
                        break;
                    }
                }
                if(flag){
                    ret.push(i);
                }
            }
            ret.unshift(2);
            
            return ret;
        }
    }
}
