/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gDHS
 */

package 
{
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2Body;
	import com.actionsnippet.qbox.QuickBox2D;
	import com.actionsnippet.qbox.QuickObject;
	import flash.display.MovieClip;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	
	[SWF(width = 465, height = 465, backgroundColor = 0x333333, frameRate = 60)]
	public class Main extends MovieClip
	{
		private var sim:QuickBox2D;
		private var fixedPoint:b2Vec2 = new b2Vec2(7.75, 7.75);
		private var scale:Number = 30;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			sim = new QuickBox2D(this);
			sim.gravity = new b2Vec2(0, 0);
			
			sim.setDefault( { fillColor:0xFFFFFF, lineColor:0x333333 } );
			
			for (var i:int = 0; i < 20; i++) 
			{
				sim.addCircle( { x:Math.random() * 15.5, y:Math.random() * 15.5, radius:Math.random()+0.2 } );
			}
			
			createDoll(7.75, 7.75);
			
			sim.start();
			sim.mouseDrag();
			
			addEventListener(Event.ENTER_FRAME, loop)
		}
		
		private function loop(e:Event):void 
		{
			for (var body:b2Body = sim.w.m_bodyList; body ; body = body.GetNext()) {
				if (body.IsSleeping())
					continue;
					
				var f:b2Vec2 = fixedPoint.Copy();
				f.Subtract(body.GetPosition());
				f.Normalize();
				f.Multiply(20);
				body.ApplyForce(f, body.GetWorldCenter());
			}
		}
		
		private function createDoll(x:Number = 0, y:Number = 0, scale:Number = 30):void 
		{
			x *= scale;
			y *= scale;
			x += -232;
			y += 4;
			
			var head:QuickObject = sim.addCircle( { x:(232+x) / scale, y:(4+y) / scale, radius:17 / scale, restitution:10 } );
			var torsoA:QuickObject = sim.addBox( { x:(232+x) / scale, y:(35+y) / scale, width:53 / scale, height:28 / scale, restitution:2 } );
			var torsoB:QuickObject = sim.addBox( { x:(232+x) / scale, y:(55+y) / scale, width:45 / scale, height:28 / scale, restitution:2 } );
			var torsoC:QuickObject = sim.addBox( { x:(232+x) / scale, y:(75+y) / scale, width:40 / scale, height:28 / scale, restitution:2 } );
			var pelvis:QuickObject = sim.addBox( { x:(232+x) / scale, y:(95+y) / scale, width:45 / scale, height:25 / scale, restitution:2 } );
			var leftArmA:QuickObject = sim.addBox( { x:(185+x) / scale, y:(28+y) / scale, width:50 / scale, height:15 / scale, restitution:2 } );
			var leftArmB:QuickObject = sim.addBox( { x:(135+x) / scale, y:(28+y) / scale, width:50 / scale, height:15 / scale, restitution:2 } );
			var rightArmA:QuickObject = sim.addBox( { x:(280+x) / scale, y:(28+y) / scale, width:50 / scale, height:15 / scale, restitution:2 } );
			var rightArmB:QuickObject = sim.addBox( { x:(330+x) / scale, y:(28+y) / scale, width:50 / scale, height:15 / scale, restitution:2 } );
			var leftLegA:QuickObject = sim.addBox( { x:(217+x) / scale, y:(132+y) / scale, width:16 / scale, height:55 / scale } );
			var leftLegB:QuickObject = sim.addBox( { x:(246+x) / scale, y:(132+y) / scale, width:16 / scale, height:55 / scale } );
			var rightLegA:QuickObject = sim.addBox( { x:(217+x) / scale, y:(185+y) / scale, width:16 / scale, height:55 / scale } );
			var rightLegB:QuickObject = sim.addBox( { x:(246+x) / scale, y:(185+y) / scale, width:16 / scale, height:55 / scale } );
			sim.setDefault( { type:"revolute", collideConnected:false, enableLimit:true, lineColor:0xFFFFFF } );
			sim.addJoint( { a:head.body, b:torsoA.body, lowerAngle:-0.2, upperAngle:0.2 } );
			sim.addJoint( { a:torsoA.body, b:torsoB.body, lowerAngle:-0.2, upperAngle:0.2 } );
			sim.addJoint( { a:torsoB.body, b:torsoC.body, lowerAngle:-0.2, upperAngle:0.2 } );
			sim.addJoint( { a:torsoC.body, b:pelvis.body, lowerAngle:-0.2, upperAngle:0.2 } );
			sim.addJoint( { a:torsoA.body, b:leftArmA.body, x1:(212+x) / scale, y1:(30+y) / scale, lowerAngle:-2, upperAngle:1} );
			sim.addJoint( { a:leftArmA.body, b:leftArmB.body, x1:(155+x) / scale, y1:(28+y) / scale, lowerAngle: -2, upperAngle:1 } );
			sim.addJoint( { a:torsoA.body, b:rightArmA.body, x1:(257+x) / scale, y1:(28+y) / scale, lowerAngle:-1, upperAngle:2} );
			sim.addJoint( { a:rightArmA.body, b:rightArmB.body, x1:(314+x) / scale, y1:(28+y) / scale, lowerAngle: -1, upperAngle:2 } );
			sim.addJoint( { a:pelvis.body, b:leftLegA.body, x1:(217+x) / scale, y1:(110+y) / scale, lowerAngle: -1, upperAngle:1 } );
			sim.addJoint( { a:pelvis.body, b:leftLegB.body, x1:(246+x) / scale, y1:(110+y) / scale, lowerAngle: -1, upperAngle:1 } );
			sim.addJoint( { a:leftLegA.body, b:rightLegA.body, x1:(217+x) / scale, y1:(163+y) / scale, lowerAngle: -1, upperAngle:1 } );
			sim.addJoint( { a:leftLegB.body, b:rightLegB.body, x1:(246+x) / scale, y1:(163+y) / scale, lowerAngle: -1, upperAngle:1 } );
		}
		
	}
	
}
