/**
 * Copyright Test_Dept ( http://wonderfl.net/user/Test_Dept )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gDBr
 */

// forked from Test_Dept's Legacy Display
package {
    
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * LegacyDisplay
     * @author Test Dept
     */
    [SWF(backgroundColor='#cccccc', width='465', height='465', frameRate='12')]
    public class LegacyDisplay extends Sprite {
        
        public function LegacyDisplay() {
            
            var color : uint = 0xffff00;
            var hiColor : uint = color;
            var loColor : uint = getDarkColor(hiColor, 0.1);
            
            var patterns1 : Array = [
                'a', 'b', 'c', 'd', 'e', 'f', 'g',
                'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                '.',
                'abcdefghijklmnop.', ''
            ];
            var index1 : int = 0;

            var patterns2 : Array = [
                'abcdefgh', 'cd', 'abcplgfe', 'abcpldfe', 'hplcd',
                'abdefhpl',  'abdefghpl', 'abcd', 'abcdefghpl', 'abcdefhpl'
            ];
            var index2 : int = 0;
            
            addEventListener(Event.ENTER_FRAME, function(event : Event) : void {
                
                var g : Graphics = graphics;
                g.clear();
                
                var pattern1 : String = patterns1[index1];
                index1 = (index1 + 1) % patterns1.length;
                var pattern2 : String = patterns2[index2];
                index2 = (index2 + 1) % patterns2.length;
                
                LEDUtil.draw7Segments(g, pattern1, 10, 10, 
                    200, 0, hiColor, loColor, 0x000000); 
                LEDUtil.draw7Segments(g, pattern2, 215, 10,
                    200, 0, hiColor, loColor, 0x000000); 
            } );
        }
        
        private static function getDarkColor(color : uint, scale : Number) : uint {
            var r : uint = (color >>> 16) & 0xff;
            var g : uint = (color >>> 8) & 0xff;
            var b : uint = color & 0xff;
            r = (r * scale) & 0xff;
            g = (g * scale) & 0xff;
            b = (b * scale) & 0xff;
            return (r << 16) | (g << 8) | b;
        }
    }
}

import flash.display.Graphics;

/*

 Segment Layout

     a   b
   h i j k c
     p   l 
   g o n m d
     f   e

*/
class LEDUtil {
    
    public static function draw7Segments(
        g : Graphics,
        pattern : String,
        x : Number,
        y : Number,
        width : Number,
        height : Number,
        hiColor : uint,
        loColor : uint,
        bgColor : uint
    ) : void {
        
        // auto size
        if (width <= 0) {
            width = height * 7 / 10;
        } else if (height <= 0) {
            height = width * 10 / 7;
        }
        
        g.beginFill(bgColor);
        g.drawRect(x, y, width, height);
        g.endFill();
        
        var scale : Number = (width / height > _SEG_WIDTH / _SEG_HEIGHT)?
            height / _SEG_HEIGHT : width / _SEG_WIDTH;
        
        var cx : Number = x + (width - _SEG_WIDTH * scale) / 2;
        var cy : Number = y + (height - _SEG_HEIGHT * scale) / 2;
        
        var on : Boolean;
        
        for (var i : int = 0; i < _ALL_SEGMENTS.length; i++) {
            var c : String = _ALL_SEGMENTS.charAt(i);
            on = (pattern != null && pattern.indexOf(c) != -1);
            drawSegment(g, c, cx, cy, scale, on? hiColor : loColor);
        }
        
        on = (pattern != null && pattern.indexOf('.') != -1);
        drawPoint(g, cx, cy, scale, on? hiColor : loColor);
    }
    
    private static function drawSegment(
        g : Graphics,
        segment : String,
        x : Number,
        y : Number,
        scale : Number,
        color : uint
    ) : void {
        
        var data : Array = _segmentData[segment];
        
        g.beginFill(color);
        
        var length : int = data.length / 2;
        
        for (var i : int = 0; i < length; i++) {
            
            var dx : Number = data[i * 2] * scale + x;
            var dy : Number = data[i * 2 + 1] * scale + y;
            
            if (i == 0) {
                g.moveTo(dx, dy);
            } else {
                g.lineTo(dx, dy);
            }
        }
        
        g.endFill();
    }
    
    private static function drawPoint(
        g : Graphics, 
        x : Number,
        y : Number,
        scale : Number,
        color : uint
    ) : void {
        g.beginFill(color);
        g.drawCircle(610 * scale + x, 910 * scale + y, 30 * scale);
        g.endFill();
    }
    
    private static const _SEG_WIDTH : Number = 690;
    
    private static const _SEG_HEIGHT : Number = 1000;
    
    private static const _ALL_SEGMENTS : String = 'abcdefghijklmnop';
    
    private static const _segmentData : Object = {
        'a' : [255, 184, 356, 184, 407, 142, 373, 102, 187, 102],
        'b' : [418, 144, 451, 184, 552, 184, 651, 102, 468, 102],
        'c' : [557, 190, 507, 455, 540, 495, 590, 454, 656, 108],
        'd' : [487, 550, 438, 816, 506, 898, 573, 547, 539, 507],
        'e' : [281, 863, 315, 903, 500, 903, 432, 821, 331, 821],
        'f' : [35, 903, 220, 903, 270, 861, 236, 821, 135, 821],
        'g' : [97, 548, 30, 897, 129, 815, 180, 547, 147, 507],
        'h' : [114, 455, 148, 495, 198, 454, 248, 189, 181, 107],
        'i' : [233, 315, 280, 452, 341, 493, 326, 331, 255, 200],
        'j' : [361, 190, 334, 331, 349, 485, 422, 312, 445, 189, 412, 149],
        'k' : [430, 316, 354, 492, 432, 452, 522, 334, 547, 200],
        'l' : [354, 502, 408, 542, 484, 542, 534, 500, 501, 460, 434, 460],
        'm' : [361, 674, 432, 805, 454, 691, 405, 550, 351, 509],
        'n' : [265, 693, 242, 816, 276, 856, 326, 815, 353, 676, 343, 518],
        'o' : [255, 546, 165, 671, 139, 805, 258, 689, 338, 510],
        'p' : [153, 502, 187, 542, 254, 542, 338, 500, 278, 460, 203, 460]
    };      
}    
