/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gCpB
 */

// forked from demouth's Biyon Biyon
// forked from demouth's forked from: ひも的な何か
// forked from demouth's ひも的な何か
package  
{
    import flash.text.TextField;
    import flash.filters.GlowFilter;
    import flash.display.BlendMode;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    [SWF(frameRate='60')] 
    public class Main extends Sprite
    {
        protected var joints:Vector.<Joint> = new Vector.<Joint>();
        protected var biyon:Vector.<Joint> = new Vector.<Joint>();
        protected var bodySp:Vector.<Sprite> = new Vector.<Sprite>();
        protected var canvas:Sprite = new Sprite();
        protected var fric:Number = 0.01;
        protected var spring:Number = 0.995;//ばね的なもの？
        protected var range:int = 10;//前後に影響を与える範囲
        protected static const NUM:int = 10;
        protected static const LENGTH:int = 25;
        
        public function Main() 
        {
            if (this.stage) this.init()
            else this.addEventListener(Event.ADDED_TO_STAGE , this.init);
        }
        
        protected function init(event:Event = null):void
        {
            this.stage.align = StageAlign.TOP_LEFT;
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.create();
            
            var t:TextField = new TextField();
            t.htmlText = "<font size='40'>THE VERY\nHUNGRY\nCATERPILLAR</font>";
            t.width = t.textWidth + 10;
            t.height = t.textHeight + 10;
            t.selectable = false;
            this.addChild( t );
            
            this.addEventListener(Event.ENTER_FRAME , this.enterFrameHandler);
        }
        
        protected function create():void
        {
            this.addChild( this.canvas );
            this.canvas.filters = [ new GlowFilter( 0xDDDD22, 1, 8, 8, 3, 1 )];
            
            for (var i:int = 0; i < NUM; i++) 
            {
                var j:Joint = new Joint();
                var b:Joint = new Joint();
                
                j.x = 50;
                j.y = this.stage.stageHeight * 0.7;
                b.x = 50;
                b.y = this.stage.stageHeight * 0.7;
                
                this.joints.push(j);
                this.biyon.push(b);
                
            }
            
            for (i = 0; i < NUM; i++) 
            {
                var s:Sprite;
                if( i == 0 ) s = new Head()
                else s = new Body();
                this.blendMode = BlendMode.LAYER;
                s.blendMode = BlendMode.MULTIPLY;
                if( i == NUM-1 ) s.scaleY = 0.7;
                this.canvas.addChildAt( s,0 );
                
                this.bodySp.push(s);
            }
        }
        
        private function enterFrameHandler(event:Event):void
        {
            this.graphics.clear();
            
            this.calc();
            this.move();
            this.moveBiyon();
            //this.draw();
        }
        
        private function calc():void
        {
            var l:int = this.joints.length;
            for (var i:int = 0; i < l; i++) 
            {
                if (i == 0)
                {
                    this.joints[0].x = this.stage.mouseX;
                    this.joints[0].y = this.stage.mouseY;
                    continue;
                }
                
                var b:int = this.range;
                var a:int = this.range;
                var now:Joint = this.joints[i];
                
                for (var j:int = i-b; j < i+a+1; j++) 
                {
                    if (j >= 0 && l > j && j != i)
                    {
                        var t:Joint = this.joints[j];
                        
                        var angle:Number = Math.atan2(now.y-t.y, now.x-t.x);
                        now.sx -= Math.cos(angle) * 0.1;
                        now.sy -= Math.sin(angle) * 0.1;
                    }
                }
            }
        }
        
        private function move():void
        {
            var l:int = this.joints.length;
            for (var i:int = 0; i < l; i++) 
            {
                var now:Joint = this.joints[i];
                if(i!=0)now.sy += 0.3;
                now.x += now.sx * this.fric;
                now.y += now.sy * this.fric;
                
                if (i == 0) continue;
                var b:Joint = this.joints[i-1];
                
                var angle:Number = Math.atan2(b.y - now.y, b.x - now.x);
                now.x = b.x - Math.cos(angle) * LENGTH;
                now.y = b.y - Math.sin(angle) * LENGTH;
                
                now.sx *= this.spring;
                now.sy *= this.spring;
            }
        }
        
        private function moveBiyon():void
        {
            var l:int = this.joints.length;
            for (var i:int = 0; i < l; i++) 
            {
                var j:Joint = this.joints[i];
                var b:Joint = this.biyon[i];
                b.sx *= 0.7;
                b.sy *= 0.7;
                b.sx += (j.x - b.x)*0.01;
                b.sy += (j.y - b.y)*0.01;
                b.x += b.sx;
                b.y += b.sy;
                
                this.bodySp[i].x = b.x;
                this.bodySp[i].y = b.y;
                this.bodySp[i].rotation = Math.atan2( b.sy , b.sx ) * 180 / Math.PI;
            }
        }
        
        private function draw():void
        {
            var g:Graphics = this.graphics;
            var l:int = this.biyon.length;
            
            for (var i:int = 0; i < l; i++) 
            {
                if( i == 0 )
                {
                    g.beginFill(0xFF0000 , 0.5);
                    g.drawCircle(this.biyon[i].x, this.biyon[i].y , 10 );
                    g.endFill();
                }

                g.beginFill(0);
                g.drawCircle(this.biyon[i].x, this.biyon[i].y, 1);
                g.endFill();
            }
            
        }
    }

}
import flash.display.Graphics;
import flash.display.Sprite;

class Joint
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var sx:Number = 0;
    public var sy:Number = 0;
}

class Head extends Sprite
{
    public function Head()
    {
        var g:Graphics = this.graphics;
        g.beginFill( 0xFF0000 , 1 );
        g.drawEllipse(-20, -25, 40, 50);
        g.endFill();
        
        //目
        g.beginFill( 0xFFFF00 , 1 );
        g.drawEllipse(-8, -15, 10, 20);
        g.endFill();
        g.beginFill( 0x008800 , 1 );
        g.drawEllipse(-5, -12, 5, 16);
        g.endFill();
        
        g.beginFill( 0xFFFF00 , 1 );
        g.drawEllipse( 3, -15, 10, 20);
        g.endFill();
        g.beginFill( 0x008800 , 1 );
        g.drawEllipse( 5, -12, 5, 16);
        g.endFill();
        
        g.beginFill( 0x666666 , 1 );
        g.drawRect( -3, 10, 6, 6);
        g.endFill();
        
        g.lineStyle(5, 0x666666, 1);
        g.moveTo(-3 , -20);
        g.lineTo(-10 , -40);
        
        g.lineStyle(5, 0x666666, 1);
        g.moveTo(3 , -20);
        g.lineTo(10 , -40);
    }
}

class Body extends Sprite
{
    public function Body()
    {
        var g:Graphics = this.graphics;
        var color:uint = int(Math.random()*100)<<16 | (100 + int(Math.random()*100))<<8 | int(Math.random()*100) ;
        g.beginFill( color , 1 );
        g.drawEllipse(-15, -25, 30, 50);
        g.endFill();
        
        g.beginFill( 0x666600 , 1 );
        g.drawEllipse(-5, 23, 4, 7);
        g.drawEllipse( 2, 23, 4, 7);
        g.endFill();
        
        g.lineStyle(2, 0xBB6666, 1);
        g.moveTo(10 , -20);
        g.lineTo(10 , -25);
        g.moveTo(-5 , -25);
        g.lineTo(-5 , -30);
        
        g.lineStyle(2, 0x66BB66, 1);
        g.moveTo(-10 , -20);
        g.lineTo(-10 , -25);
        g.moveTo(5 , -25);
        g.lineTo(5 , -30);
    }
}
