/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gCFW
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#FFFFFF")]
    /**
     * Paul KLEE に触発されて（素描）
     * @author Aquioux(Yoshida, Akio)
     */
    public class Main extends Sprite {
        private const STAGE_WIDTH:int  = stage.stageWidth;
        private const STAGE_HEIGHT:int = stage.stageHeight;
        private const SEGMENT_NUM_HORISONTAL:int = 15;
        private const SEGMENT_NUM_VERTICAL:int   = 15;
        private const SEGMENT_LENGTH_HORISONTAL:int = STAGE_WIDTH / SEGMENT_NUM_HORISONTAL;
        private const SEGMENT_LENGTH_VERTICAL:int   = STAGE_HEIGHT / SEGMENT_NUM_VERTICAL;
        
        private var bmdHorisontal_:BitmapData;
        private var bmdVertical_:BitmapData;
        
        
        public function Main():void {
            setup();
            stage.addEventListener(MouseEvent.CLICK, draw);
            draw(null);
        }
        
        private function setup():void {
            bmdHorisontal_ = new BitmapData(STAGE_WIDTH, STAGE_HEIGHT, false);
            bmdVertical_   = bmdHorisontal_.clone();
            
            addChild(new Bitmap(bmdHorisontal_));
            //addChild(new Bitmap(bmdVertical_));
        }
        
        private function draw(e:MouseEvent):void {
            var c:uint;
            var rect:Rectangle = new Rectangle(0, 0, SEGMENT_LENGTH_HORISONTAL, STAGE_HEIGHT);
            var angle:int  = calcAngle();
            var offset:int = calcOffset();
            
            for (var i:int = 0; i < SEGMENT_NUM_HORISONTAL; i++) {
                rect.x = i * SEGMENT_LENGTH_HORISONTAL;
                c = CycleRGB.getColor(i * angle + offset);
                bmdHorisontal_.fillRect(rect, c);
            }
            rect = new Rectangle(0, 0, STAGE_WIDTH, SEGMENT_LENGTH_VERTICAL);
            angle  = calcAngle();
            offset = calcOffset();
            for (var j:int = 0; j < SEGMENT_NUM_VERTICAL; j++) {
                rect.y = j * SEGMENT_LENGTH_VERTICAL;
                c = CycleRGB.getColor(j * angle + offset);
                bmdVertical_.fillRect(rect, c);
            }
            
            bmdHorisontal_.draw(bmdVertical_, null, null, BlendMode.DARKEN);
        }
        
        private function calcAngle():int {
            return ((Math.random() * 3 >> 0) + 2) * 5;
        }
        private function calcOffset():int {
            return (Math.random() * 12 >> 0) * 10;
        }
    }
}

// package aquioux.display.colorUtil {
    /**
     * コサインカーブで色相環的な RGB を計算
     * @author Aquioux(YOSHIDA, Akio)
     */
    /*public*/ class CycleRGB {
        /**
         * 32bit カラーのためのアルファ値（0～255）
         */
        static public function get alpha():uint { return _alpha; }
        static public function set alpha(value:uint):void {
            _alpha = (value > 0xFF) ? 0xFF : value;
        }
        private static var _alpha:uint = 0xFF;
    
        private static const PI:Number = Math.PI;        // 円周率
        private static const DEGREE120:Number  = PI * 2 / 3;    // 120度（弧度法形式）
        
        /**
         * 角度に応じた RGB を得る
         * @param    angle    HSV のように角度（度数法）を指定
         * @return    色（0xNNNNNN）
         */
        public static function getColor(angle:Number):uint {
            var radian:Number = angle * PI / 180;
            var r:uint = (Math.cos(radian)             + 1) * 0xFF >> 1;
            var g:uint = (Math.cos(radian + DEGREE120) + 1) * 0xFF >> 1;
            var b:uint = (Math.cos(radian - DEGREE120) + 1) * 0xFF >> 1;
            return r << 16 | g << 8 | b;
        }
        
        /**
         * 角度に応じた RGB を得る（32bit カラー）
         * @param    angle    HSV のように角度（度数法）を指定
         * @return    色（0xNNNNNNNN）
         */
        public static function getColor32(angle:Number):uint {
            return _alpha << 24 | getColor(angle);
        }
    }
//}