/**
 * Copyright soundkitchen ( http://wonderfl.net/user/soundkitchen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gBPL
 */

package
{
    import flash.display.Sprite;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xFFFFFF)]

    public class Sample extends Sprite
    {
        public function Sample()
        {
            //  オブジェクトを作成
            var ball:Sprite = new Sprite();

            //  座標を指定
            ball.x = 100;
            ball.y = 100;

            //  丸を描画
            ball.graphics.beginFill(0x000000);
            ball.graphics.drawCircle(0, 0, 40);
            ball.graphics.endFill();

            //  ステージに配置
            addChild(ball);

            BetweenAS3.serial(
                //  ボール浮く
                BetweenAS3.to(ball, {
                    _dropShadowFilter: {
                        alpha: .6,
                        angle: 135,
                        distance: 30,
                        blurX: 32,
                        blurY: 32
                    }
                }, 2, Cubic.easeInOut),
                //  ボール動く
                BetweenAS3.to(ball, {
                    x: 300,
                    _dropShadowFilter: {
                        angle: 45
                    }
                }, 2, Expo.easeInOut),
                //  ボール着く
                BetweenAS3.to(ball, {
                    _dropShadowFilter: {
                        distance: 0,
                        blurX: 0,
                        blurY: 0
                    }
                }, 2, Cubic.easeInOut)
            ).play();
        }
    }
}
