/**
 * Copyright wetcradle ( http://wonderfl.net/user/wetcradle )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gAvv
 */

/**
finalとすることで高速化を行うことはできなかった。
forkして変数アクセスについても検証したが同様の結果。
ラルフがflashcampで言っていたことはどういう事だったんだろうか。
*/
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    public class FinalClassTest extends Sprite {
        public function FinalClassTest():void {
			var textField:TextField = new TextField();
			textField.width = textField.height = 400;
			addChild(textField);
			textField.text = "not final, final, override\n";
			
			var notFinalSum:Number = 0;
			var finalSum:Number = 0;
			var overrideSum:Number = 0;
			var notFinalClass:Object = new NotFinalClass();
			var finalClass:Object = new FinalClass();
			var overrideClass:Object = new OverrideClass();
			for (var i:int=0; i<10; i++) {
				var notFinalTime:Number = doTest(notFinalClass);
				var finalTime:Number = doTest(finalClass);
				var overrideTime:Number = doTest(overrideClass);
				notFinalSum += notFinalTime;
				finalSum += finalTime;
				overrideSum += overrideTime;
				textField.appendText(String(notFinalTime)+", "+String(finalTime)+", "+String(overrideTime)+"\n");
			}
			textField.appendText(String(notFinalSum)+", "+String(finalSum)+", "+String(overrideSum)+"\n");
        }
		private function doTest(object:Object):Number {
			var startDate:Date = new Date();
			for (var i:int=0; i<1e+6; i=object.inc(i));
			return new Date().time - startDate.time;
		}
    }
}

class NotFinalClass {
	public function inc(value:int):int {
		return value + 1;
	}
}

final class FinalClass {
	public function inc(value:int):int {
		return value + 1;
	}
}

class OverrideClass extends NotFinalClass {
	override public function inc(value:int):int {
		return value + 1;
	}
}
