/**
 * Copyright asfgu ( http://wonderfl.net/user/asfgu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g9ev
 */

// forked from asfgu's テトリス　ver0.1
/*
　　ここで使用しているコードはPoisonCodeさんのところで紹介されている物を
　　引用させていただいています
　　PoisonCode→http://poisoncode.blog77.fc2.com/
*/
/*
  操作方法は書いてあるとおりです。
  ちなみにＨＤはハードドロップの略。
  
  行を消すと消した行数に応じてお邪魔テトリミノが出現します。
  一度に多くの行を消せばより多くのスコアを稼げますが、
  同時によりやっかいなお邪魔テトリミノが出現します。
  お邪魔テトリミノにめげずに高得点を目指してください。
  爆弾を使用すると落下中のテトリミノを爆破できます。
  爆弾は特定ポイントを稼ぐ毎に一個追加されます。
  ＊注意＊ＨＤが動かないと言う方
  半角で操作してください。全角だと動きません
*/
/*      
  目標：透過ブロックの生成
      ２画面対戦可能化
      対戦用ＣＰＵのＡＩ構築
      通信対戦可能化
      ＢＧＭ，ＳＥの追加
      ビットマップ使用
      その他諸々のアニメーション追加　　　　
*/
package {
	
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.ui.Keyboard;
    import flash.utils.ByteArray;
    import flash.utils.Timer;
   
    [SWF(width="500", height="400", backgroundColor="#00CED1", frameRate="30")] 

    public class Tetris extends Sprite {
    		private const FIELD_WIDTH:uint  = 14;      //テトリス盤の幅
		private const FIELD_HEIGHT:uint = 24;      //テトリス盤の高さ
		
		private const CELL_WIDTH:uint   = 15;      //セル一つの幅、つまりブロック一個の幅
		private const CELL_HEIGHT:uint  = 15;      //セル一つの高さ、つまりブロック一個の高さ
		
		private const EMPTY:uint        =  0;      //中身が空のセル
		private const WALL:uint         = 20;      //中身が壁のセル
		private const LOCKED:uint       = 30;      //確定したセル
		
		private const WALL_COLOR:uint   = 0x7A5B52;//壁の色
		private const GRID_COLOR:uint   = 0xFFFFFF;//グリッドの色、わかりやすく言うと壁を囲む線の色
　　　　　	
		private const TET_WIDTH:uint    =  4;      //テトリミノの枠の幅
		private const TET_HEIGHT:uint   =  4;      //テトリミノの枠の高さ
	    
	    private const TIME_DECREASE:Number = 1000; //１秒毎の時間減少
	    private const DELAY_RANGE:Number   = 1000; //テトリミノが落ちるスピード
	    private const DELAY_MIN:Number     =  100; //テトリミノの最速落下速度
	    private const DELETE_RAG:Number    =  150; //揃ったラインが消えるまでのラグ
	    private const MOVE_SPEED:Number    =   80; //テトリスの移動受付間隔
	    private const TIME_LEFT:Number     =  120; //残り時間（秒）
	    private const BOMB_MAKE:Number     =  200; //爆弾を生成するために必要なポイント
        
        private const MAP_BLANK:Array    = [20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20];//新しいラインの配列
        
        //テトリミノの色の２次元配列
        private const TET_COLORS:Array = [
        0xE9EE11, // tetPattern01 黄色
        0x4DE6E1, // tetPattern02　水色
        0xEA68E7, // tetPattern03　ピンク
        0xE49E1B, // tetPattern04　カーキ
        0x2746D8, // tetPattern05　青
        0x46DF20, // tetPattern06　明るい緑
        0xED2212, // tetPattern07　赤
        0xD2691E, // tetPattern08　チョコ色
        0xC0C0C0, // tetPattern09　シルバー
        0xDC143C, // tetPattern10 クリムゾン
        0xFFD700  // tetPattern11　ゴールド
        ];
        
        //テトリミノの形の３次元配列
        private const tetPattern01:Array = [[0, 0, 0, 0], [0, 1, 1, 0], [0, 1, 1, 0], [0, 0, 0, 0]];//正方形
        private const tetPattern02:Array = [[0, 0, 0, 0], [2, 2, 2, 2], [0, 0, 0, 0], [0, 0, 0, 0]];//I
        private const tetPattern03:Array = [[0, 0, 0, 0], [0, 0, 3, 0], [0, 3, 3, 3], [0, 0, 0, 0]];//テトラ
        private const tetPattern04:Array = [[0, 0, 0, 0], [0, 0, 0, 4], [0, 4, 4, 4], [0, 0, 0, 0]];//Ｌ
        private const tetPattern05:Array = [[0, 0, 0, 0], [0, 5, 0, 0], [0, 5, 5, 5], [0, 0, 0, 0]];//逆Ｌ
        private const tetPattern06:Array = [[0, 0, 0, 0], [0, 0, 6, 6], [0, 6, 6, 0], [0, 0, 0, 0]];//逆Ｚ
        private const tetPattern07:Array = [[0, 0, 0, 0], [0, 7, 7, 0], [0, 0, 7, 7], [0, 0, 0, 0]];//Ｚ
        private const tetPattern08:Array = [[0, 0, 0, 0], [0, 0, 8, 0], [0, 8, 8, 8], [0, 0, 8, 0]];//+
        private const tetPattern09:Array = [[0, 0, 0, 0], [9, 0, 9, 0], [9, 0, 9, 0], [0, 9, 0, 0]];//U
        private const tetPattern10:Array = [[0, 10, 0, 0], [10, 0, 10, 0], [0, 10, 0, 0], [0, 0, 0, 0]];//空洞        
        private const tetPattern11:Array = [[0, 11, 11, 0], [11, 0, 0, 11], [11, 0, 0, 0], [0, 11, 0, 0]];//C
        
        private const TETROMINOS:Array   = [
        tetPattern01, tetPattern02, tetPattern03, tetPattern04, tetPattern05, tetPattern06, tetPattern07, tetPattern08, tetPattern09, tetPattern10, tetPattern11
        ];
        
        private var location:Point;        //描画のポイントの指定
        private var currentTetromino:Array;//現在のテトリミノ
        private var currentIndex:uint;     //テトリミノの形と色をつなげる変数
        private var nextIndex:uint;        //次のテトリミノのインデックス
        
        private var deleteLineIndex:Array; //揃った列の消去
        private var ragTimer:Timer;        //揃った列が消えるのを計るタイマー
        private var dropTimer:Timer;       //テトリミノが落ちるスピードを計るタイマー
        private var moveTimer:Timer;       //テトリミノが移動するスピード
        private var timeLeft:Timer;        //残り時間
        
        private var gameover:Boolean;      //ゲームオーバー判定
        
        private var muki:int   = 0;        //テトリミノの進行方向
        
        private var cursc:int  = BOMB_MAKE;//爆弾生成時のポイント
        private var bomnum:int = 0;　　　　　　　//爆弾個数
        
        private var score:int  = 0;        //スコア
        private var count:int  = 0;        //加算ポイント
        private var time:int   = 0;        //残り時間
        private var texsc:TextField;       //スコア表示
        private var textm:TextField;       //時間
        private var texbm:TextField;       //爆弾
        
        private var finish:TextField;      //FINISH文字
        private var you:TextField;         //あなたのスコア
        private var showsc:TextField;      //最終スコア
        private var end:TextField;         //GAMEOVER
        private var retry:TextField;       //リトライ表示
       
        private var scoreboard:Sprite;     //右下のスコアボード
        private var setumei:Sprite;        //説明ボード
        private var kuromaku:Sprite;       //黒幕の表示
        private var tetboard:Sprite;       //テトリスボード
 
    		//フィールドマップ元データ
    		private const FIELDMAP:Array = [
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20,20,20,20,20,20,20,20,20,20,20,20,20, 20]
		];
		
		//フィールドマップカラー元データ
		private const FIELDMAPCOLOR:Array = [
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
		];
		
　　　　　　　//フィールドに空のセルと壁のセルを設定する
		private var fieldMap:Array = [
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20],
			[20,20,20,20,20,20,20,20,20,20,20,20,20, 20]
		];
		
		//フィールドに配置されているセルの色の描画設定をする
		private var fieldMapColor:Array = [
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
		];private var gameField:Shape;
		
		//Tetrisクラスの初期化
		public function Tetris():void {
			init()
		}
		
		public function RestartGame(event:KeyboardEvent):void{
			if(event.keyCode == 82){
				stage.removeEventListener(KeyboardEvent.KEY_DOWN, RestartGame);//イベントリスナーの除去
				
				scoreboard.removeChild(textm);
				scoreboard.removeChild(texsc);
				/*
				if(kuromaku.contains(finish)){
					//kuromaku.removeChild(finish);//テキストの描画
					//kuromaku.removeChild(you);//テキストの描画
					//kuromaku.removeChild(showsc);//テキストの描画
					//removeChild(kuromaku);
				}
				
				else if(kuromaku.contains(end)){
					
					kuromaku.removeChild(end);
					//removeChild(kuromaku);
				}
				*/
				removeChild(kuromaku);
				fieldMap = clone(FIELDMAP);
				fieldMapColor = clone(FIELDMAPCOLOR);
				muki = 0;
				init();
			}
		}
		
		private function clone(source:Object):*{
			var ba:ByteArray = new ByteArray();
			ba.writeObject(source);
			ba.position = 0;
			return(ba.readObject());
		}
		
		//テトリスゲームフィールド生成
        public function init():void {
        		stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);//キーイベント（入力）の追加
	  		stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);//キーイベント（非入力）の追加
			
			//テトリスボードの設定
			tetboard = new Sprite();
			addChild(tetboard);
			tetboard.graphics.beginFill(0x7A5B52);
        		tetboard.graphics.drawRoundRect(0, 0, 250, 400, 50);
			tetboard.graphics.endFill();
			
			//説明ボード設定
			setumei = new Sprite();
			addChild(setumei);
			setumei.graphics.beginFill(0x7A5B52);
        		setumei.graphics.drawRoundRect(300, 0, 150, 250, 50);
			setumei.graphics.endFill();
			
			//スコアボードの設定
			scoreboard = new Sprite();
			addChild(scoreboard);
			scoreboard.graphics.beginFill(0x7A5B52);
        		scoreboard.graphics.drawRoundRect(300, 280, 150, 120, 50);
			scoreboard.graphics.endFill();
			
			//ゲームフィールドの設定
			gameField = new Shape();//新しいフィールドをshapeで生成
			tetboard.addChild(gameField);
			gameField.x = CELL_WIDTH;//セルの幅の設定
			gameField.y = CELL_HEIGHT;//セルの高さの設定
		
			currentTetromino = new Array();//新しいテトリミノの生成
			currentIndex     = createTetromino(); //テトリミノの選択
			currentTetromino = TETROMINOS[currentIndex];//テトリミノの登録
			location = new Point(5, 0);//描画ポイントの設定
			nextTetromino(true);
			fullDrawing();
			
			//自動落下設定
			dropTimer = new Timer(DELAY_RANGE);//落下タイマーの生成
			dropTimer.addEventListener(TimerEvent.TIMER, onDropTetromino);//イベントの追加
			dropTimer.start();//タイマーの開始
			
			//消去時のラグ設定
			ragTimer = new Timer(DELETE_RAG, 1);//消去ラグの生成
			ragTimer.addEventListener(TimerEvent.TIMER, fillMapBlank);//イベントの追加
			
			//テトリスの移動設定
			moveTimer = new Timer(MOVE_SPEED);//移動タイマーの生成→０．１秒毎にテトリミノの移動受付
			moveTimer.addEventListener(TimerEvent.TIMER, onEnterFrame);//イベントの追加
			moveTimer.start();//タイマーの開始
			
			//説明ボード中身
			var set1:TextField = createTextField("操作方法", 20, 0x0);
			set1.x = 330;
			set1.y = 10;
			var set2:TextField = createTextField("移動：", 20, 0x0);
			set2.x = 310;
			set2.y = 40;
			var set3:TextField = createTextField("右：→", 20, 0x0);
			set3.x = 330;
			set3.y = 70;
			var set4:TextField = createTextField("左：←", 20, 0x0);
			set4.x = 330;
			set4.y = 100;
			var set5:TextField = createTextField("下：↓", 20, 0x0);
			set5.x = 330;
			set5.y = 130;
			var set6:TextField = createTextField("回転：↑", 20, 0x0);
			set6.x = 310;
			set6.y = 160;
			var set7:TextField = createTextField("ＨＤ ：スペース", 20, 0x0);
			set7.x = 314;
			set7.y = 190;
			var set8:TextField = createTextField("爆弾：Ｂ", 20, 0x0);
			set8.x = 310;
			set8.y = 220;
			setumei.addChild(set1);
			setumei.addChild(set2);
			setumei.addChild(set3);
			setumei.addChild(set4);
			setumei.addChild(set5);
			setumei.addChild(set6);
			setumei.addChild(set7);
			setumei.addChild(set8);
			
			//初期スコア
			score = 0;
			ScoreCheck();
			
			//爆弾個数
			bomnum = 0;
			cursc  = BOMB_MAKE;
			bombscore();
			
			//残り時間設定
			timeLeft = new Timer(TIME_DECREASE);//残り時間の作成
			time = TIME_LEFT;
			dropTimer.addEventListener(TimerEvent.TIMER, TimeCheck);//イベントの追加
			timeLeft.start();
			
			//初期時間
			textm = createTextField("残り時間 : "+time, 20, 0x0);
        		textm.x = 306;
			textm.y = 330;
			scoreboard.addChild(textm);
			
			     	
        } // init() close
        
        //テキスト生成メソッド
        private function createTextField(text:String, size:int, color:int):TextField{
        		var tf:TextField = new TextField();
        		tf.defaultTextFormat = new TextFormat("", size, color, false);//テキストの設定
        		tf.text = text;
        		tf.autoSize = TextFieldAutoSize.LEFT;//テキストの最適化
        		tf.selectable = false;
        		return tf;
        }
        
        //爆弾生成メソッド
        private function createBomb():void{
        		if(cursc<=score){
        			bomnum++;
        			scoreboard.removeChild(texbm);
        			bombscore();
        			cursc =　cursc + BOMB_MAKE;
        		}
        }
        private function bombscore():void{
        		texbm = createTextField("爆弾 : "+bomnum+"個", 20, 0x0);
      		texbm.x = 342;
			texbm.y = 300;
			scoreboard.addChild(texbm); 
        }
        
        //残り時間の表示
        private function TimeCheck(event:TimerEvent):void{
        		scoreboard.removeChild(textm);
        		time--;
        		textm = createTextField("残り時間 : "+time, 20, 0x0);
        		textm.x = 306;
			textm.y = 330;
			scoreboard.addChild(textm);
			
			//ゲーム終了
			if(time == 0){
				finish = createTextField("FINISH!", 60, 0xFFFFFF);//テキストのフォーマット設定
				you = createTextField("あなたのスコア", 50, 0xFFFFFF);//テキストのフォーマット設定
				showsc = createTextField(""+score, 60, 0xFFD700);//テキストのフォーマット設定
				retry = createTextField("Ｒでリトライ", 50, 0xFFFFFF);//テキストのフォーマット設定
				dropTimer.stop();//落下タイマー停止
				moveTimer.stop();//移動タイマー停止
				stage.removeEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);//イベントリスナーの除去
				stage.removeEventListener(KeyboardEvent.KEY_UP, onKeyUp);//イベントリスナーの除去
				fullDrawing();
			
				//終了画面の表示
				kuromaku = new Sprite();
				kuromaku.graphics.beginFill(0x000000, 0.3);//黒幕の色設定
				kuromaku.graphics.drawRect(0, -50, 500, 500);//黒幕
				kuromaku.graphics.endFill();
				addChild(kuromaku);
				
				you.x = 75;
				you.y = 160;
				if(score<10){
				showsc.x = 205;
				showsc.y = 220;
				}
				else if(score>9){
				showsc.x = 195;
				showsc.y = 220;
				}
				else if(score<10){
				showsc.x = 175;
				showsc.y = 220;
				}
				finish.x = 120;//テキストのｘ位置
				finish.y = 80;//テキストのｙ位置
				retry.x = 117;
				retry.y = 300;
				kuromaku.addChild(retry);
				kuromaku.addChild(finish);//テキストの描画
				kuromaku.addChild(you);//テキストの描画
				kuromaku.addChild(showsc);//テキストの描画
				stage.addEventListener(KeyboardEvent.KEY_DOWN, RestartGame);//キーイベント（入力）の追加
			}
        }
        
        //スコアの表示
        private function ScoreCheck():void{
        		texsc = createTextField("スコア : "+score, 20, 0x0);
			texsc.x = 330;
			texsc.y = 360;
			scoreboard.addChild(texsc);
        }
        
        //揃った列の消去と新たな列の挿入
        private function fillMapBlank(event:TimerEvent):void {
        		moveTimer.start();
        		tetrominoClear();
        		count = 0;
        		for (var y:int = deleteLineIndex.length - 1; y >= 0; y--) {
        			fieldMap.splice(deleteLineIndex[y], 1);//揃った行の削除
        			fieldMapColor.splice(deleteLineIndex[y], 1);//揃った行の色の削除
        			fieldMap.splice(0, 0, MAP_BLANK.concat());//新規の行の挿入
        			fieldMapColor.splice(0, 0, MAP_BLANK.concat());//新規の行の色の挿入
        			count++;//加算
        		}
        		
        		//スコアの更新
        		score = score + (10*(count*count));//現スコア＋加算
        		createBomb();
        		if(score > 0){
				scoreboard.removeChild(texsc);
        			ScoreCheck();
			}
			
			//お邪魔テトリミノの指定
			nextIndex = 6 + count;
        		fullDrawing();
        	} // fillMapBlank() close
        	
        	//タイマーによるブロックの落下
        	private function onDropTetromino(event:TimerEvent):void { 		
        		if (getBottomHit()) {
						lockTetromino();
						nextTetromino();
						fullDrawing();
						}
						tetrominoClear();
						location.y++;
						fullDrawing();
        	} 
        	
        	//ランダムにテトリミノを決める
        	private function createTetromino():uint {
        		return Math.floor(Math.random()*7);//戻り値をランダムに決める（１～７）
        	} // createTetromino() close
		
		//次のテトリミノの生成と出現
		private function nextTetromino(first:Boolean = false):void {
			currentTetromino = new Array();//現在のテトリミノを新しく生成
			currentIndex = (first)? createTetromino(): nextIndex;//最初のテトリミノの場合、２回テトリミノを作る
			for (var y:int = 0; y < TET_HEIGHT; y++) {
				currentTetromino[y] = TETROMINOS[currentIndex][y].concat();//テトリミノの配列から現在のテトリミノにコピーする
			}
			location = new Point(5, 0);//描画ポイントの設定
			gameover = overlapCheck(currentTetromino);//ゲームオーバー判定
			if (gameover) {
				end = createTextField("GAME OVER", 60, 0xFFFFFF);//テキストのフォーマット設定
				retry = createTextField("Ｒでリトライ", 50, 0xFFFFFF);//テキストのフォーマット設定
				dropTimer.stop();
				moveTimer.stop();
				stage.removeEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);//イベントリスナーの除去
				stage.removeEventListener(KeyboardEvent.KEY_UP, onKeyUp);//イベントリスナーの除去
				fullDrawing();
				
				//ゲームオーバー画面の設定
				kuromaku = new Sprite();
				kuromaku.graphics.beginFill(0x000000, 0.3);//黒幕の色設定
				kuromaku.graphics.drawRect(0, -50, 500, 500);//黒幕
				kuromaku.graphics.endFill();
				addChild(kuromaku);
				
				
				end.x = 60;//テキストのｘ位置
				end.y = 100;//テキストのｙ位置
				retry.x = 117;
				retry.y = 200;
				kuromaku.addChild(retry);
				kuromaku.addChild(end);//テキストの描画
				stage.addEventListener(KeyboardEvent.KEY_DOWN, RestartGame);//キーイベント（入力）の追加
			}
			else {
				nextIndex = createTetromino();//次のテトリミノ
			} // nextTetromino() close
		}
		
		//キーボード非入力の判別
		private function onKeyUp(event:KeyboardEvent):void{
			switch(event.keyCode) {
				case 37://左の場合
					muki = 0;//方向デフォルト
					break;
				case 39://右の場合
					muki = 0;
					break;
				case 40://下の場合
					muki = 0;
					break;
				case 38://上の場合
					muki = 0;
					break;
				case 32:
					muki = 0;
					break;
				case 66:
					muki = 0;
					break;
			}
		}
		
		//テトリミノの移動
		private function onEnterFrame(event:TimerEvent):void {//キーが押された		
			switch(muki){
				case 37://左の場合
					if (getLeftHit())//衝突判定
						break;
					tetrominoClear();//現テトリミノの消去
					location.x--;//座標を左にずらす
					fullDrawing();//再描画
					break;
				case 39://右の場合
					if (getRightHit())
						break;
					tetrominoClear();
					location.x++;
					fullDrawing();
					break;
				case 40://下の場合
					if (getBottomHit()) {
						lockTetromino();//テトリミノの確定
						nextTetromino();//次のテトリミノの生成
						fullDrawing();
						break;
					}
					tetrominoClear();
					location.y++;
					fullDrawing();
					break;
				case 38://上の場合
					if (turnTetromino())
						break;
					fullDrawing();
					break;
				case 32:
					while(getBottomHit() == false){
						if (getBottomHit()) {
							lockTetromino();//テトリミノの確定
							nextTetromino();//次のテトリミノの生成
							fullDrawing();
						}
						tetrominoClear();
						location.y++;
						fullDrawing();
					}
					break;
				case 66:
					if(bomnum>0){
						tetrominoClear();
						bomnum--;
						nextTetromino();
						fullDrawing();
						scoreboard.removeChild(texbm);
        					bombscore();
					}
					break;
			}
		} // onKeyDown() close
		
		//キーボード入力の判別
		private function onKeyDown(event:KeyboardEvent):void {//キーが押された
			switch(event.keyCode) {
				case 37://左の場合
					muki = 37;//移動方向を左へ
					break;
				case 39://右の場合
					muki = 39;
					break;
				case 40://下の場合
					muki = 40;
					break;
				case 38://上の場合
					muki = 38;
					break;
				case 32:
					muki = 32;
					break;
				case 66:
					muki = 66;
					break;
			}
		} // onKeyDown() close
		
		//下に障害物がある場合にテトリミノを固定する
		private function lockTetromino():void {
			for (var y:int = 0; y < TET_HEIGHT; y++) {
				for (var x:int = 0; x < TET_WIDTH; x++) {
					if (currentTetromino[y][x]) {
						var mx:int = location.x + x;
						var my:int = location.y + y;
						
						fieldMap[my][mx]    =  LOCKED; // 固定を表す定数を代入
						fieldMapColor[y][x] += TET_COLORS[currentIndex];//色のマッピングも固定する
					}
				}
			}
			lineCheck();
			if (dropTimer.delay > DELAY_MIN) 
				dropTimer.delay = dropTimer.delay-5;
		} // lockTetromino() close
		
		//行が揃っているかどうかをチェックする
		private function lineCheck():void {
			deleteLineIndex = new Array();
			var end:Boolean;
			var x:int, y:int; 
			for (y = FIELD_HEIGHT - 2; y >= 0 && !end; y--) {
				var zero:Boolean = false;
				for (x = 0; x < FIELD_WIDTH && !zero; x++) {
					if (fieldMap[y][x] <= 0)
						zero = true;
				}
				//揃った行を削除する
				if (!zero) {
					fieldMap.splice(y, 1, MAP_BLANK.concat());
					fieldMapColor.splice(y, 1, MAP_BLANK.concat());
					deleteLineIndex.push(y);//削除する行の配列インデックスを保存しておく
				}
			}
			if (deleteLineIndex.length > 0){
				moveTimer.stop();
				ragTimer.start();//ラグの発生 
			}
		} // lineCheck() close
		
		//テトリミノを回転させる
		private function turnTetromino():Boolean {
			var x:int, y:int;
			var myValue:int;
			
			//回転用の一時的なテトリミノ
			var pTurn:Array = [
				[0, 0, 0, 0],
				[0, 0, 0, 0],
				[0, 0, 0, 0],
				[0, 0, 0, 0]
			];
			
			//現在のテトリミノを一時的なテトリミノにコピーする
			var tetTemp:Array = new Array();
			for (y = 0; y < TET_HEIGHT; y++)
				tetTemp[y] = currentTetromino[y].concat();
			
			//一時的なテトリミノを時計回りに90度回転させる
			for (y = 0; y < TET_HEIGHT; y++) {
				for (x = 0; x < TET_WIDTH; x++) {
					pTurn[x][TET_HEIGHT - 1 - y] = tetTemp[y][x];
				}
			}
			if (overlapCheck(pTurn))
				return true;//変更なし
			tetrominoClear();
			for (y = 0; y < TET_HEIGHT; y++) 
				currentTetromino[y] = pTurn[y].concat();
			return false;//テトリミノの変更
		} // turnTetromino() close
		
		//回転したテトリミノが障害とかぶらないかをチェック
		private function overlapCheck(pTurn:Array):Boolean {
			for (var y:int = 0; y < TET_HEIGHT; y++) {
				for (var x:int = 0; x < TET_WIDTH; x++) {
					if (pTurn[y][x]) {//テトリミノがある場合
						var mx:int = location.x + x;
						var my:int = location.y + y;         
						if (fieldMap[my][mx] && fieldMap[my][mx] != currentIndex + 1) 
							return true;//かぶっている
					}
				}
			}
			return false;//かぶっていない
		} // overlapCheck() close   
		
		//セルの隣の座標を調べます
		private function adjacentCheck(tx:int, ty:int, direct:uint):Boolean {
			var mx:int, my:int;
			
			switch(direct) {
				case Keyboard.LEFT:
				mx = location.x + tx -1; //一つ左隣を調べたい
				my = location.y + ty;
				if (fieldMap[my][mx] && (fieldMap[my][mx] != currentIndex + 1))
					return true;
				else 
					return false;
				
				case Keyboard.RIGHT:
				mx = location.x + tx +1; //一つ右隣を調べたい
				my = location.y + ty;
				if (fieldMap[my][mx] && fieldMap[my][mx] != currentIndex + 1) 
					return true;
				else 
					return false;
				
				case Keyboard.DOWN:
				mx = location.x + tx;
				my = location.y + ty + 1; //一つ下を調べたい
				if (fieldMap[my][mx] && fieldMap[my][mx] != currentIndex + 1) 
					return true;
				else 
					return false;
			}
			return true;
		} // adjacentCheck() close
		
		//テトリミノのブロックの位置を下から探す
		private function getBottomHit():Boolean {
			var result:Boolean;
			
			for (var x:int = 0; x < TET_WIDTH; x++) {//左から
				for (var y:int = TET_HEIGHT - 1; y >= 0; y--) {//下から
					if (currentTetromino[y][x]) {
						result = adjacentCheck(x, y, Keyboard.DOWN);//テトリミノがあればチェック 
						break;
					}
				}
				if (result) //結果が正ならばループを抜ける
					break;
			}
			return result;
		} // getBottomHit() close
		
		//テトリミノのブロックの位置を左から探す
		private function getLeftHit():Boolean {
			var result:Boolean;
			
			for (var y:int = 0; y < TET_HEIGHT; y++) {//上から
				for (var x:int = 0; x < TET_WIDTH; x++) {//左から
					if (currentTetromino[y][x]) {
						result = adjacentCheck(x, y, Keyboard.LEFT);//テトリミノがあればチェック          
						break;
					}
				}
				if (result) //結果が正ならばループを抜ける
					break;
			}
			return result;
		} // getLeftHit() close
		
		//テトリミノのブロックの位置を右から探す
		private function getRightHit():Boolean {
			var result:Boolean;
			
			for (var y:int = 0; y < TET_HEIGHT; y++) {//上から
				for (var x:int = TET_WIDTH - 1; x >= 0; x--) {//右から
					if (currentTetromino[y][x]) {
						result = adjacentCheck(x, y, Keyboard.RIGHT);//テトリミノがあればチェック 
						break;
					}
				}
				if (result) //結果が正ならばループを抜ける
					break;
			}
			return result;
		} // getRightHit() close
		
		//既存のテトリミノを消去
		private function tetrominoClear():void {
			for (var y:int = location.y; y < location.y + TET_HEIGHT; y++) {
				var py:int = y - location.y;
				for (var x:int = location.x; x < location.x + TET_WIDTH; x++) {
					var px:int = x - location.x;
					if (currentTetromino[py][px]) {
						fieldMap[y][x] = EMPTY;
						fieldMapColor[y][x] = EMPTY;
					}
				}
			}
		} // tetrominoClear() close
		
		//再描画
		private function fullDrawing():void {
			colorMapping();
			drawField();
		} // fullDrawing() close
		
		//ゲームフィールドを描画するためのカラーマッピングデータを作成する    
		public function colorMapping():void {
			for (var y:int = 0; y < FIELD_HEIGHT; y++) {//行の移動
				for (var x:int = 0; x < FIELD_WIDTH; x++) {//列の移動
					//壁のマッピング
					if (fieldMap[y][x] == WALL)
						fieldMapColor[y][x] = WALL_COLOR;//行列[y][x]のカラーマッピング設定
					//テトリミノのマッピング                              
					if (y >= location.y && y < location.y + TET_HEIGHT &&//行列が指定描画領域内にいる場合
					x >= location.x && x < location.x + TET_WIDTH) {
						var px:int = x - location.x;
						var py:int = y - location.y;
						
						if (currentTetromino[py][px] && fieldMap[y][x] == EMPTY) {//描画領域が空の場合
							fieldMap[y][x]      = currentTetromino[py][px];
							fieldMapColor[y][x] = TET_COLORS[currentIndex];            
						}
					}                                                    
				}
			}
		} // colorMapping() close
		
		//ゲームフィールド描画
		public function drawField():void {
			var py:Number = 0;//一番上の行を指定
			
			gameField.graphics.clear();//描画されているものを消去
			gameField.graphics.lineStyle(1, GRID_COLOR);//線の設定－lineStyle(thickness,color,alpha,pixelHinting)ここではalphaとpixelHintingが省略されています
			for (var y:int = 0; y < fieldMap.length; y++) { //設定したフィールドの長さまで繰り返す    
				var px:Number = 0;//一番左の列を指定 
				for (var x:int = 0; x < fieldMap[y].length; x++) {
					if (fieldMap[y][x] > EMPTY) {//セルの設定が空でない場合
						gameField.graphics.beginFill(fieldMapColor[y][x]);//色を塗りこむ
						gameField.graphics.drawRect(px, py, CELL_WIDTH, CELL_HEIGHT);//ブロックの描画
					}
					px += CELL_WIDTH;//列の移動
				}
				py += CELL_HEIGHT;//行の移動
			}
			gameField.graphics.endFill();//endFillが指定された時点で全ての描画が行われる
		} // drawField() close
    }
}
