/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g8gu
 */

package 
{
    import flash.display.Graphics;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
    
    /**
     * ...
     * @author rettuc
     * Shoji Ito's 7 line programming
     * 
     */
    public class Main extends MovieClip 
    {                
        private var _sp:Sprite;
        private var _gr:Graphics;
        private var _ang:Number;    // 右上の線の基準角度
        private var _sw:Number;        // stageWidth
        private var _sh:Number;        // stageHeight
        
        private var line1_leng:Number;
        private var line1_min_leng:Number;
        private var line2_leng:Number;
        private var line2_min_leng:Number;
        
        private var _ball:Ball;
        private var _flg:Boolean = false;
        
        private var X:Number;
        private var Y:Number;        
        
        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init );
        }
        
        private function init(e:Event = null ):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init );
            setStage();
            
            drawingINIT();
            ballSet();
            
            stage.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void{
                _flg = !_flg;
            });
            
            loaderInfo.addEventListener(Event.UNLOAD, function(e:Event):void {
                stage.removeEventListener(Event.RESIZE, resizeEvent);
                stage.removeEventListener(MouseEvent.CLICK, function(e:MouseEvent):void{
                    _flg = !_flg;
                });
                loaderInfo.removeEventListener(Event.UNLOAD, arguments.callee );
            });
        }
                
        private function drawingINIT():void
        {
            _sp = new Sprite();
            _gr = _sp.graphics;
            addChild(_sp);
            addEventListener(Event.ENTER_FRAME, enterframeHandler);            
        }
        
        private function enterframeHandler(e:Event):void
        {
            _gr.clear();
            _gr.lineStyle(3,0xFF0000);
            
            if(_flg){
                X = mouseX;
                Y = mouseY;
            }else{
                X = _ball.x;
                Y = _ball.y;                
            }
            _ang = Math.atan2( Y, -( _sw - X));
            
            line1();
            line2();
            line3();
            line4();
            line5();
            line6();
            line7();
        }
        
        // 1.カーソルと右上の角を結ぶ
        private function line1():void
        {
            _gr.moveTo(_sw, 0);
            _gr.lineTo(X, Y);            
        }
        
        // 2.左上の角から1へ垂直に引く
        private function line2():void
        {            
            //    trace(_ang-Math.PI/2);    // -90 * PI/180
            var length:Number = _sw*Math.cos(_ang-Math.PI/2);
            var px:Number = Math.cos(_ang-Math.PI/2)*length;
            var py:Number = Math.sin(_ang-Math.PI/2)*length;            
            line2_leng = MathUtil.dist(new Point(0,0), new Point(px, py));
            
            _gr.moveTo(px, py);
            _gr.lineTo(0, 0);
        }

        // 3.左下の角から2へ垂直に引く
        private function line3():void
        {
            //    trace(_ang-Math.PI);    // -180 * PI/180
            var length:Number = _sh*Math.cos(_ang-Math.PI/2);
            var px:Number = Math.cos(_ang-Math.PI)*length;
            var py:Number = Math.sin(_ang-Math.PI)*length + _sh;
            line2_min_leng = MathUtil.dist(new Point(0,0), new Point(px, py));            
            
            _gr.moveTo(px, py);
            _gr.lineTo(0, _sh);
        }

        // 4.右下の角から1へ垂直に引く
        private function line4():void
        {            
            //    trace(_ang+Math.PI/2);    // +90 * PI/180
            var length:Number = _sh*Math.sin(_ang-Math.PI/2);
            var px:Number = Math.cos(_ang+Math.PI/2)*length + _sw;
            var py:Number = Math.sin(_ang+Math.PI/2)*length + _sh;
            line1_leng = MathUtil.dist(new Point(_sw,0), new Point(X, Y));            
            line1_min_leng = MathUtil.dist(new Point(_sw,0), new Point(px, py));            
            
            _gr.moveTo(px, py);
            _gr.lineTo(_sw, _sh);
        }
        
        // 5.1の中点から3へ垂直に引く
        private function line5():void
        {
            // 1の中点
            var px:Number = (_sw + X)/2;
            var py:Number = Y/2;
            
            var length:Number = line2_leng-line2_min_leng;
            var px2:Number = Math.cos(_ang+Math.PI/2)*length + px;
            var py2:Number = Math.sin(_ang+Math.PI/2)*length + py;            
            
            _gr.moveTo(px, py);
            _gr.lineTo(px2, py2);
        }

        // 6.カーソルから3へ垂直に引く
        private function line6():void
        {            
            var length:Number = line2_leng-line2_min_leng;
            var px:Number = Math.cos(_ang+Math.PI/2)*length + X;
            var py:Number = Math.sin(_ang+Math.PI/2)*length + Y;            
            
            _gr.moveTo(X, Y);
            _gr.lineTo(px, py);
        }

        // 7.6の中点から4へ垂直に引く
        private function line7():void
        {            
            var length:Number = line2_leng-line2_min_leng;
            var px:Number = Math.cos(_ang+Math.PI/2)*length/2 + X;
            var py:Number = Math.sin(_ang+Math.PI/2)*length/2 + Y;            
            
            var length2:Number = line1_leng-line1_min_leng;
            var px2:Number = Math.cos(_ang+Math.PI)*length2 + px;
            var py2:Number = Math.sin(_ang+Math.PI)*length2 + py;            
            
            _gr.moveTo(px, py);
            _gr.lineTo(px2, py2);
        }

        
        
        /********* ball用 ************/
        
        private function ballSet():void
        {
            _ball = new Ball(6);
            _ball.graphics.beginFill(0xFFFFFF);
            _ball.graphics.drawCircle(0,0,3);
            _ball.x = stage.stageWidth/2;
            _ball.y = stage.stageHeight/2;
            _ball._vx = Math.random() * 5-2.5;
            _ball._vy = Math.random() * 5-2.5;
            addChild(_ball);
            addEventListener(Event.ENTER_FRAME, ball_enterframeHandler);            
        }
        
        private function ball_enterframeHandler(e:Event):void
        {
            var b:Ball = _ball;
            b.x += b._vx;
            b.y += b._vy;
            
            if(b.x+b.width/2 > _sw){
                b.x = _sw-b.width/2;                    
                b._vx *= -1;                    
            }else if( b.x-b.width/2 <= 0 ){
                b.x = b.width/2;                    
                b._vx *= -1;                    
            }
            
            if( b.y+b.height/2 > _sh ){
                b.y = _sh-b.height/2;                    
                b._vy *= -1;                    
            }else if( b.y-b.height/2 <= 0){
                b.y = b.height/2;                    
                b._vy *= -1;                    
            }
            
        }
        
        
        /********* stage set ************/
        
        private function setStage():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, resizeEvent);
            resizeHandler();
        }
        private function resizeEvent(e:Event = null):void {
            resizeHandler();
        }        
        public function resizeHandler():void {
            _sw = stage.stageWidth;
            _sh = stage.stageHeight;
        }
        
    }
}

import flash.display.Sprite;

class Ball extends Sprite
{
    public var _radius:Number;
    private var _color:Number;
    public var _vx:Number = 0;
    public var _vy:Number = 0;
    public var _mass:Number = 1;
    
    public function Ball(radius:Number = 40, color:Number = 0xFF0000)
    {
        _radius = radius;
        _color = color;
        initBall();
    }
    
    public function initBall():void
    {
        graphics.beginFill(_color);
        graphics.drawCircle(0,0,_radius);
        graphics.endFill();
    }
}

class MathUtil
{    
    static public function dist(a:Object, b:Object):Number
    {
        var dx:Number = b.x - a.x;
        var dy:Number = b.y - a.y;
        return Math.sqrt(dx * dx + dy * dy);
    }
}

