/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g8Y6
 */

// forked from nicoptere's sketch
package 
{
    /**
     * click to whow original / filtered
     * source image taken here:
     * http://ffffound.com/image/0ee8a947386ce9df8a81d41143069db8cd37b82e
     * 
     * @author Nicolas Barradeau
     * http://en.nicoptere.net
     */
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.MouseEvent;
    import flash.events.ProgressEvent;
    import flash.events.SecurityErrorEvent;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.ConvolutionFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.ApplicationDomain;
    import flash.system.LoaderContext;
    import flash.system.SecurityDomain;
    public class Sketch extends Sprite
    {
        
        private var src:BitmapData;
        private var bd:BitmapData;
        private var flip:int = 0;
        private var loader:Loader;
        private var bmp:Bitmap;
        public function Sketch() 
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadComplete);
            loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, onLoadProgress);
            loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onLoadError);
            loader.contentLoaderInfo.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onLoadError);
    
            var context:LoaderContext = new LoaderContext( false );
            context.applicationDomain = ApplicationDomain.currentDomain;
            context.securityDomain = SecurityDomain.currentDomain;
          //loader.load(new URLRequest("http://a3.sphotos.ak.fbcdn.net/hphotos-ak-snc6/60570_818075068931_9021630_46600035_4192844_n.jpg"), context);
          //loader.load(new URLRequest("http://a3.sphotos.ak.fbcdn.net/hphotos-ak-snc6/60570_818075068931_9021630_46600035_4192844_n.jpg"), context);
          loader.load(new URLRequest("http://a4.sphotos.ak.fbcdn.net/hphotos-ak-ash4/261542_10100144899432261_9021630_49460315_2169855_n.jpg"), context);
          //loader.load(new URLRequest("http://hphotos-sjc1.fbcdn.net/hphotos-snc6/192834_10100248305740191_9021630_50162854_3700125_o.jpg"), context);
        }  
        
        private function onLoadProgress(e:ProgressEvent):void 
        {
            
            graphics.clear();
            graphics.beginFill( 0xFF0000 );
            graphics.drawCircle( stage.stageWidth / 2 , stage.stageHeight / 2, e.bytesLoaded / e.bytesTotal * 100 );
            
        }
        
        private function onLoadError(e:Event):void {
            trace( "error ", e );
        }
        
        private function onLoadComplete(e:Event):void 
        {
            
            graphics.clear();
            
            src = Bitmap( loader.content ).bitmapData;
            bd = src.clone();
            
            var container:Sprite = Sprite( addChild( new Sprite() ) );
            bmp = Bitmap( container.addChild( new Bitmap( bd ) ) );
            container.x = stage.stageWidth / 2 - container.width / 2 ;
            container.y = stage.stageHeight / 2 - container.height / 2 ;
            container.buttonMode = true;
            container.addEventListener( MouseEvent.MOUSE_DOWN, swap );
            sketch( src, bd );
            
        }
        
        private function swap(e:MouseEvent):void 
        {
            
            if ( ( ++flip & 1 ) ) bd.draw( src );
            else sketch( src, bd );
            
        }
        
        private function sketch( src:BitmapData, bd:BitmapData ):void 
        {
            var p:Point = new Point;
            bd.draw( src );
            
            // desaturation + brightness + contrast 
            bd.applyFilter( bd, bd.rect, p, grayscale );
            bd.applyFilter( bd, bd.rect, p, brightness( 35 ) );
            bd.applyFilter( bd, bd.rect, p, contrast( 45 ) );
            
            //bloom
            ///*
            var bloom:BitmapData = src.clone();
            bloom.applyFilter( bloom, bloom.rect, p, new BlurFilter( 10, 10, 3 ) );
            bloom.applyFilter( bloom, bloom.rect, p, grayscale );
            
                //draws the bloom
                bd.draw( bloom, null, new ColorTransform( 1, 1, 1, .999 ), BlendMode.SCREEN );
            //*/
            
            //creates the outlines
            var outlines:BitmapData = src.clone();
            outlines.applyFilter( outlines, outlines.rect, p, outline( 120 ) );
            outlines.applyFilter( outlines, outlines.rect, p, negative );
            outlines.applyFilter( outlines, outlines.rect, p, grayscale );
            //outlines.threshold( outlines, outlines.rect, p, '<=', 0xFF707070, 0xFF000000 );
            
                //draws the outlines into the bd
                bd.draw( outlines, null, new ColorTransform( 1, 1, 1, .999 ), BlendMode.MULTIPLY );
            
            //creates some additionnal noise
            var noise:BitmapData = bd.clone();
            noise.noise( 0, 0, 0x80, 7, true);
                
                //draws the extra noise
                bd.draw( noise, null, new ColorTransform( 1, 1, 1, 0.2 ), BlendMode.ADD );
            
            //final contrast pass
            bd.applyFilter( bd, bd.rect, p, contrast( 55 ) );
            
        }
        
        private function outline( value:Number = 80 ):ConvolutionFilter
        {
            var q:Number = value / 4;
            return new ConvolutionFilter(    3,     3,     [
                                                    0    ,      q    ,     0    , 
                                                    q    ,     -value    ,     q    , 
                                                    0    ,     q    ,     0    
                                                    ],     10 );
        }
        
        private function get negative():ColorMatrixFilter
        {
            return new ColorMatrixFilter(     [
                                                -1    ,    0    ,    0    ,    0    ,    0xFF,
                                                0    ,    -1    ,    0    ,    0    ,    0xFF,
                                                0    ,    0    ,    -1    ,    0    ,    0xFF,
                                                0    ,    0    ,    0    ,    1    ,    0
                                            ]    );
        }
        
        private function get grayscale():ColorMatrixFilter
        {
            return new ColorMatrixFilter(     [
                                                .3086    ,    .6094    ,    .0820    ,    0    ,    0,
                                                .3086    ,    .6094    ,    .0820    ,    0    ,    0,
                                                .3086    ,    .6094    ,    .0820    ,    0    ,    0,
                                                    0    ,    0    ,    0    ,    1    ,    0
                                            ]    );
        }
        
        private function brightness( value:Number ):ColorMatrixFilter
        {
            return new ColorMatrixFilter(     [
                                                1    ,    0    ,    0    ,    0    ,    value,
                                                0    ,    1    ,    0    ,    0    ,    value,
                                                0    ,    0    ,    1    ,    0    ,    value,
                                                0    ,    0    ,    0    ,    1    ,    0
                                            ]    );
        }
        
        private function contrast( value:Number ):ColorMatrixFilter
        {
            var a:Number = ( value * 0.01 + 1 )
            var b:Number = 0x80 * ( 1 - a );
            return new ColorMatrixFilter(     [
                                                a    ,    0    ,    0    ,    0    ,    b,
                                                0    ,    a    ,    0    ,    0    ,    b,
                                                0    ,    0    ,    a    ,    0    ,    b,
                                                0    ,    0    ,    0    ,    1    ,    0
                                            ] );
        }    
    }
}