/**
 * Copyright marcsali ( http://wonderfl.net/user/marcsali )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g8Wi
 */

// forked from sasikumar's flash on 2012-3-29
package
{
    import Box2D.Collision.b2AABB;  
    import Box2D.Collision.Shapes.b2PolygonShape;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2Fixture;
    import Box2D.Dynamics.b2FixtureDef;
    import Box2D.Dynamics.b2World;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.events.Event;
    /**
     * ...
     * @author Chris Moeller
     */
    public class  Main extends Sprite
    {
      //  public var stage:Stage;
  
        public function Main() 
        { 
        
        var world:b2World; 
        var gravity:b2Vec2=new b2Vec2(0, 9.81); //gravity direction, positive is down in screen coordinates
        var  scale:Number = 30; //the scale the Box2d world will be compared to screen size
 
     //   public var world:b2World; //create the "physics world"
 
         var hero_box:b2Body; //the object we'll use to control our "hero"/ main character
   
         
 
            var sleep:Boolean= true;  
            var worldAABB:b2AABB= new b2AABB(); 
            worldAABB.lowerBound.Set(-100, -100);
            worldAABB.upperBound.Set(-100, -100);     
            
         //   this.stage = stage; //assign the main "stage" to a variable in "Game.as" so it has access to it, and can add any objects to the screen it needs to
            world = new b2World(worldAABB, gravity, sleep); //initialize the world; first parameter a 2d vector to represent the direction+magnitude of gravity (straight down and at 9.8m/s^2
 
            //add the "debug drawings" to the screen:
            var debug_sprite:Sprite = new Sprite(); //our debug sprite, where all of the physical objects can be drawn upon before we add graphics
            stage.addChild(debug_sprite);
 
            var debug_draw:b2DebugDraw = new b2DebugDraw();
   //         debug_draw.SetSprite(debug_sprite);
   //         debug_draw.SetDrawScale(scale);
            debug_draw.SetFlags(b2DebugDraw.e_shapeBit);
            world.SetDebugDraw(debug_draw);
 
            //create a static/unmoving box along the bottom to use as the ground
            CreateBox(0, stage.stageHeight - 50, stage.stageWidth, 50, false);
 
            //create your "hero" box to be used as your character later on
            hero_box = CreateBox(200, 100, 50, 50, true, 1);
 
            //create a couple "blocks" on the screen
            CreateBox(200, stage.stageHeight - 50 * 4, 50, 50, false);
            CreateBox(350, stage.stageHeight - 50 * 4, 50, 50, false);
            CreateBox(400, stage.stageHeight - 50*4, 50, 50, false);
 
            stage.addEventListener(Event.ENTER_FRAME, RunGame); //main game loop which will perform calculation simulations each frame, and game processes
        }
        /*
        function used to create boxes quickly, without having to do all the box2d initializations each time
        */
       function CreateBox(x:Number, y:Number, width:Number, height:Number, is_dynamic:Boolean, density:Number=1):b2Body
        {
            //first tranfer all the pixel units into box2d units
            x = Con2B2D(x);
            y = Con2B2D(y);
            width = Con2B2D(width);
            height = Con2B2D(height);
 
            var box_body:b2BodyDef = new b2BodyDef();
            box_body.position.Set(x+width/2, y+height/2); //NOTE: box2d sets the position of the center of an object, not the top left like normal. So we have to add the middle (width/2, height/2) to the position to position where we actually want to have it
 
     
          box_body.type = b2Body.b2_dynamicBody;
 
           var box_poly_shape:b2PolygonShape = new b2PolygonShape();
          box_poly_shape.SetAsBox(width / 2, height / 2);
          var box_fixture:b2FixtureDef = new b2FixtureDef();
           box_fixture.shape = box_poly_shape;
           box_fixture.density = density;
           var world_box_body:b2Body = world.CreateBody(box_body);
          world_box_body.CreateFixture(box_fixture);
 
    return world_box_body;
       // }
        }
        /*
            Main Loop: Used to run the physics simulation each frame, as well as any game processes
        */
        function RunGame(e:Event):void
        {
            world.Step(1/30,10,10); //performs a time step in the box2d simulation
            world.ClearForces(); //used to clear the forces after performing the time step
            world.DrawDebugData(); //draw the updated debug draw/graphics before adding out graphics
 
            //lets set the hero box to moving forward, as running along the ground
            if(hero_box.GetLinearVelocity().x< Con2B2D(60))
                hero_box.ApplyImpulse(new b2Vec2(Con2B2D(40), 0), hero_box.GetWorldCenter());
 
            //if the hero is below the bottom of the screen, bring him back to the original positon
            if (ConFromB2D(hero_box.GetPosition().y) > stage.stageHeight)
                hero_box.SetPosition(new b2Vec2(Con2B2D(200), Con2B2D(100)));
        }
        /*
        Helper function - used to convert normal pixel coordinates into Box2d coodinates (which are set at 1/scale or 1/30 right now)
        */
        function Con2B2D(num:Number):Number
        {
            return num / scale;
        }
        /*
        Helper function - used to convert box2d coordinates into pixels
        */
        function ConFromB2D(num:Number):Number
        {
            return num * scale;
        }
    
    }
}