/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g8UJ
 */

// forked from tjoen's OMG it's full of stars
// other filter used
package  {
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageDisplayState;
    import flash.events.ContextMenuEvent;
    import flash.events.Event;
    import flash.ui.ContextMenu;
    import flash.ui.ContextMenuItem;
    import flash.filters.*;
    import net.badimon.five3D.utils.DrawingUtils;        
    import net.badimon.five3D.display.Scene3D;
    import net.badimon.five3D.display.Sprite3D;        

[SWF(width=465, height=465, backgroundColor=0x000000, frameRate=60)]

    public class Five3D extends Sprite {
        
        private var scene3D:Scene3D;
        private var container3D:Sprite3D;
        
        public function Five3D():void
        {            
            scene3D = new Scene3D();
            scene3D.x = stage.stageWidth/2;
            scene3D.y = stage.stageHeight/2;
            addChild( scene3D );
            
            container3D = new Sprite3D;
            container3D.rotationX = 180;
            container3D.z = 1500;
            scene3D.addChild( container3D );    
            container3D.addEventListener( Event.ENTER_FRAME, makePlanes);        
            
            // Custom right-click
            var myMenu:ContextMenu = new ContextMenu();
                myMenu.hideBuiltInItems();
            var menuItem1:ContextMenuItem = new ContextMenuItem("Toggle Fullscreen");
                myMenu.customItems.push(menuItem1);
                menuItem1.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, toggleFullscreen);
                this.contextMenu = myMenu;
            
        }
        
        private function makePlanes(event:Event):void
        {
            var container:Sprite3D = event.target as Sprite3D;
            for(var i:Number=0; i<2; i++)
            {
    var plane:Sprite3D = new Sprite3D();
    DrawingUtils.star(plane.graphics3D, 4 + Math.floor(Math.random() * 5), Math.random()*150-50, Math.floor(Math.random() * 50), 0, Math.random()*0xffffff);

            var myBevel:BevelFilter = new BevelFilter();
            myBevel.type = BitmapFilterType.FULL;
            myBevel.distance = 2;
            myBevel.highlightColor = Math.random()*0xffffff;
            myBevel.shadowColor = Math.random()*0xffffff;
            myBevel.blurX = 2;
            myBevel.blurY = 2;
            plane.filters=[myBevel];
            
                plane.y = 1000;
                plane.x = randRange(-900, 900);
                plane.z = randRange(-1500, 1500);
                plane.addEventListener( Event.ENTER_FRAME, fly3d );
                container.addChild(plane);
                //container.rotationZ++;
            }
            container3D.rotationZ+=0.5;//0.5        
            container3D.rotationY-=0.4;//0.4
            container3D.rotationX-=0.5;//0.5
        }
        
        private function fly3d(event:Event):void
        {
            var plane:Sprite3D = event.target as Sprite3D;
            plane.y -= 40; //80
            
            if(plane.y < -1100){
                plane.removeEventListener( Event.ENTER_FRAME, fly3d );
                container3D.removeChild(plane);
                plane = null;
            }
        }
        
        private function toggleFullscreen( event:ContextMenuEvent ):void
        {
            if(stage.displayState == StageDisplayState.NORMAL) {
                stage.displayState = StageDisplayState.FULL_SCREEN;
            } else {
                stage.displayState = StageDisplayState.NORMAL;
            }
            
        }

        private function randRange(min:Number, max:Number):Number 
        {
            var randomNum:Number = Math.floor(Math.random() * (max - min + 1)) + min;
            return randomNum;
        }
    }
}