/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g8LN
 */

package {
  import com.actionscriptbible.Example;
  import flash.utils.Timer;
  import flash.events.TimerEvent;
  
  public class ch22ex4 extends Example {
    public static const TIMER_DELAY:Number = 0.5 * 1000;
    public var timer:Timer;
    
    public function ch22ex4() {
      timer = new Timer(TIMER_DELAY, 10);
      timer.addEventListener(TimerEvent.TIMER, onTimer);
      timer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);
      timer.start();
    }
    
    protected function onTimer(event:TimerEvent):void {
      var timer:Timer = Timer(event.target);
      var timeElapsed:Number = timer.currentCount * timer.delay;
      var remainingCount:Number = timer.repeatCount - timer.currentCount;
      trace("Time elapsed :", timeElapsed / 1000, "seconds.");
      if (remainingCount > 0) {
        trace("There are", remainingCount, "ticks remaining.");
      }
    }    

    protected function onTimerComplete(event:TimerEvent):void {
      trace("Ding!");
    }
  }
}
