/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g7y3
 */

// forked from ile's WaterDropMaker
/* 
shape で WaterDrop を作ってみました。 
*/
package  {
    
import flash.display.Sprite;
    public class Suiteki extends Sprite {
        
        public function Suiteki() {
            //backgroundColor
            graphics.beginFill(Math.random() * 0x1000000);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            graphics.beginFill (Math.random() * 0x1000000, 1.0);
            graphics.drawCircle  ( 270, 100 , 150);
            graphics.endFill();
            
            //parameter=Dropsize
            var test:WaterDropMaker = new WaterDropMaker(50);
            addChild(test);
            test.x = 100;
            test.y = 100;
            test.rotation = -45;
        }
    }
}

import flash.display.Sprite;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.Graphics;
import flash.geom.Matrix;
import flash.display.BlendMode;

class WaterDropMaker extends Sprite {
    private var dropSize:uint;

    public function WaterDropMaker(n:uint):void {
        dropSize = n;
        var shadowColor:uint = 0x000000;
        var lightColor:uint = 0xFFFFFF;
        
        var container:Sprite = addChild(new Sprite()) as Sprite;
        //container.x = container.y = dropSize;
     
        var shape:Sprite = container.addChild(new Sprite()) as Sprite;
        var g:Graphics = shape.graphics;
        var matrix:Matrix = new Matrix();
        
        //long shadow
        shape =  container.addChild(new Sprite()) as Sprite;
        g = shape.graphics;
        //createGradientBox(w,h,r,X,Y)
        matrix.createGradientBox(dropSize * 2, dropSize * 4, 0, -dropSize, -dropSize*2);
        g.beginGradientFill(GradientType.RADIAL, [shadowColor, shadowColor, shadowColor], [0.0,0.1,0], [0,200,255], matrix, SpreadMethod.PAD);
        g.moveTo(-dropSize, 0);
        g.curveTo ( -dropSize , dropSize * 2, 0 , dropSize * 2 );
        g.curveTo ( dropSize , dropSize*2, dropSize , 0 );
        g.curveTo ( dropSize*0.88 , dropSize*0.88, 0 , dropSize );
        g.curveTo ( -dropSize*0.88 , dropSize*0.88, -dropSize , 0 );
        g.endFill();
        
        //around OUTSIDE shadow
        shape =  container.addChild(new Sprite()) as Sprite;
        g = shape.graphics;
        matrix.createGradientBox(dropSize * 2.6, dropSize * 2.6+dropSize/5, 0, -dropSize*1.3, -dropSize*1.3);
        g.beginGradientFill(GradientType.RADIAL, [shadowColor,shadowColor, shadowColor], [0.02,0.05,0], [0,200,255], matrix, SpreadMethod.PAD);
        g.drawCircle(0, dropSize/5, dropSize*1.5);
        g.endFill();

        //base color
        shape =  container.addChild(new Sprite()) as Sprite;
        g = shape.graphics;
        g.beginFill (0x888888, 0.15);
        g.drawCircle  ( 0, 0 , dropSize);
        g.endFill();
        shape.blendMode = BlendMode.LIGHTEN;

        //around INSIDE shadow
        shape =  container.addChild(new Sprite()) as Sprite;
        g = shape.graphics;
        matrix.createGradientBox(dropSize * 3.5, dropSize * 3.7, 0, -dropSize * 1.8, -dropSize * 1.0);
        g.beginGradientFill(GradientType.RADIAL, [shadowColor,shadowColor, shadowColor], [0,0.05,0.07], [0,200,255], matrix, SpreadMethod.PAD);
        g.drawCircle  ( 0, 0 , dropSize);
        g.endFill();
        
        //under　shadow
        shape =  container.addChild(new Sprite()) as Sprite;
        g = shape.graphics;
        matrix.createGradientBox(dropSize * 5, dropSize * 5, 0, -dropSize*2.5, -dropSize*3);
        g.beginGradientFill(GradientType.RADIAL, [shadowColor,shadowColor,shadowColor,shadowColor], [0,0, 0.3,1], [0,95,222,255], matrix, SpreadMethod.PAD);
        g.drawCircle(0, 0, dropSize);
        g.endFill();
        
        //base gradation
        shape =  container.addChild(new Sprite()) as Sprite;
        g = shape.graphics;
        matrix.createGradientBox(dropSize * 3.5, dropSize * 3.7, 0, -dropSize*1.8, -dropSize*1.0);
        g.beginGradientFill(GradientType.RADIAL, [lightColor,lightColor, lightColor,lightColor,lightColor,lightColor], [0.8,0.5, 0.1,0,0,0.3], [0,70, 181,216,245,255], matrix, SpreadMethod.PAD);
        g.drawCircle(0, 0, dropSize);
        g.endFill();
        shape.blendMode = BlendMode.OVERLAY;
        
        //highlight
        shape =  container.addChild(new Sprite()) as Sprite;
        g = shape.graphics;
        matrix.createGradientBox(dropSize/2, dropSize/2, 0, -dropSize/4, -dropSize*0.9);
        g.beginGradientFill(GradientType.RADIAL, [lightColor,lightColor,lightColor], [0.8,0.1 ,0], [0,85,255], matrix, SpreadMethod.PAD);
        g.drawCircle(0, 0, dropSize);
        g.endFill();
        
    }
}