/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g7w6
 */

/*
DoCoMoの製品ページ
http://www.nttdocomo.co.jp/product/
にiPhoneとかのジャケ写を回転するインターフェイスを
くっつけたかんじ。

連打禁止！
*/

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    import flash.display.DisplayObjectContainer;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    public class Main extends Sprite {
        
        private var _view:View
        public function Main() {
            stage.transform.perspectiveProjection = new PerspectiveProjection();
            stage.transform.perspectiveProjection.projectionCenter = new Point(stage.stageWidth / 2, stage.stageHeight / 2);
            
            setView();
            this.addEventListener(MouseEvent.CLICK, onClick);
        }
        public function setView():void{
            _view = new View();
            _view.x = 465/2;
            _view.y = 465/2;
            addChild(_view);
        }
        private function onClick(event:MouseEvent):void {
            _view.setFront(event.target as DisplayObjectContainer);
            
        }
    }
}


import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import flash.geom.Matrix;
import flash.utils.Dictionary;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.easing.*;

class View extends Sprite{
    private var _canvas:Sprite;
    private var _rotation:Number = 0;
    public var sprites:Array;
    private var _pozDictionary:Dictionary;
    private var _value:int;
    private var _t:ITween;
    public function View(){
        _canvas = new Sprite();
        sprites = [];
        _pozDictionary = new Dictionary();
        for (var i:int = 0; i < 6; i++) {
            sprites[i] = new Pad(i);
            _pozDictionary[sprites[i]] = i;
            _canvas.addChild(sprites[i]);
        }
        rotation = 0;
        this.z = -350;
        this.addChild(_canvas);
    }
    public function setFront(target:DisplayObjectContainer):void {
        var n:int = sprites.length;
        for (var i:int = 0; i < n; i++) {
            sprites[i].selected = _pozDictionary[target];
        }
        
        if (_value == _pozDictionary[target]) {return};
        var degree:Number = rotation;
        degree += (_pozDictionary[target] == (_value+1)%6)?60:-60;
        _value = _pozDictionary[target];
        
        if (_t != null) {
            _t.stop();
        }
        _t = BetweenAS3.serial(
            BetweenAS3.tween(this, { z: 0 }, null, 0.5,Expo.easeIn),
            BetweenAS3.tween(this, { rotation: degree }, null, 0.3),
            BetweenAS3.tween(this, { z: -350 }, null, 0.5,Expo.easeIn)
        );
        _t.play();
    }
    
    override public function set rotation(value:Number):void{
        _rotation = value;
        var n:int = sprites.length;
        for (var i:int = 0; i < n; i++) {
            sprites[i].x = Math.cos(Math.PI*(i/3+(90-value)/180))*300;
            sprites[i].z = Math.sin(Math.PI*(i/3+(90-value)/180))*300;
            sprites[i].rotationY = -360*i/6+value;
        }
        zSort(_canvas);
    }
    override public function get rotation():Number{return _rotation};
    
    private function zSort(target:DisplayObjectContainer):void {
        var n:int = target.numChildren;
        var array:Array = [];
        var reference:Array = [];
        for (var i:int = 0; i < n; i++) {
            array[i] = target.getChildAt(i).z;
            reference[i] = target.getChildAt(i);
        }
        var temp:Array = array.sort(Array.NUMERIC | Array.RETURNINDEXEDARRAY);
        for (i = 0; i < n; i++) {
            target.setChildIndex(reference[temp[i]], 0);
            reference[temp[i]].visible = (reference[temp[i]].z > 0);
        }
    }
}

import flash.geom.Matrix3D;
import flash.text.TextField;
import flash.text.TextFormat;
class Pad extends Sprite{
    public var id:int;
    private var _selectedId:int;
    private var _t:ITween;
    private var _isFront:Boolean;
    private var _ura:Sprite;
    public function Pad(id:int){
        var colors:Array = [0xFF0000, 0x00FF00, 0x0000FF, 0xFFFF00, 0x00FFFF, 0xFF00FF];
        this.graphics.lineStyle(3,0xFFFFFF);
        this.graphics.beginGradientFill("linear",[colors[id],0x000000],[1,1],[0x00,0xFF],new Matrix(0.7,0,-1,0.7));
        this.graphics.drawRect(-160,-160,320,320);
        this.graphics.endFill();
        this.visible = false;
        this.id = id;
        
        _ura = new Sprite();
        _ura.graphics.lineStyle(3,0x000000);
        _ura.graphics.beginGradientFill("linear",[colors[id],0x000000],[1,1],[0x00,0xFF],new Matrix(0.7,0,-1,0.7));
        _ura.graphics.drawRect(-60,-60,120,120);
        _ura.graphics.endFill();
        _ura.visible = false;
        _ura.rotationY = 180;
        var tf:TextField = new TextField();
        tf.defaultTextFormat = new TextFormat("_sans",48,0xFFFFFF);
        tf.text = String(id);
        tf.autoSize = "left";
        tf.x = -tf.width/2;
        tf.y = -tf.height/2;
        _ura.addChild(tf);
        this.mouseChildren = false;
        this.addChild(_ura);
    }
    override public function set rotationY(value:Number):void{
        value = ((value+180)%360-180)%360;
        if(Math.abs(this.id-_selectedId)<=1 || Math.abs(this.id-_selectedId) == 5){
            _isFront = Math.cos(value*Math.PI/180)>0;
            if(Math.cos(this.rotationY*Math.PI/180)>0!= _isFront){
                if(_t != null){
                    var colors:Array = [0xFF0000, 0x00FF00, 0x0000FF, 0xFFFF00, 0x00FFFF, 0xFF00FF];
                    if(_isFront){
                        _ura.visible = false;
                        this.graphics.clear();
                        this.graphics.lineStyle(3,0xFFFFFF);
                        this.graphics.beginGradientFill("linear",[colors[id],0x000000],[1,1],[0x00,0xFF],new Matrix(0.7,0,-1,0.7));
                        this.graphics.drawRect(-160,-160,320,320);
                        this.graphics.endFill();
                    }else{
                        _ura.visible = true;
                        this.graphics.clear();
                        this.graphics.lineStyle(3,0xFFFFFF);
                        this.graphics.beginGradientFill("linear",[0xFFFFFF,colors[id]],[1,1],[0x00,0xFF],new Matrix(0.7,0,-1,0.7));
                        this.graphics.drawRect(-160,-160,320,320);
                        this.graphics.endFill();
                    }
                }
            }else{
            }
        }
        
        super.rotationY = value;
    };
    public function set selected(value:int):void{
        if (_selectedId == value) {
            if(value == this.id){
                select();
            }
            return;
        };
        if(this.id == value){
            atSceneInit();
        }else if(Math.abs(this.id-value) == 1 || Math.abs(this.id-value) == 5){
            if(this.id == _selectedId){
                atSceneGoto();
            }
        }
        _selectedId = value;
    }
    private function select():void{
        var degree:Number = (root.stage.mouseX>465/2)?-180:180;
        if (_t != null) {
            _t.stop();
        }
        _t = BetweenAS3.serial(
            BetweenAS3.tween(this, { $rotationY: degree }, null, 0.5,Expo.easeIn)
        );
        _t.play();
    }
    private function atSceneInit():void{
        //trace("init");
    }
    private function atSceneGoto():void{
        if (_t != null) {
            _t.stop();
        }
        _t = BetweenAS3.serial(
            BetweenAS3.tween(this, { rotationY: 0 }, null, 0.5,Expo.easeIn)
        );
        _t.play();
    }
    
}
