/**
 * Copyright ushisantoasobu ( http://wonderfl.net/user/ushisantoasobu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g7v8
 */

package {
    import flash.display.Sprite;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.FilterShortcuts;
    import flash.events.MouseEvent;
    
    [SWF(width=465, height=465, framerate=30, backgroundColor="0xffffff")]    
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            var ball:Sprite = new Sprite();
            
            ball.x = 100;
            ball.y = 100;
            
            ball.graphics.beginFill(0x000000);
            ball.graphics.drawCircle(0,0,40);
            ball.graphics.endFill();
            
            addChild(ball);
            
            FilterShortcuts.init();
            
            ball.addEventListener(MouseEvent.CLICK, ballClickHandler);
            ball.buttonMode = true;
            
            Tweener.addTween(ball,{
                x:300,
                time:2,
                transition:"easeInOutSine",
                onComplete: tweenCompleteHandler, 
                onCompleteParams:[ball]
                });
            
        }
        
        private function tweenCompleteHandler(ball:Sprite):void{
        
            Tweener.addTween(ball,{
                x:100,
                time:2,
                transition:"easeInOutSine"
                });
        
            }                
        
        private function ballClickHandler(e:MouseEvent):void{
            Tweener.removeTweens(e.target);
        }
        
    }
}
        

    