/**
 * Copyright Fumio ( http://wonderfl.net/user/Fumio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g6Ql
 */

// forked from Fumio's push() and shift() operation of Vector and Linked List
package {
	import flash.display.Sprite;
	import flash.utils.getTimer;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	[SWF(width = "240",height = "180")]
	public class VectorAndLinkedListIteration extends Sprite {
		private const MAX_NUMBER:int = 100000;
		private var started:int;
		private var _vector:Array;
		private var _list;
		private var my_txt:TextField = new TextField();
		private var label_txt:TextField = new TextField();
		public function VectorAndLinkedListIteration() {
			// Creating a TextField for display
			createTextField();
			// Starting test
			pushToVector();
			shiftFromVector();
			pushToLinkedList();
			shiftFromLinkedList();
		}
		private function pushToVector():void {
			started = getTimer();
			var myVector:Array = new Array();
			for (var i:uint = 0; i < MAX_NUMBER; i++) {
				myVector.push(i);
			}
			xTrace(getTimer() - started);
			_vector = myVector;
		}
		private function shiftFromVector():void {
			started = getTimer();
			var myVector:Array  = _vector;
			for (var i:uint = 0; i < MAX_NUMBER; i++) {
				var n:uint = myVector.shift();
			}
			xTrace(getTimer() - started);
		}
		private function pushToLinkedList():void {
			started = getTimer();
			var myList:MyLinkedList = new MyLinkedList();
			for (var i:uint = 0; i < MAX_NUMBER; i++) {
				myList.push(i);
			}
			xTrace(getTimer() - started);
			_list = myList;
		}
		private function shiftFromLinkedList():void {
			started = getTimer();
			var myList:MyLinkedList  = _list;
			for (var i:uint = 0; i < MAX_NUMBER; i++) {
				var n:uint = myList.shift();
			}
			xTrace(getTimer() - started);
		}
		private function createTextField():void {
			addChild(my_txt);
			addChild(label_txt);
			my_txt.autoSize = TextFieldAutoSize.RIGHT;
			my_txt.x += 25;
			label_txt.autoSize = TextFieldAutoSize.LEFT;
			label_txt.text = 
			"Vector.push():\nVector.shift():\nLinkedList.push():\nLinkedList.shift():";
		}
		private function xTrace(n:int):void {
			my_txt.appendText(String(n) + "\n");
		}
	}
}
// Linked List Class Definition
internal class MyLinkedList {
	public var first:Element;
	public var last:Element;
	public function MyLinkedList() {}
	public function push(myData:uint):void {
		var newData:Element = new Element(myData);
		if (last) {
			last.next = newData;
			newData.prev = last;
			last = newData;
		} else {
			first = last = newData;
		}
	}
	public function shift():uint {
		if (first) {
			var removingElement:Element = first;
			first = removingElement.next;
			if (first) {
				first.prev = null;
			} else {
				last = null;
			}
			return removingElement.data;
		} else {
			return null;
		}
	}
}
internal class Element {
	public var prev:Element;
	public var next:Element;
	public var data:uint;
	public function Element(myData:uint) {
		data = myData;
	}
}