/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g6Lh
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.utils.ByteArray;

    public class FlashTest extends Sprite {
        
        public var _bitmapData:BitmapData;
        public var _bitmap:Bitmap;
        public var gridSprite:Sprite;
        
        public var tileNum_X:int = 465/5;
        public var tileNum_Y:int = 465/5;
        public var tile_width:int = 5;
        public var tile_height:int = 5; 
        
        public var len:int = 465 / 5;
        public var tiles:Array = [];
        public var cloneTiles:Array;
        
        public function FlashTest() {
            // write as3 code here..
            _bitmapData = new BitmapData(465, 465, false, 0x292929);
            _bitmap = new Bitmap(_bitmapData);
            addChild(_bitmap);
            
            stage.scaleMode = "noScale";
            
            //draw Line
            var i:int, j:int;
            gridSprite = new Sprite(); //draw Line
            gridSprite.graphics.lineStyle(0, 0x7f7f7f);
            
            for (i = 0; i < tileNum_X + 1; i += 1)
            {
                gridSprite.graphics.moveTo(i * tile_width, 0);
                gridSprite.graphics.lineTo(i * tile_width, tileNum_Y * tile_height);
            }
            for (i = 0; i < tileNum_Y + 1; i += 1)
            {
                gridSprite.graphics.moveTo(0, i * tile_height);
                gridSprite.graphics.lineTo(tileNum_X * tile_width, i * tile_height);
            }
            
            addChild(gridSprite);
            
            //init
            for (i = 0; i < len; i += 1)
            {
                tiles[i] = [];
                for (j = 0; j < len; j += 1)
                {
                    tiles[i].push(false);
                }
            }
            
            for (i = -3; i < 4; i += 1)
            {
                tiles[int(len / 2) + i][int(len / 2)] = true;
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        public function onEnterFrame(e:Event):void
        {
            doAutomata();
            drawTiles();
        }
        
        public function doAutomata():void
        {
            var i:int;
            var j:int;
            var neighbor:int;
            
            cloneTiles = clone(tiles);
            
            for (i = 0; i < tiles.length; i += 1)
            {
                for (j = 0; j < tiles[i].length; j += 1)
                {
                    neighbor = 0;
                    if (i > 0)
                    {
                        if (tiles[i - 1][j] == true)
                        {
                            neighbor += 1;
                        }
                        
                        if (j > 0)
                        {
                            if (tiles[i - 1][j - 1] == true)
                            {
                                neighbor += 1;
                            }
                        }
                        
                        if (j < len - 1)
                        {
                            if (tiles[i - 1][j + 1] == true)
                            {
                                neighbor += 1;
                            }
                        }
                    }
                    if (i < len - 1)
                    {
                        if (tiles[i + 1][j] == true)
                        {
                            neighbor += 1;
                        }
                        
                        if (j > 0)
                        {
                            if (tiles[i + 1][j - 1] == true)
                            {
                                neighbor += 1;
                            }
                        }
                        
                        if (j < len - 1)
                        {
                            if (tiles[i + 1][j + 1] == true)
                            {
                                neighbor += 1;
                            }
                        }
                    }
                    if (j > 0)
                    {
                        if (tiles[i][j - 1] == true)
                        {
                            neighbor += 1;
                        }
                    }
                    if (j < len - 1)
                    {
                        if (tiles[i][j + 1] == true)
                        {
                            neighbor += 1;
                        }
                    }
                    
                    if (neighbor == 3) //neighbor==4
                    {
                        cloneTiles[i][j] = true;
                    }
                    else if (neighbor >= 5)
                    {
                        cloneTiles[i][j] = false;
                    }
                }
            }
            
            tiles = clone(cloneTiles);
        }
        
        public function drawTiles():void
        {
            var i:int;
            var j:int;
            
            for (i = 0; i < tiles.length; i += 1)
            {
                for (j = 0; j < tiles[i].length; j += 1)
                {
                    if (tiles[i][j] == true)
                    {
                        _bitmapData.fillRect(new Rectangle(j * 5, i * 5, 5, 5), 0x999999);
                    }
                    else
                    {
                        _bitmapData.fillRect(new Rectangle(j * 5, i * 5, 5, 5), 0x292929);
                    }
                }
            }
        }
        
        public function clone(source:Object):*
        {
            var myBA:ByteArray = new ByteArray();
            myBA.writeObject(source);
            myBA.position = 0;
            return(myBA.readObject()); 
        }
   }
}