/**
 * Copyright pitlord ( http://wonderfl.net/user/pitlord )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g5gw
 */

// forked from zonnbe's sunny cloud
package  {
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Matrix3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    import flash.geom.Vector3D;
    import flash.utils.*;
    import flash.geom.Utils3D;
    import flash.display.TriangleCulling;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.events.MouseEvent;
    import flash.events.KeyboardEvent;
    import net.hires.debug.Stats;
    import com.bit101.components.HSlider;
    import flash.display.Shader;
    import flash.filters.ShaderFilter;
    import flash.utils.ByteArray;
    import flash.geom.Matrix;
    import com.bit101.components.HUISlider;

    [SWF(width=465,height=465,backgroundColor=0x000000,frameRate=24)]    
    public class tunnelV02 extends Sprite
    {
        // terrain
        private var W              :int        = 15;//15;
        private var H              :int        = 30;//30;
        private var SW             :Number     = 800;
        private var SH             :Number     = 960;
        private var GW             :Number     = SW/W;
        private var GH             :Number     = SH/H;
        private var MW             :Number     = 60;
        private var MH             :Number     = 90;
        private var TW             :Number     = (MW)/W-1;
        private var TH             :Number     = (MH)/H-1;
        private var TERRIAN_MAP    :BitmapData = new BitmapData(MW, MH, false);
        private var MAP            :BitmapData;
        
        // 3D
        private var viewport       :Shape                 = new Shape();
        private var world          :Matrix3D              = new Matrix3D();
        private var projected      :Vector.<Number>       = new Vector.<Number>;
        private var projection     :PerspectiveProjection = new PerspectiveProjection();
        private var TRANS          :Matrix3D              = new Matrix3D();
        private var VERTS          :Vector.<Number>       = new Vector.<Number>;
        private var INDICES        :Vector.<int>          = new Vector.<int>;
        private var UVTS           :Vector.<Number>       = new Vector.<Number>;
        
        private var offset         :Point  = new Point();
        private var loader         :Loader;
        private var GRAPHIC_URL    :String = "http://assets.wonderfl.net/images/related_images/f/fd/fd61/fd61859a0846c3b23cba2abd8b6ff3d3e1b21b68m";//"ballt.jpg"; //cloud map
        
        // interaction
        private var dragging       :Boolean  = false;
        private var drag_mode      :Boolean  = false;
        private var old_mouse      :Point    = new Point();
        private var new_mouse      :Point    = new Point();
        private var trans          :Matrix3D = new Matrix3D();
        private var zoomer         :Number   = 750;
        private var zoomVelocity   :Number   = 0;
        private var zoomIn         :Boolean  = false;
        private var zoomOut        :Boolean  = false;
        
        // settings
        private var baseX   :Number = 7;
        private var baseY   :Number = 15;
        private var Octaves :Number = 1;
        private var speed   :Number = 1.5;
        
        private var baseXHSlider   :HUISlider;
        private var baseYHSlider   :HUISlider;
        private var octavesHSlider :HUISlider;
        private var speedHSlider   :HUISlider;
        
        // sunshine :)
        private var matrix:Matrix3D = new Matrix3D();
        private var SCALE     :Number       = 8; // scale bitmap, less quality for light, but save processing
        private var pbjLoader :Loader;
        private var shine     :ShaderFilter;
        private var innerMap  :BitmapData   = new BitmapData(stage.stageWidth/SCALE, stage.stageHeight/SCALE, true, 0x0);
        private var light     :Vector3D     = new Vector3D(0,0.1,0);
        private var bitmapM   :Matrix       = new Matrix();
        
        
        public function tunnelV02()
        {
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, init);
            loader.load(new URLRequest(GRAPHIC_URL), new LoaderContext(true));
        }
        
        private function init(e:Event):void
        {
            addChild(new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x333333)));
            
            shine = new ShaderFilter (new Shader (new Base64 (Shine.pbj)));
            shine.shader.data ["center"] ["value"] = [innerMap.width/2, innerMap.height/2];
            shine.shader.data ["amount"] ["value"] = [0.77];
            shine.shader.data ["steps"] ["value"] = [40];
            
            var mouse:MovieClip = new MovieClip();
            mouse.scaleX = SCALE;
            mouse.scaleY = SCALE;
            mouse.addChild(new Bitmap(innerMap));
            //mouse.x = (stage.stageWidth-innerMap.width)/2;
            //mouse.y = (stage.stageHeight-innerMap.height)/2;
            viewport.x = stage.stageWidth / 2;
            viewport.y = stage.stageHeight / 2;

            addChild(viewport);
            //viewport.filters = [shine];  // too lag
            buildPath();
            
            MAP = Bitmap(loader.content).bitmapData;
            bitmapM.translate(stage.stageWidth/2, stage.stageHeight/2);
            bitmapM.scale(1/SCALE, 1/SCALE);
            matrix.appendRotation(30, Vector3D.X_AXIS);
            trans.appendRotation(-7, Vector3D.Z_AXIS);
            trans.appendRotation(90, Vector3D.X_AXIS);
            
            var panel:Sprite = new Sprite();
            addChild(mouse);
            addChild(panel);
            addChild(new Stats());
            baseXHSlider = new HUISlider(panel, 80, 20, "baseX", updateBaseX);
            baseXHSlider.value = baseX;
            baseYHSlider = new HUISlider(panel, 80, 35, "baseY", updateBaseY);
            baseYHSlider.value = baseY;
            octavesHSlider = new HUISlider(panel, 80, 50, "Octaves", updateOctaves);
            octavesHSlider.value = (Octaves-1) * 10;
            speedHSlider = new HUISlider(panel, 80, 65, "speed", updateSpeed);
            speedHSlider.value = speed * 10;
            
            mouse.addEventListener(MouseEvent.MOUSE_DOWN, onmouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onmouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onmouseMove);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onkeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onkeyUp);
            stage.addEventListener(Event.ENTER_FRAME, processing);
            loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, init);
        }
        
        private function updateBaseX(...arg):void
        {
            baseX = baseXHSlider.value;
        }
        
        private function updateBaseY(...arg):void
        {
            baseY = baseYHSlider.value;
        }
        
        private function updateOctaves(...arg):void
        {
            Octaves = 1+(octavesHSlider.value/10)/10*9;
        }
        
        private function updateSpeed(...arg):void
        {
            speed = (speedHSlider.value/10);
        }
        
        private function buildPath():void
        {
            
            var w:int = 0;
            var h:int = 0;
            var xA    :Number = 0;
            var xB    :Number = 0;
            var yA    :Number = 0;
            var yB    :Number = 0;
            var zA    :Number = 0;
            var zB    :Number = 0;
            var index:int = 0;
            var i0:int = 0;
            var i1:int = 0;
            var i2:int = 0;
            var i3:int = 0;
            for(h = 0; h < H; h++)
            {
                for(w = 0; w < W; w++)
                {
                    xA = -SW/2 + w*GW;
                    xB = -SW/2 + (w+1)*GW;
                    zA = -SH/2 + h*GH;
                    zB = -SH/2 + (h+1)*GH;
                    
                    VERTS.push(
                        xA, yA, zB//, //0        //0
                        //xB, yA, zB, //1        //1
                        //xA, yB, zA, //2        //2
                        //xB, yB, zA  //3        //3
                    );
                    
//                    index = (W*h + w) * 4;
//                    i0 = index;
//                    i1 = index +  1;
//                    i2 = index +  2;
//                    i3 = index +  3;
                    if(w+1 < W && h+1 < H)
                    {
                        index = (W*h + w);
                        i0 = (W*h + w);
                        i1 = (W*h + (w+1));
                        i2 = (W*(h+1) + w);
                        i3 = (W*(h+1) + (w+1));
                        
                        INDICES.push( 
                            i0,  i1,  i2, // 3
                            i1,  i3,  i2  // 6
                        );
                    }

                    UVTS.push(
                        ((w)  *TW+1)/MW, ((h)*TH)/MH, 0//,
                        //((w+1)*TW+1)/MW, ((h+1)*TH)/MH, 0, 
                        //((w)  *TW+1)/MW, ((h)  *TH)/MH, 0,
                        //((w+1)*TW+1)/MW, ((h)  *TH)/MH, 0
                    ); // redundant
                }
            }
        }
        
        private function processing(e:Event):void
        {
            if(zoomIn) zoomVelocity+=1;
            if(zoomOut) zoomVelocity-=1;
            zoomVelocity *= 0.98;
            zoomer += zoomVelocity;
            
            TERRIAN_MAP.perlinNoise(baseX,baseY,Octaves,100, false, true, 8, true, [offset, offset]);
            
            var w:int = 0;
            var h:int = 0;
            var q:int = 0;
            var k:int = 0;
            var r:Number = 0;
            var index:int = 0;
            var i0:int = 0;
            var i1:int = 0;
            var i2:int = 0;
            var i3:int = 0;
            
            var VX:Number = 0;
            var VY:Number = 0;
            var VZ:Number = 0;
            var VLEN:Number = 0;
            
            var ViX:Number = 0;
            var ViY:Number = 0;
            var ViZ:Number = 0;
            
            for(h = 0; h < H; h++)
            {
                for(w = 0; w < W; w++)
                {
                    r = TERRIAN_MAP.getPixel((w*TW), (h)*TH) & 0xFF;
                    index = (W*h + w)*3;
                    ViX = VERTS[index];
                    ViY = -130 + 200 * (r/0xFF);
                    ViZ = VERTS[index+2];
                    VERTS[index+1] = ViY;
                    VX = ViX;
                    VY = ViY/Math.abs(ViY) * (ViY * ViY);
                    VZ = ViZ;
                    VLEN = Math.sqrt(VX*VX+VY*VY+VZ*VZ);
                    UVTS[index] = 0.5+VX/VLEN*0.5;
                    UVTS[index+1] = 0.5+VY/VLEN*0.5;
                }
            }
            
            offset.y+=speed;

            world.identity();
            world.append(trans);
            var nv:Vector3D = world.transformVector(light);
            world.appendTranslation(0, 0, zoomer);
            world.append(projection.toMatrix3D());
            
            shine.shader.data ["center"] ["value"] = [nv.x*200+innerMap.width/2, nv.y*200+innerMap.height/2];
            
            
            var _UVTS:Vector.<Number> = new Vector.<Number>;
            matrix.transformVectors(UVTS,_UVTS);
            
            Utils3D.projectVectors(world, VERTS, projected, _UVTS);
            
            viewport.graphics.clear();
            
            viewport.graphics.beginBitmapFill(MAP, null, false, false);
            viewport.graphics.drawTriangles(projected, INDICES, _UVTS, TriangleCulling.NONE);  //NEGATIVE
            //viewport.graphics.drawTriangles(projected, INDICES, _UVTS, TriangleCulling.NEGATIVE);  //NEGATIVE
            viewport.graphics.endFill();
            
            innerMap.fillRect(innerMap.rect, 0x0);
            innerMap.draw(viewport, bitmapM);
            innerMap.applyFilter (innerMap, innerMap.rect, innerMap.rect.topLeft, shine);
        }
        
        private function onmouseDown(e:MouseEvent):void
        {
            old_mouse.x = mouseX;
            old_mouse.y = mouseY;
            dragging = true;
        }
        
        private function onmouseMove(e:MouseEvent):void
        {
            if(dragging)
            {
                
                new_mouse.x = mouseX
                new_mouse.y = mouseY;
                
                var difference:Point = new_mouse.subtract(old_mouse);
                var vector:Vector3D = new Vector3D(difference.x, difference.y, 0);
 
                var rotationAxis:Vector3D = vector.crossProduct(new Vector3D(0,0,1));
                rotationAxis.normalize();
 
                var distance:Number = Point.distance(new_mouse, old_mouse);
                var rotationMatrix:Matrix3D = new Matrix3D();
                rotationMatrix.appendRotation(distance, rotationAxis);
                
                trans.append(rotationMatrix);
 
                old_mouse.x = new_mouse.x;
                old_mouse.y = new_mouse.y;
            }
        }
        
        private function onmouseUp(e:MouseEvent):void
        {
            dragging = false;
        }
        
        private function onkeyDown(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case 107:
                    zoomIn = true;
                    break;
                case 189:
                    zoomOut = true;
                    break;
            }
            
        }
        
        private function onkeyUp(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case 107:
                    zoomIn = false;
                    break;
                case 189:
                    zoomOut = false;
                    break;
            }
            
        }
    }
    
}

// base64 code by 2ndyofyyx,
// http://wonderfl.kayac.com/code/b3a19884080f5ed34137e52e7c3032f3510ef861
import flash.utils.ByteArray; 
class Base64 extends ByteArray { 
    private static const BASE64:Array = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,0,0,63,52,53,54,55,56,57,58,59,60,61,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,0,0,0,0,0,0,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,0,0,0,0,0]; 
    public function Base64(str:String) { 
        var n:int, j:int; 
        for (var i:int = 0; i < str.length && str.charAt(i) != "="; i++) { 
            if (str.charCodeAt(i) < 32) continue;
            j = (j << 6) | BASE64[str.charCodeAt(i)]; 
            n += 6; 
            while(n >= 8) { 
                writeByte((j >> (n -= 8)) & 0xFF); 
            } 
        } 
        position = 0; 
    } 
}

class Shine {  // http://www.motobit.com/util/base64-decoder-encoder.asp
    public static var pbj:XML = <pbj>pQEAAACkCABab29tQmx1cqAMbmFtZXNwYWNlAG5ldC5uaWNvcHRlcmUuc2hhZGVycwCgDHZlbmRv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</pbj>;
}

/*
<languageVersion : 1.0;>

kernel ZoomBlur
<   namespace : "net.nicoptere.shaders"; // modified from here
    vendor : "nicoptere";
    version : 1;
    description : "zoom blur";
>
{
    parameter float2 center
    <
        minValue:float2(0.0, 0.0);
        maxValue:float2(4096.0, 4096.0);
        defaultValue:float2(0.0, 0.0);
    >;
    
    parameter float amount
    <
        minValue:0.0;
        maxValue:1.0;
        defaultValue:0.05;
    >;
    
    parameter float steps
    <
        minValue:1.0;
        maxValue:40.0;
        defaultValue:10.0;
    >;

    input image4 src;
    output pixel4 dst;

    void
    evaluatePixel()
    {
        float4 dstColor;

        //dstColor = float4(0.0);
        dstColor = sampleNearest(src, outCoord());
        dstColor.a = 1.0;
        
        
        float2 coord = outCoord() - center;

        
        
        float maxSteps = floor( steps );
        
        int totalSteps = int( maxSteps ) + 1;
        int step = 0;
        
        float4 test;

        test = sampleNearest( src, coord*( 1.0 - amount * (0.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (1.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (2.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (3.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (4.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (5.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (6.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (7.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (8.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (9.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (10.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (11.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (12.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (13.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (14.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (15.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (16.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (17.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (18.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (19.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (20.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (21.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (22.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (23.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (24.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (25.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (26.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (27.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (28.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (29.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (30.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (31.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (32.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (33.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (34.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (35.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (36.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (37.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (38.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (39.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;
        test = sampleNearest( src, coord*( 1.0 - amount * (40.0 / maxSteps ) ) + center );
        if( step++ < totalSteps && test.r > 0.99 && test.g > 0.9 && test.b > 0.7) dstColor += test;

        dstColor /= maxSteps;
        
        dst = dstColor;
    }

}
/**/