/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g5AW
 */

// forked from togagames's [HELP LINE 192] Diablo 2 Inventory System (WIP)
package {
    import flash.utils.getDefinitionByName;

    import flash.display.Sprite;
    
/*  =======================================================  */
/******         ** DIABLO 2 INVENTORY SYSTEM  (D2-LIKE)   ***/
/***                                         Year: 2010  ***/
/**                     Ken Clinton                      **/
/**                                                     **/
/***                 ADMIN@TOGAGAMES.COM               **/
/**                                                   **/
/*  ================================================  */


    public class Main extends Sprite {
        public var console:Console;

        private var playOrder:Array=new Array();

        public var sw:uint = 340;
        public var sh:uint = 410;

        /*BEGIN RENDER */
        public function Main ():void {
            Global.data._game = this;
            //CustomMenu._start (this);
            console = new Console(this);
            addChild (console);
            FPS._start (this);
        }
        /** END MAIN CLASS **/
    }
}
import flash.system.ApplicationDomain;
/*---------------------------------------------------------------------> CONSOLE */
    import flash.display.MovieClip;
    import flash.events.Event;

    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.LineScaleMode;
    import flash.display.Shape;
    import flash.events.MouseEvent;
    import flash.ui.Mouse;

    import flash.utils.Timer;
    import flash.utils.getDefinitionByName;
    import flash.utils.getQualifiedClassName;
    import flash.events.KeyboardEvent;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.AntiAliasType;
    import flash.utils.setTimeout; 
    import flash.events.TimerEvent;
        
    dynamic class Console extends MovieClip {
        private var errors:String;
    
        private var perSecond:uint = 33;// 1000/30 (fps)

        private var inventory:MovieClip;

        // inventory box details
        private var bgwid:uint=297;
        private var bghei:uint=167;
        private var cornerRadius:uint=4;
        private var innerCornerRadius:uint=5;
        private var bgColor:uint=0x946A2E;
        private var bgColorDark:uint=0x60451A;
        private var borderColor:uint=0xD8A65A;
        private var borderSize:uint=1;
        //
        private var rows:uint=4;
        private var cols:uint=8;
        private var dr:uint=0;
        private var dc:uint=0;



        private var slots:Array=new Array();
        private var slotNumber:uint=1;
        private var currentSlot:Object;

        private var s:Slot;
        private var ground:Ground;

        private var held:MovieClip;
        private var helds:Array = new Array();
        private var heldNumber:uint = 0;
        private var currentHeld:uint = 0;

        private var bag:Item_Bag;
        private var bags:Array = new Array();

        private var _stage:Object;
        private var itemInHand:Boolean = false;

        private var rItems:Array = new Array();
        private var classRefs:Object = {
            "Ring_Noob" : Ring_Noob,
            "Belt_Noob" : Belt_Noob,
            "Sword_Noob" : Sword_Noob,
            "Pants_Noob" : Pants_Noob
        };

        private var i:uint = 0;

        trace ("*Diablo 2 Inventory*\r");

        public function Console (parent:Object,xx:uint=20,yy:uint=160):void {
            _stage = parent;
            //
            rItems.push ("NULL");
            rItems.push ("Ring_Noob");
            rItems.push ("Belt_Noob");
            rItems.push ("Sword_Noob");
            rItems.push ("Pants_Noob");
            // add the inventory so we can move the console around
            inventory = new MovieClip();
            alpha = 1;
            addChild (inventory);
            drawConsoleBG (inventory);
            drawSlots (inventory);
            inventory.x = xx;
            inventory.y = yy;
            ground = new Ground();
            parent.addChild (ground);
            //
            _starterBags ();
            //
            var timer:Timer = new Timer(perSecond,0);// save game every x seconds
            timer.addEventListener (TimerEvent.TIMER,timedLoop);
            timer.start ();
            
        }
        private function drawConsoleBG (parent:Object):void {
            // draw very bg
            parent.graphics.beginFill (bgColor);
            parent.graphics.lineStyle (borderSize,borderColor);
            parent.graphics.drawRoundRect (0,0,bgwid,bghei,cornerRadius);
            parent.graphics.endFill ();
            // draw upper bg
            parent.graphics.beginFill (bgColorDark);
            parent.graphics.lineStyle (0,borderColor);
            parent.graphics.drawRoundRect (15,15,bgwid - 30,bghei - 30,innerCornerRadius);
            parent.graphics.endFill ();
        }
        private function drawSlots (parent:Object):void {
            // draw all the slots
            for (dr=0; dr < rows; dr++) {
                for (dc=0; dc < cols; dc++) {
                    s = new Slot();
                    s.name="slot" + slotNumber;
                    s.x=18 + 33 * dc;
                    s.y=18 + 33 * dr;
                    s.addEventListener (MouseEvent.ROLL_OVER,_report);
                    parent.addChild (s);
                    slots[slotNumber]=s;
                    slotNumber++;
                }
            }
            currentSlot = s;
        }
        private function _starterBags ():void {
            // dropping item on the ground if there is an item in-hand
            trace ("Bags on the ground contain:\r");
            for (i = 0; i < 4; i++) {
                bag = new Item_Bag;
                bag.x = ground.x + (34*i);
                bag.y = ground.y + 3;
                bag.addEventListener (MouseEvent.CLICK,_liftItem);
                bag.has = rItems[Functions.randRange(0,rItems.length-1)];
                bag._num = heldNumber;
                trace (bag.has);
                _stage.addChild (bag);
                bags[heldNumber] = bag;
                heldNumber++;
            }
        }
        private function _dropNewBag (type:String,_num:uint):void {
            // dropping item on the ground if there is an item in-hand
            bag = new Item_Bag;
            bag.x = mouseX;
            bag.y = mouseY;
            bag.addEventListener (MouseEvent.CLICK,_liftItem);
            bag.has = type;
            bag._num = _num;
            trace (bag.has+" "+bag._num);
            _stage.addChild (bag);
            bags[_num] = bag;
        }
        public function loadItem (type:String,_num:uint):void {
            // LOAD CLASS EQUIPMENT ITEM FROM ARRAY
            for (i = 0; i < rItems.length; i++) {
                if (rItems[i] == type) {
                    //try {
                        var classType:Class = classRefs[type];
                        if (classType != null) {
                        held = new classType();
                    //} catch (error:Error) {
                    //    errors = String(error);
                    //} finally {
                    //     Functions._error("<b>ERROR</b>: "+errors);
                    //}
                    //held = new Belt_Noob(); //works deliberately...
                        held.itm = type;
                        held._num = _num;
                        _stage.addChild (held);
                    }
                }
            }
        }
        private function _dropItem (event:Event):void {
            // dropping item on the ground if there is an item in-hand
            if (itemInHand && helds[event.currentTarget._num].hitTestObject(ground) && ground.hitTestPoint(mouseX,mouseY,true)) {
                trace ("dropping "+event.currentTarget.itm+" on the ground ("+event.currentTarget._num+")");
                helds[event.currentTarget._num].removeEventListener (MouseEvent.CLICK,_dropItem);
                helds[event.currentTarget._num].removeEventListener (MouseEvent.CLICK,_storeItem);
                _stage.removeChild (helds[event.currentTarget._num]);
                Mouse.show ();
                _dropNewBag (event.currentTarget.itm,event.currentTarget._num);
                itemInHand = false;
            }
        }
        private function _liftItem (event:Event):void {
            // we are lifting a bagged item from the ground if we aren't holding anything else
            if (!itemInHand) {
                trace ("lifting "+event.currentTarget.has+" from the ground ("+event.currentTarget._num+")");
                //Mouse.hide ();
                event.currentTarget.removeEventListener (MouseEvent.CLICK,_liftItem);
                _stage.removeChild (bags[event.currentTarget._num]);
                loadItem (event.currentTarget.has,event.currentTarget._num);
                held._status = "unstored";
                held.x = mouseX - (held.width/2);
                held.y = mouseY - (held.height/2);
                helds._num = event.currentTarget._num;
                held.addEventListener (MouseEvent.CLICK,_dropItem);
                held.addEventListener (MouseEvent.CLICK,_storeItem);
                currentHeld = event.currentTarget._num;
                helds[event.currentTarget._num] = held;
                itemInHand = true;
            }
        }
        private function _storeItem (event:Event):void {
            /* we are storing an item in the inventory */
            if (itemInHand && inventory.hitTestPoint(mouseX,mouseY,true)) {
                // figure out which slot they are touching...
                trace ("storing "+event.currentTarget.itm+" ("+event.currentTarget._num+")");
                //Mouse.hide ();
                trace ("trace: "+event.currentTarget._num);
                helds[event.currentTarget._num].removeEventListener (MouseEvent.CLICK,_dropItem);
                helds[event.currentTarget._num].removeEventListener (MouseEvent.CLICK,_storeItem);
                helds[event.currentTarget._num].x = mouseX - helds[event.currentTarget._num].width/2;
                helds[event.currentTarget._num].y = mouseY - helds[event.currentTarget._num].height/2;
                itemInHand = false;
                helds[event.currentTarget._num]._status = "stored";
                helds[event.currentTarget._num].addEventListener (MouseEvent.CLICK,_unstoreItem);
            }
        }
        private function _unstoreItem (event:Event):void {
            // we are lifting an item from storage
            trace ("taking "+event.currentTarget.itm+" from storage ("+event.currentTarget._num+")");
            //Mouse.hide ();
            event.currentTarget.removeEventListener (MouseEvent.CLICK,_unstoreItem);
            _stage.setChildIndex (helds[event.currentTarget._num], _stage.numChildren-1);
            currentHeld = event.currentTarget._num;
            itemInHand = true;
            helds[event.currentTarget._num]._status = "unstored";
            helds[event.currentTarget._num].addEventListener (MouseEvent.CLICK,_dropItem);
            helds[event.currentTarget._num].addEventListener (MouseEvent.CLICK,_storeItem);
        }
        private function _report (event:Event):void {
            // remove glow from previous tile
            currentSlot.glow.alpha=0;
            currentSlot=event.currentTarget;
            //trace (currentSlot.name);
            currentSlot.glow.alpha=1;
        }
/*
                 UPDATE EVERY X SECONDS (GAME SAVES, ETC)
*/
        private function timedLoop (e:TimerEvent):void {
            _update ();
        }
        private function _update ():void {
            if (itemInHand) {
                // left and right
                if (mouseX - (helds[currentHeld].width/2) < 0) {
                    helds[currentHeld].x = 0;
                } else if (mouseX + (helds[currentHeld].width/2) > _stage.sw) {
                    helds[currentHeld].x = _stage.sw - (helds[currentHeld].width);
                } else {
                    helds[currentHeld].x = mouseX - (helds[currentHeld].width/2);
                }
                // up and down
                if (mouseY - (helds[currentHeld].height/2) < 0) {
                    helds[currentHeld].y = 0;
                } else if (mouseY + (helds[currentHeld].height/2) > _stage.sh) {
                    helds[currentHeld].y = _stage.sh - (helds[currentHeld].height);
                } else {
                    helds[currentHeld].y = mouseY - (helds[currentHeld].height/2);
                }
            }
            /* UPDATE OUR FPS METER */
            FPS.addFrame();
        }
        /* END CONSOLE CLASS */
    }
/* */
/* */
/* */
/* */
/*---------------------------------------------------------------------> GROUND */
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;

    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.LineScaleMode;
    import flash.display.Shape;

    class Ground extends MovieClip {

        private var wid:uint=297;
        private var hei:uint=37;
        private var CornerRadius:uint=0;
        private var BgColor:uint=0x1C4F33;
        private var BorderColor:uint=0x2A6900;
        private var BorderSize:uint=1;


        public function Ground (xx:uint = 20,yy:uint = 340):void {
            alpha = 1;
            x = xx;
            y = yy;
            graphics.beginFill (BgColor);
            graphics.lineStyle (BorderSize,BorderColor);
            graphics.drawRoundRect (0,0,wid,hei,CornerRadius);
            graphics.endFill ();
        }
        /* END GROUND CLASS */
    }
/* */
/* */
/* */
/* */
/*---------------------------------------------------------------------> ITEM_BAG */
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;

    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.LineScaleMode;
    import flash.display.Shape;
    
    class Item_Bag extends MovieClip {

        private var slotwid:uint=15;
        private var slothei:uint=15;
        private var slotCornerRadius:uint=0;
        private var slotBgColor:uint=0x663300
        private var slotBgColorDark:uint=0x60451A;
        
        private var slotBorderColor:uint=0x666633;
        private var slotBorderSize:uint=1;
        
        public var has:String;
        public var _num:int;
        
        public function Item_Bag(xx:uint = 0,yy:uint = 0):void {
            alpha = .8;
            graphics.beginFill (slotBgColor);
            graphics.lineStyle (slotBorderSize,slotBorderColor);
           graphics.drawRoundRect (0,0,slotwid,slothei,slotCornerRadius);
            graphics.endFill ();
        }
        /* END ITEM_BAG CLASS */
    }
/* */
/* */
/* */
/* */
/*--------------------------------------------------------------------->  SLOT */
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.LineScaleMode;
    import flash.display.Shape;
    import flash.events.MouseEvent;
    import flash.events.Event;


   class Slot extends MovieClip {

        private var slotwid:uint=30;
        private var slothei:uint=30;
        private var slotCornerRadius:uint=0;
        private var slotBgColor:uint=0xB5833A;
        private var slotBgColorDark:uint=0x60451A;
        private var slotBorderColor:uint=0xD8A65A;
        private var slotBorderSize:uint=1;
        
        public var glow:SlotGlow = new SlotGlow;
        
        public function Slot (xx:uint = 0,yy:uint = 0):void {
            alpha = .8;
            graphics.beginFill (slotBgColor);
            graphics.lineStyle (slotBorderSize,slotBorderColor);
            graphics.drawRoundRect (0,0,slotwid,slothei,slotCornerRadius);
            graphics.endFill ();
            // add a glow to the slot
            addChild (glow);
        }
        /* END SLOT CLASS */
    }
/* */
/* */
/* */
/* */
/*---------------------------------------------------------------------> SLOT GLOW  */
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.LineScaleMode;
    import flash.display.Shape;
    import flash.events.MouseEvent;
    import flash.events.Event;


    class SlotGlow extends MovieClip {

        private var slotwid:uint=30;
        private var slothei:uint=30;
        private var slotCornerRadius:uint=0;
        private var slotBgColor:uint=0x000000;
        private var slotBgColorDark:uint=0xffffff;
        
        private var slotBorderColor:uint=0x0066FF;
        private var slotBorderSize:uint = 2;

        public function SlotGlow (xx:uint = 0,yy:uint = 0):void {
            alpha = 0;
            //graphics.beginFill (slotBgColor);
            graphics.lineStyle (slotBorderSize,slotBorderColor);
            graphics.drawRoundRect (0,0,slotwid,slothei,slotCornerRadius);
            //graphics.endFill ();
        }
        /* END SLOT GLOW CLASS */
    }
/* */
/* */
/* */
/*---------------------------------------------------------------------> SWORD_NOOB */
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;

    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.LineScaleMode;
    import flash.display.Shape;

   dynamic class Sword_Noob extends MovieClip {

        private var slotwid:uint=30;
        private var slothei:uint=30;
        private var slotCornerRadius:uint=0;
        private var slotBgColor:uint=0x758A77;
        private var slotBgColorDark:uint=0x60451A;
        private var slotBorderColor:uint=0xD8A65A;
        private var slotBorderSize:uint=1;
        
        
        public function Sword_Noob():void {
            alpha = .8;
            graphics.beginFill (slotBgColor);
            graphics.lineStyle (slotBorderSize,slotBorderColor);
            graphics.drawRoundRect (0,0,slotwid,slothei,slotCornerRadius);
            graphics.endFill ();
        }
        /* END SWORD_NOOB CLASS */
    }
/* */
/* */
/* */
/* */
/*---------------------------------------------------------------------> PANTS_NOOB */
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;

    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.LineScaleMode;
    import flash.display.Shape;

    dynamic class Pants_Noob extends MovieClip {

        private var slotwid:uint=30;
        private var slothei:uint=30;
        private var slotCornerRadius:uint=0;
        private var slotBgColor:uint=0xFAEDD1;
        private var slotBgColorDark:uint=0x60451A;
        private var slotBorderColor:uint=0xD8A65A;
        private var slotBorderSize:uint=1;
        
        
        public function Pants_Noob():void {
            alpha = .8;
            graphics.beginFill (slotBgColor);
            graphics.lineStyle (slotBorderSize,slotBorderColor);
            graphics.drawRoundRect (0,0,slotwid,slothei,slotCornerRadius);
            graphics.endFill ();
        }
        /* END PANTS_NOOB CLASS */
    }
/* */
/* */
/* */
/* */
/*---------------------------------------------------------------------> RING_NOOB */
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;

    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.LineScaleMode;
    import flash.display.Shape;
    
    dynamic class Ring_Noob extends MovieClip {

        private var slotwid:uint=30;
        private var slothei:uint=30;
        private var slotCornerRadius:uint=0;
        private var slotBgColor:uint=0x0F26F0;
        private var slotBgColorDark:uint=0x60451A;
        private var slotBorderColor:uint=0xD8A65A;
        private var slotBorderSize:uint=1;
        
        
        public function Ring_Noob():void {
            alpha = .8;
            graphics.beginFill (slotBgColor);
            graphics.lineStyle (slotBorderSize,slotBorderColor);
            graphics.drawRoundRect (0,0,slotwid,slothei,slotCornerRadius);
            graphics.endFill ();
        }
        /* END RING_NOOB CLASS */
    }
/* */
/* */
/* */
/* */
/*---------------------------------------------------------------------> BELT_NOOB */
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;

    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.LineScaleMode;
    import flash.display.Shape;
    
    dynamic class Belt_Noob extends MovieClip {

        private var slotwid:uint=30;
        private var slothei:uint=30;
        private var slotCornerRadius:uint=0;
        private var slotBgColor:uint=0x950404;
        private var slotBgColorDark:uint=0x60451A;
        private var slotBorderColor:uint=0xD8A65A;
        private var slotBorderSize:uint=1;
        
        
        public function Belt_Noob():void {
            alpha = .8;
            graphics.beginFill (slotBgColor);
            graphics.lineStyle (slotBorderSize,slotBorderColor);
            graphics.drawRoundRect (0,0,slotwid,slothei,slotCornerRadius);
            graphics.endFill ();
        }
        /* END BELT_NOOB CLASS */
    }
/* */
/* */
/* */
/* */
/*---------------------------------------------------------------------> ERROR BOX */
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.LineScaleMode;
    import flash.display.Shape;
    import flash.events.MouseEvent;
    import flash.events.Event;


   class ErrorBox extends MovieClip {

        private var slotwid:uint=210;
        private var slothei:uint=130;
        private var slotCornerRadius:uint=0;
        private var slotBgColor:uint=0x000000;
        private var slotBgColorDark:uint=0x000000;
        private var slotBorderColor:uint=0x666666
        private var slotBorderSize:uint=2;
        
        public function ErrorBox (xx:uint = 0,yy:uint = 0):void {
            alpha = 1;
            graphics.beginFill (slotBgColor);
            graphics.lineStyle (slotBorderSize,slotBorderColor);
            graphics.drawRoundRect (0,0,slotwid,slothei,slotCornerRadius);
            graphics.endFill ();
        }
        /* END ERROR BOX CLASS */
    }
/* */
/* */
/* */
/* */
/*---------------------------------------------------------------------> BUTTON "OK" */
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.LineScaleMode;
    import flash.display.Shape;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    import flash.text.AntiAliasType;


   class ButtonOK extends MovieClip {
       
        private static  var error_text:TextField=new TextField;
        private static  var format:TextFormat=new TextFormat;
        private var slotwid:uint=75;
        private var slothei:uint=16;
        private var slotCornerRadius:uint=0;
        private var slotBgColor:uint=0xA90101;
        private var slotBgColorDark:uint=0x60451A;
        private var slotBorderColor:uint=0x666666;
        private var slotBorderSize:uint=2;
        
        public function ButtonOK (xx:uint = 0,yy:uint = 0):void {
            format.font = "Verdana";
            format.color = 0xFFFFFF;
            format.size = 10;
            format.bold = true;
            format.align = "center";
            error_text.multiline = false;
            error_text.x = 0;
            error_text.y = 0;
            error_text.width = 75;
            error_text.height = 15;
            //error_text.maxChars=  Global.data._toon_name_max;
            error_text.defaultTextFormat = format;
            error_text.antiAliasType=AntiAliasType.ADVANCED;
            error_text.type=TextFieldType.DYNAMIC;
            error_text.wordWrap=false;
            error_text.selectable=false;
            error_text.text = "OK";
            addChild(error_text);       
            alpha = 1;
            graphics.beginFill (slotBgColor);
            graphics.lineStyle (slotBorderSize,slotBorderColor);
            graphics.drawRoundRect (0,0,slotwid,slothei,slotCornerRadius);
            graphics.endFill ();

        }
        /* END BUTTON "OK" CLASS */
    }
/* */
/* */
/* */
/* */
/*--------------------------------------------------------------------->  FRAMES PER SECOND METER */
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.system.System;

    //import org.application.Functions;
    //import org.application.Global;

    class FPS extends MovieClip {


    //private static  var fn:Functions;

    public static  var frameR:int=0;
    public static  var count:int=-1;
    private static  var textBx:TextField=new TextField;
    private static  var textFm:TextFormat=new TextFormat("Microsoft Sans Serif",10,0xFFFFFF);
    private static  var mem:String;
    private static  var container:Sprite;

    private static  var timer:Timer=new Timer(1000,0);
    private static  var started:Boolean = false;


    public static function _start (stage:Object,xx:int=20,yy:int=35):FPS {

        //_stop (stage);
        container = new Sprite();
        container.alpha = 1;
        var self:FPS = new FPS;

        container.graphics.lineStyle (1,0x09480C,0);
        container.graphics.beginFill(0x000000,1);
        container.graphics.drawRect (xx,yy,100,40);

        textBx.x=xx;
        textBx.y=yy;
        textBx.width=100;
        textBx.height=60;

        textBx.multiline=true;
        textBx.selectable=false;
        container.addChild (textBx);


        stage.addChild (container);
        if (!started) {
            init ();
        }
        return self;
    }
/*
 INITIALIZE ONCE
*/
    private static function init ():void {
        addListeners ();
        started = true;
    }
    private static function addCount (TimerEvent:Event):void {

        frameR=count;
        count=-1;

        mem = Number(System.totalMemory >> 10) + "kb";

        textBx.text="FPS " + String(frameR) + "\r" + mem;
        textBx.setTextFormat (textFm);

    }

    public static function addFrame ():void {

        count++;

    }
    private static function addListeners ():void {
        timer.start ();
        timer.addEventListener (TimerEvent.TIMER,addCount);
    }
    private static function removeListeners ():void {
        timer.stop ();
        timer.removeEventListener (TimerEvent.TIMER,addCount);
    }
    public static function _hide (hid:String = "yes"):void {
        if (hid == "yes") {
            container.visible = false;
        } else {
            container.visible = true;
        }
    }
    /* END FPS METER */
}
/* */
/* */
/* */
/*--------------------------------------------------------------------->  GLOBAL FUNCTIONS CLASS */
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    import flash.text.AntiAliasType;
    import flash.filters.GlowFilter;


    dynamic class Functions {


    private static  var fixer:String;
    public static  var screen_blocker:Sprite=new Sprite;
    private static  var btn_ok:ButtonOK=new ButtonOK;
    public static  var errorBox:ErrorBox=new ErrorBox;
    private static  var error_text:TextField=new TextField;
    private static  var format:TextFormat=new TextFormat;
    private static  var format1:TextFormat=new TextFormat;
    private static  var filt:GlowFilter=new GlowFilter(0x000000,1.0,3,3,250,1,false,false);

/*
                  GLOBAL FUNCTIONS USEABLE ACROSS THE SYSTEM
*/
    // upper case the first letter of a word
    public static function _ucfirst (str:String):String {
        var firstChar:String=str.substr(0,1);
        var restOfString:String=str.substr(1,str.length);
        return firstChar.toUpperCase() + restOfString.toLowerCase();
    }
/*
                  ERROR POPUP BOX (ok button)
*/
    public static function _error (msg:String):void {
        var W:Number = Global.data._stagewidth;
        var H:Number = Global.data._stageheight;
        var X:Number=0;
        var Y:Number=0;
        var ebx:Number=50;
        var eby:Number=100;
        var btnX:Number=118;
        var btnY:Number=200;
        screen_blocker.graphics.beginFill (0x000000,0.3);
        screen_blocker.graphics.drawRect (X,Y,W,H);
        btn_ok.addEventListener (MouseEvent.CLICK,closeErrorBox);
        format1.font="Verdana";
        format1.color=0xBD9302;
        format1.size=10;
        format1.bold=false;
        format1.align="left";
        error_text.multiline=true;
        error_text.x=55;
        error_text.y=105;
        error_text.width=200;
        error_text.height=90;
        //error_text.maxChars=  Global.data._toon_name_max;
        error_text.defaultTextFormat=format1;
        error_text.antiAliasType=AntiAliasType.ADVANCED;
        error_text.type=TextFieldType.DYNAMIC;
        error_text.wordWrap = true;
        error_text.selectable = true;
        error_text.htmlText = msg;
        error_text.filters = [filt];
        errorBox.x=ebx;
        errorBox.y=eby;
        btn_ok.x=btnX;
        btn_ok.y=btnY;
        Global.data._game.addChild (screen_blocker);
        screen_blocker.addChild (errorBox);
        screen_blocker.addChild (error_text);
        screen_blocker.addChild (btn_ok);
    }
    private static function closeErrorBox (event:MouseEvent):void {
        _removeMovieClip (Global.data._game,screen_blocker);
    }
    public static function _removeMovieClip (target:Object,_clip:Object):void {
        // remove their children
        _clip.graphics.clear ();
        while (_clip.numChildren > 0) {
            _clip.removeChildAt (0);
        }
        target.removeChild (_clip);
    }
/*
                  UNIX TIMESTAMP get
*/
    public static function _timestamp ():Number {
        var myDate:Date = new Date();
        var unixTime:Number=Math.round(myDate.getTime() / 1000);
        return unixTime;
    }
/*
               GET A RANDOM NUMBER BETWEEN 2 INPUTS
   var randX:Number = randRange(10, 470); // returns 211
*/
    public static function randRange (min:Number,max:Number):Number {
        var randomNum:Number=Math.floor(Math.random() * max - min + 1) + min;
        return randomNum;
    }
/* UPDATE XFACTOR WHEN THEY USE MENUS OR RELEASE MOUSE  */
    public static function newXFactor (ax:int, bx:int):void {
        Global.data._xfactor += Math.round(ax - bx);
    }
    /* END GLOBAL FUNCTIONS CLASS */
}
/* */
/* */
/* */
/*---------------------------------------------------------------------> GLOBAL VAR CLASS */
    class Global {
        public static  var data:Object={};
    }
/*  END GLOBAL VAR CLASS */
/* */
/* */
/*---------------------------------------------------------------------> SETTINGS (GLOBAL VARS) */
    dynamic class Settings {

    Global.data._stagewidth = 800;
    Global.data._stageheight = 600;
    Global.data._name = " Diablo 2 Inventory System";// game/project name
    }
/*  END SETTINGS CLASS */
/* */
/* */
/*--------------------------------------------------------------------->  */