/**
 * Copyright mex_md ( http://wonderfl.net/user/mex_md )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g4ue
 */

// forked from mex's 【AS100本ノック】7回目：ローディング（バー） 
/* 
 * AS100本ノック
 * 7回目のお題は「ローディング（バー）」
 * あなたなりの「ローディング（バー）」を表現してください。
 */
 //なんかいろんなところからコードを頂きました。ありがとうございます。
 
package 
{
	import caurina.transitions.Tweener;
	import flash.display.DisplayObject;
	import flash.display.Loader;
    import flash.display.Sprite;
	import flash.events.ProgressEvent;
	import flash.events.TimerEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.utils.Timer;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.PixelSnapping;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
    public class FlashTest extends Sprite
	{
		private static const IMGURL:String = "http://assets.wonderfl.net/images/related_images/b/b3/b3c5/b3c554f83803adb07894c3f87c970dfd33ffe2d6"
		private var loadDummyTimer:Timer = new Timer(50);
		private var loaded:int = 0;
		private var loadedP:int = 0; 
		private var tf:TextField = new TextField();
		private static const RECT:Rectangle = new Rectangle(0, 0, 465, 465);
		
		private static const GRAVITY:Number = 100;
		private static const DRAG:Number = 0.7;
		
		private var _canvas:BitmapData;
		private var _forceMap:BitmapData;
		private var _particles:Vector.<Particle>;
		
		private var loader:Loader;
		
		public function FlashTest()
		{
			this._canvas = new BitmapData(465, 465, false, 0x0);
			this.addChild(new Bitmap(this._canvas)) as  Bitmap;
			
			_particles = new Vector.<Particle>();
			for (var i:int = 0; i < 465; i++ )
			{
				for (var j:int = 0; j < 465; j++)
				{
					_particles.push(new Particle(i, j));
				}
			}
			
			tf.defaultTextFormat = new TextFormat('Verdana', 38, 0xffffff, true); 
			tf.autoSize = TextFieldAutoSize.LEFT;
			//tf.text = '0';
			tf.width = 465;
			tf.wordWrap = true;
			tf.x = (465 - tf.width) / 2;
			tf.y = (465 - tf.height) / 2;
			this._forceMap = new BitmapData(465, 465, false, 0x0);
			
			this.addEventListener(Event.ENTER_FRAME, this.update);
			
			//
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleteHandler);
			loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, loadProgressHandler);
			loader.load(new URLRequest(IMGURL));
          /*  loadDummyTimer.addEventListener(TimerEvent.TIMER, timerHandler);
			loadDummyTimer.start();*/
        }
		
		/*-----------------------------------------//
		//loadProgressHandler
		//------------------------------------------*/
		private function loadProgressHandler(evt:ProgressEvent):void 
		{
			
			var n:int = loaded;
			loadedP = loaded;
			var p:Number = evt.bytesLoaded / evt.bytesTotal*100;
			loaded = int(p); 
			if(loaded > n)updateLoadingbar();
		}
		
		/*-----------------------------------------//
		//loadCompleteHandler
		//------------------------------------------*/
		private function loadCompleteHandler(evt:Event):void 
		{
			var canvasBMP:DisplayObject = this.getChildAt(0);
			addChildAt(loader,0);
			Tweener.addTween(canvasBMP, { alpha:0, time:0.5, transition:"easeOutSine", onComplete:function():void { removeChild(canvasBMP)}})
			
		}
		
		/*-----------------------------------------//
		//timerHandler
		//------------------------------------------*/
		/*private function timerHandler(evt:TimerEvent):void 
		{
			loaded ++;
			updateLoadingbar();
			if (loaded >= 100)
			{
				
			}
		}*/
		private function updateLoadingbar():void
		{
			for (var i:int = loadedP; i < loaded; i++ )
			{
				tf.appendText(i.toString());
			}
			//tf.appendText(loaded.toString());
			var m:Matrix = new Matrix();
			m.scale(Math.random() * 2,Math.random()*2);
			
			this._forceMap.draw(tf);
			//this._forceMap.applyFilter(this._forceMap, this._forceMap.rect, new Point(0, 0), new BlurFilter(4, 4));
			
			var d:Number;
			var gravity:Number = GRAVITY /20;
			for each(var p:Particle in _particles)
			{
				p.vy += 2+Math.random()*gravity;
				p.vx += 2+Math.random()*10;
				d =(this._forceMap.getPixel(p.x, p.y) / 0xffffff) * 0.5;
				
				p.vy *= d;
				p.vx *= d;
			}
			this._canvas.unlock(); 
			
		}
		
		public function update(e:Event):void 
		{
			
			//_canvas.fillRect(RECT,0x000000)
			this._canvas.lock(); 
			this._forceMap.applyFilter(this._forceMap, this._forceMap.rect, new Point(0, 0), new BlurFilter(4, 4));
			
			var ct:ColorTransform = new ColorTransform (0.7, 0.7, 0.7);
			_canvas.colorTransform(RECT, ct);
			
			for each(var p:Particle in _particles)
			{
				if (!p.falled)
				{
					p.vx *= 0.99;
					p.vy *= 0.99;
					p.x += p.vx;
					p.y += p.vy;
					if (p.x >= 465 ||p.y >= 465)
					{
						p.falled = true;
					}
					
					_canvas.setPixel32(p.x, p.y, p.color);
				}
			}
			_canvas.unlock();
		}
    }
}

class Particle 
{
	public var x:Number;
	public var y:Number;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var color:Number = 0xffcb65;
	public var falled:Boolean = false;
	public function Particle(x:Number,y:Number)
	{
		this.x = x;
		this.y = y;
	}
}
