/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g4fX
 */

// forked from siouxcitizen's PV3DのTriangleMesh3Dの練習05　オベリスク型の作成
//PV3DのTriangleMesh3Dの練習06　ピラミッド型をクラス化
//今後も再利用できるようにと3Dピラミッド型のクラス化を行ってみました
//
//↓今回のコードを作成するにあたって以下のサイト＆コードを参考にさせて頂きました
//おや爺っちのアプリ開発　Papervision3Dでプリミティブ以外のオブジェクトに挑戦
//http://aaady.blog117.fc2.com/blog-entry-55.html
package
{
    import flash.events.Event;
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.view.BasicView;

    [SWF(width="640", height="480", backgroundColor="#000000", frameRate="60")]
    public class TriangleMesh3DExample extends BasicView
    {
        private var mesh : TriangleMesh3D;
        private var light:PointLight3D
        private var size : int = 500; //3Dピラミッドオブジェクトの底一辺の長さ

        public function TriangleMesh3DExample() {
            //光源設定
            light = new PointLight3D();
            light.y = -8000;
            light.x = -8000;
            light.z = -8000;

            //マテリアル設定
            var material : FlatShadeMaterial = new FlatShadeMaterial(light, 0xffff99, 0xff9900);
            material.doubleSided = false;

            //TriangleMesh3Dを継承したPyramidオブジェクトを生成
            mesh = new PyramidPolygon( material, size ); //マテリアルと、ピラミッドの底の一辺の長さを設定
            scene.addChild(mesh);

            startRendering();
        }

        override protected function onRenderTick(event:Event=null):void {
            mesh.rotationX=viewport.mouseX;
            mesh.rotationY=viewport.mouseY;
            super.onRenderTick(event);
        }
    }
}

import org.papervision3d.core.geom.TriangleMesh3D;
import org.papervision3d.core.geom.renderables.Triangle3D;
import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.core.math.NumberUV;
import org.papervision3d.core.proto.MaterialObject3D;

class PyramidPolygon extends TriangleMesh3D {

    static public var DEFAULT_SCALE :Number = 500;

    public function PyramidPolygon( material :MaterialObject3D=null, scale :Number=0 ) {
        super( material, new Array(), new Array(), null );
        scale = scale || DEFAULT_SCALE;
        buildRegularPolygon( scale );
    }
    private function buildRegularPolygon( scale :Number ):void {
        var v0 : Vertex3D = new Vertex3D(-(scale/2), -(scale/2), (scale/2)); //ピラミッドの土台部分となる4頂点の1つ
        var v1 : Vertex3D = new Vertex3D((scale/2), -(scale/2), (scale/2)); //ピラミッドの土台部分となる4頂点の1つ
        var v2 : Vertex3D = new Vertex3D(0, (scale/2), 0); //ピラミッドのてっぺん部分の頂点
        var v3 : Vertex3D = new Vertex3D(-(scale/2), -(scale/2), -(scale/2)); //ピラミッドの土台部分となる4頂点の1つ
        var v4 : Vertex3D = new Vertex3D((scale/2), -(scale/2), -(scale/2)); //ピラミッドの土台部分となる4頂点の1つ

        this.geometry.vertices.push( v0 );
        this.geometry.vertices.push( v1 );
        this.geometry.vertices.push( v2 );
        this.geometry.vertices.push( v3 );
        this.geometry.vertices.push( v4 );

        //面定義
        var uvA : NumberUV = new NumberUV( 0, 0 );
        var uvC : NumberUV = new NumberUV( 1, 0 );
        var uvB : NumberUV = new NumberUV( 0, 1 );

        //ピラミッド部分作成　(時計まわりで指定された三角形が、マテリアル設定される表面となる？)
        //前面
        this.geometry.faces.push( new Triangle3D( this, new Array(v2,v1,v0), null, new Array(uvA,uvC,uvB) ));
        //後面
        this.geometry.faces.push( new Triangle3D( this, new Array(v2,v3,v4), null, new Array(uvA,uvC,uvB) ));
        //左面
        this.geometry.faces.push( new Triangle3D( this, new Array(v2,v0,v3), null, new Array(uvA,uvC,uvB) ));
        //右面
        this.geometry.faces.push( new Triangle3D( this, new Array(v2,v4,v1), null, new Array(uvA,uvC,uvB) ));
        //底 (3D三角面を2枚使用して3D四角面を作成)
        this.geometry.faces.push( new Triangle3D( this, new Array(v1,v3,v0), null, new Array(uvA,uvC,uvB) ));
        this.geometry.faces.push( new Triangle3D( this, new Array(v1,v4,v3), null, new Array(uvA,uvC,uvB) ));

        this.geometry.ready = true;  
    }  
}  