/**
 * Copyright hidebo ( http://wonderfl.net/user/hidebo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g4Er
 */

// forked from hidebo's #2 click game ver 0.1
// forked from hidebo's #1 click game ver 0.01
package {                                                    // お約束
    import flash.display.*;                                    // 使うなら書け
    import flash.text.*;
    import flash.events.*;
    import flash.utils.getTimer;
    
    [SWF(width=240, height=240, backgroundColor=0xFFFFFF)]    // 意味不明
    public class Main extends Sprite {                        // イマイチ不明
        private const MAT_R:int = 10;                    // 的の半径
        private const MAT_R_C:int = 3;                     // 的(中心)の半径
        private const TRY_COUNT:int = 3;                    // 何回するか
        private const BONUS:int = 10;                    // 的の中心をクリックした時のボーナス点
        private const START_HISCORE:int = TRY_COUNT*(100-BONUS);    // 最初のハイスコア

        private const WEEK:Array = ["日", "月", "火", "水", "木", "金", "土"];

        private var gm:TextField;                        // ゲームメッセージ表示部
        private var sf:TextField;                        // スコア表示部
        private var canvas:Sprite;                       // 的1表示部
        private var canvas2:Sprite;                      // 的2表示部

        private var trycount:int = 0;                       // クリックした回数
        private var score:int = 0;                       // スコア合計
        private var hiscore:int = START_HISCORE;                // ハイスコア
        private var oldtime:int = 0;
        //     こっからはデバッグ用
        private var mode:int = 0;                       // ゲームモード(デバッグ用) 
        private var irqcounter:uint = 0;                       // IRQC
        private var monitor:TextField;                        // デバッグ用のモニター表示部
        private var debug:Array = [0, 0, 0, 0, 0, 0, 0, 0];

        /****************************************************************/
        //        始まりはいつもここから
        /****************************************************************/
        public function Main() {
            gm = new TextField();                        // メッセージを書く場所さ
            gm.defaultTextFormat = new TextFormat("_typeWriter", 30, 0x0, true);
            gm.selectable = false;                      // マウス選択不可だぜ
            gm.autoSize = "left";
            gm.text = "START";                                // ＳＴＡＲＴ表示したい
            gm.x = (stage.stageWidth  - gm.width ) / 2;        // 真ん中に
            gm.y = (stage.stageHeight - gm.height) / 2;
            addChild(gm);
 
            monitor = new TextField();                        // モニターだすのだ
            monitor.defaultTextFormat = new TextFormat("_typeWriter", 7, 0x0, true);
            monitor.width  = stage.stageWidth;          // 幅は画面いっぱい
            monitor.height = 12;                        // 高さ            
            monitor.background = true;                        // 背景色つけるよ
            monitor.backgroundColor = 0xF0F0F0;                // 多少灰色            
            addChild(monitor);
  
            sf = new TextField();                        //スコア書くよ
            sf.defaultTextFormat = new TextFormat("_ゴシック", 12, 0x0, true);
            sf.autoSize = "left";
            sf.selectable = false;                      // マウス選択不可
            addChild(sf);

            canvas = new Sprite();                        //的書くよ
            canvas2 = new Sprite();                        //的(中心)書くよ
            canvas.graphics.beginFill(0xFF0000);            // 的は赤色で塗りつぶすよ
            canvas.graphics.drawCircle(0, 0, MAT_R);           // (0,0)ベースで書くよ
            canvas.graphics.endFill();                         // さあ書け
            matoRandom();
            addChild(canvas);
            canvas.visible = false;                          // さしあたり消えといて
            canvas2.graphics.beginFill(0x0);            // 的(中心)は黒色で塗りつぶすよ
            canvas2.graphics.drawCircle(0, 0, MAT_R_C);           // (0,0)ベースで書くよ
            canvas2.graphics.endFill();                         // さあ書け
            addChild(canvas2);
            canvas2.visible = false;                                    // さしあたり消えといて

            stage.frameRate = 60;                                // 60FPS(１秒６０コマ)だよ
            addEventListener(Event.ENTER_FRAME, onEnterFrame);    // １フレーム(インター)ごとに飛んできてね
            gm.addEventListener(MouseEvent.CLICK, init);    //クリックしたらはじまるよ
        }
        /****************************************************************/
        //    １フレーム毎に飛んでくるよ
        /****************************************************************/
        private function onEnterFrame(evt:Event):void {
            var date:Date = new Date();
            monitor.text = "";
            monitor.appendText(date.fullYear+"年"+(date.month+1)+"月"+date.date+"日"+"("+WEEK[date.day]+")"+date.toLocaleTimeString()); 
            for (var i:int = 0; i < debug.length; i++) monitor.appendText(","+debug[i]);    // デバッグフラグ書くよ
            monitor.appendText(", "+(++irqcounter));                // IRQC書くよ
        }
        /****************************************************************/
        //    初期化しちゃうよ
        /****************************************************************/
        private function init(event:Event):void {
            gm.removeEventListener(MouseEvent.CLICK, init);    //　START の CLICK はもう忘れた
            gm.visible = false;                                    // メッセージはさしあたり消えといて

            score = 0                                       // スコアは０に
            trycount = 0                                    // 回数も０
            oldtime=getTimer();                            // 開始時間を覚えとこう
          
            sf.text = "SCORE="+score.toString();                // スコア書くよ
            sf.x = 0;
            sf.y = stage.stageHeight - sf.height;                    // スコアの位置は下だよ
            sf.visible = true;                                    // スコアはさしあたり消えといて

            canvas.visible = true;                                    // 的がでま～す
            canvas2.visible = true;                                    // 的（中心）も一緒に

            // event 
            canvas.addEventListener(MouseEvent.CLICK, onMouseClick);    // 的をクリックしたら飛んでね
            canvas2.addEventListener(MouseEvent.CLICK, onMouseClick2);    // 的（中心）をクリックしたら飛んでね
            mode++;
        }
        /****************************************************************/
        //    的をクリックしたらやる事あるよ
        /****************************************************************/
        private function onMouseClick(evt:MouseEvent):void {
            scoreUp(0);
        }
        private function onMouseClick2(evt:MouseEvent):void {
            scoreUp(BONUS);
        }
        private function scoreUp(bonus:int):int {
            var nowscore:int;
            var clicktime:int=getTimer()-oldtime;
            oldtime += clicktime;                                        // 時間更新して次に備えるよ

            nowscore = (10000-clicktime)/100+bonus;                            // 時間でスコア決めちゃった
            if (nowscore > 100) nowscore = 100;                            // あんまり多いと１００点に
            if (nowscore < 0) nowscore = 0;                                // あんまり遅いと０点に
            score += nowscore;                                            // スコア合計アップ
  
            trycount++;                                                  // 試行回数アップ
            if (trycount >= TRY_COUNT) {
                end()                             // 終わっちゃった？
                return 1;
            } else {
                sf.text = trycount+"回 SCORE="+(score).toString()+"点, 今回"+nowscore+"点";               // スコア書くよ
                if (bonus) {
                    sf.appendText("(+BONUS)");                // IRQC書くよ
                }
                sf.y = stage.stageHeight - sf.height;                    // スコアの位置は下だよ
    
                matoRandom();                                            // 的はランダムがお好き
            }
            return 0;
        }
        /****************************************************************/
        //    的の場所をランダムで決めちゃうよ
        /****************************************************************/
        private function matoRandom():void {
            canvas.x = Math.random()*(stage.stageWidth-MAT_R*2)+MAT_R;    // ランダムで次の位置決めるよ
            canvas.y = Math.random()*(stage.stageHeight-MAT_R*2)+MAT_R;
            canvas2.x = canvas.x;
            canvas2.y = canvas.y;
        }
        /****************************************************************/
        //    終わったぁ
        /****************************************************************/
        private function end():void {
            canvas.visible = false;                                    // 的はさしあたり消えといて
            canvas2.visible = false;
 
            gm.visible = true;                                    // メッセージは出したいね
            gm.text = "FINISH";                                // FINISH表示したい
            gm.x = (stage.stageWidth  - gm.width ) / 2;        // 真ん中に
            gm.y = (stage.stageHeight - gm.height) / 2;

            sf.text = "SCORE = "+score;
            var wk:int = sf.text.length;
            var format:TextFormat = new TextFormat("_typeWriter", 20, 0xFF0000, true, true, true);
            sf.appendText("/"+TRY_COUNT*100+"点");
            sf.setTextFormat(format, 8, wk);

            var oldhiscore:int = hiscore;
            if (score > hiscore) hiscore = score;
            sf.appendText("\n\nHISCORE＝"+hiscore+"点");                                // ハイスコア書くね
            if (score > oldhiscore) {                                                        // ハイスコアだね？
                sf.appendText("記録更新(旧"+oldhiscore+"点)");
            } else if (score == oldhiscore) {                                                // タイスコアだね？
                sf.appendText("タイ記録");
            }
            sf.x = (stage.stageWidth - sf.width)/2;                    // スコアの位置は下だよ
            sf.y = (stage.stageHeight*3/4);                    // スコアの位置は下だよ

            gm.addEventListener(MouseEvent.CLICK, finish);    // クリックしたらはじまるよ
            mode++;
        }
        /****************************************************************/
        //    FINISH表示中だよ 
        /****************************************************************/
        private function finish(evt:MouseEvent):void {
            gm.removeEventListener(MouseEvent.CLICK, finish);
            if (hiscore >= TRY_COUNT*100) {
                gm.defaultTextFormat = new TextFormat("_typeWriter", 20, 0x0, true);
                gm.text = "congratulations!!";                                // ＳＴＡＲＴ表示したい
                gm.x = (stage.stageWidth  - gm.width ) / 2;        // 真ん中に
                gm.y = (stage.stageHeight - gm.height) / 2;
            } else {
                gm.addEventListener(MouseEvent.CLICK, init);        // クリックしたらはじまるよ
                gm.text = "START";                                // ＳＴＡＲＴ表示したい
                gm.x = (stage.stageWidth  - gm.width ) / 2;        // 真ん中に
                gm.y = (stage.stageHeight - gm.height) / 2;
                sf.visible = false;                                   // メッセージはさしあたり消えといて
                mode = 0;
            }
        } 
     }
}