/**
 * Copyright aaharu ( http://wonderfl.net/user/aaharu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g45Z
 */

package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(width=500, height=500)]
    public class Main extends Sprite {
        private var list:Vector.<MyRect> = new Vector.<MyRect>();
        private var circle:Sprite = new Sprite();
        private var pp:PerspectiveProjection = root.transform.perspectiveProjection;
        private var center:MyRect;
        
        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            circle.x = 250;
            circle.y = 250;
            addChild(circle);
            
            for(var i:uint = 0; i < 15; i++) {
                var sp:MyRect = new MyRect();
                sp.graphics.beginFill(0xFFFFFF * Math.random());
                sp.graphics.drawRect(-10, -10, 20, 20);
                sp.graphics.endFill();
                sp.x = sp.initX = Math.cos((2 * Math.PI / 15) * i) * 200;
                sp.z = sp.initZ = Math.sin((2 * Math.PI / 15) * i) * 200;
                sp.rotationY = 90 - 24 * i;
                sp.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
                list.push(sp);
                circle.addChild(sp);
            }
            
            pp.projectionCenter = new Point(250, 200);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            circle.rotationY++;
            list.sort(zSort);
            var len:uint = list.length;
            for(var i:uint = 0; i < len; i++) {
                circle.removeChild(list[i]);
                circle.addChild(list[i]);
            }
        }
        
        private function zSort(a:Sprite, b:Sprite):Number {
            var mat1:Matrix3D = a.transform.getRelativeMatrix3D(stage);
            var mat2:Matrix3D = b.transform.getRelativeMatrix3D(stage);
            return mat2.position.z - mat1.position.z;
        }
        
        private function onMouseDown(e:MouseEvent):void {
            var len:uint = list.length;
            for(var i:uint = 0; i < len; i++) {
                list[i].removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            }
            if(center) {
                BetweenAS3.to(center, {x: center.initX, z: center.initZ}).play();
            }
            var tween:ITween = BetweenAS3.to(e.target, {x: 0, z: 0});
            tween.onComplete = function():void {
                center = e.target as MyRect;
                for(var i:uint = 0; i < len; i++) {
                    list[i].addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
                }
            };
            tween.play();
        }
    }
}
import flash.display.Sprite;

class MyRect extends Sprite {
    public var initX:Number;
    public var initZ:Number;
    
    public function MyRect() {
        super();
    }
}