/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g3ZP
 */

// forked from wh0's minimalcomps procedural console
package {
    import flash.net.*;
    import flash.utils.*;
    import flash.events.*;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private static var base:String = 'http://static-cdn.playfish.com/game/cooking/swf/';
        
        private var console:Console;
        private var path:String;
        private var resource:String;
        private var data:ByteArray;
        
        public function FlashTest() {
            addChild(console = new Console(stage.stageWidth, stage.stageHeight));
            loaderInfo.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, error);
            console.input('version', version);
        }
        
        private function error(e:UncaughtErrorEvent):void {
            console.println(e.error);
        }
        
        private function version(a:Object):void {
            path = base + a.version + '/';
            console.println('using path ' + path);
            ask();
        }
        
        private function ask():void {
            console.input('resource', load);
        }
        
        private function load(a:Object):void {
            resource = a.resource;
            var l:URLLoader = new URLLoader(new URLRequest(path + resource + '.bin'));
            l.dataFormat = URLLoaderDataFormat.BINARY;
            console.load(l, resource);
            l.addEventListener(Event.COMPLETE, uncompress);
        }
        
        private function uncompress(e:Event):void {
            data = e.target.data;
            data.uncompress();
            stage.addEventListener(MouseEvent.CLICK, save);
            console.println('uncompressed ' + resource + '. click to save XML');
        }
        
        private function save(e:MouseEvent):void {
            var file:FileReference = new FileReference();
            file.addEventListener(Event.SELECT, reset);
            file.save(data, resource + '.xml');
        }
        
        private function reset(e:Event):void {
            stage.removeEventListener(MouseEvent.CLICK, save);
            ask();
        }
        
    }
}

import com.bit101.components.*;
import flash.events.*;
import flash.display.Sprite;
internal class Console extends Sprite {

    private var flow:Number = 2;
    private var maxWidth:Number;
    private var maxHeight:Number;
    
    public function Console(maxWidth:Number, maxHeight:Number) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }
    
    private function grayLine(lineHeight:Number):void {
        graphics.beginFill(0xf0f0f0);
        graphics.drawRect(0, flow + 2, maxWidth, lineHeight + 8);
        graphics.endFill();
        flow += 6;
    }
    
    // -- text line --
    
    public function println(message:String):void {
        flow += new Label(this, 2, flow - 3, message).height - 5;
    }
    
    // -- input line --
    
    private var inputTexts:Object = null;
    private var pushButton:PushButton = null;
    private var callback:Function = null;
    
    public function input(questions:Object, callback:Function):void {
        if (inputTexts) inputEnd();
        inputTexts = {};
        grayLine(16);
        if (!(questions is Array)) questions = [questions];
        var xflow:Number = 2;
        for each (var question:Object in questions) {
            if (question is String) question = {name: question};
            xflow += new Label(this, xflow, flow, question.name + ':').width + 2;
            var inputText:InputText = new InputText(this, xflow, flow, '');
            if ('maxChars' in question) inputText.maxChars = question.maxChars;
            if ('password' in question) inputText.password = question.password;
            if ('restrict' in question) inputText.restrict = question.restrict;
            if ('text'     in question) inputText.text     = question.text;
            if ('width'    in question) inputText.width    = question.width;
            xflow += inputText.width + 8;
            inputTexts[question.name] = inputText;
        }
        pushButton = new PushButton(this, xflow, flow, 'OK', inputSubmit);
        pushButton.width = 32;
        pushButton.height = 16;
        this.callback = callback;
        flow += 22;
    }
    
    private function inputSubmit(e:MouseEvent):void {
        var answer:Object = {};
        for (var name:String in inputTexts)
            answer[name] = inputTexts[name].text;
        var callback:Function = callback;
        inputEnd();
        callback(answer);
    }
    
    private function inputEnd():void {
        for (var name:String in inputTexts)
            inputTexts[name].enabled = false;
        inputTexts = null;
        pushButton.enabled = false;
        pushButton = null;
        callback = null;
    }
    
    // -- progress line --
    
    private var progressBar:ProgressBar = null;
    
    public function load(eventDispatcher:IEventDispatcher, name:String = null):void {
        if (progressBar) endProgress();
        grayLine(10);
        var xflow:Number = 4;
        if (name) xflow += new Label(this, xflow - 2, flow - 4, name).width;
        progressBar = new ProgressBar(this, xflow, flow);
        progressBar.width = maxWidth - 4 - xflow;
        flow += 16;
        eventDispatcher.addEventListener(ProgressEvent.PROGRESS, loadProgress);
        eventDispatcher.addEventListener(Event.COMPLETE, endProgress);
        eventDispatcher.addEventListener(IOErrorEvent.IO_ERROR, endProgress);
    }
    
    public function loadProgress(e:ProgressEvent):void {
        progressBar.maximum = e.bytesTotal;
        progressBar.value = e.bytesLoaded;
    }
    
    public function endProgress(e:Event = null):void {
        progressBar.enabled = false;
        progressBar = null;
    }
    
}