/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g3UC
 */

// move mouse to eat green food

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    import com.bit101.components.Component;
	import com.bit101.components.PushButton;
	import net.wonderfl.score.basic.BasicScoreForm;
	import net.wonderfl.score.basic.BasicScoreRecordViewer;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#FFFFFF")]
    
    public class Grow extends Sprite
    {
        public static const FOOD:uint = 10;
        public static const W:uint = 465;
        public static const H:uint = 465;
        
        public static var fish:Fish;
        
        public function Grow()
        {
            super();
            
            fish = new Fish(W / 2, H / 2, 3);
            fish.addEventListener(Event.COMPLETE, foodEaten);
            fish.addEventListener(Event.UNLOAD, fishDie);
            addChild(fish);
            feed(FOOD);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
        }
        
        private function mouseMove(event:MouseEvent):void
        {
            fish.move(mouseX - 5, mouseY - 5);
        }
        
        private function feed(count:uint = 1):void
        {
            for(var i:uint = 0; i < count; i++)
                addChild(new Food(Math.random() * W, Math.random() * H, 
                    fish.size + (Math.random() * 10 - 3)));
        }
        
        private function foodEaten(event:Event):void
        {
            feed(2);
        }
        
        private function fishDie(event:Event):void
        {
            while(Food.list.length)
                Food.list[0].destroy();
            var tf:TextField = new TextField();
            var score:uint = fish.eaten * 10 + Math.round(fish.size * 10);
            addChild(tf);
            tf.text = "Game Over\neaten: " + fish.eaten 
                + "\nsize: " + Math.round(fish.size * 10) / 10
                + "\nscore: " + score;
            tf.selectable = false;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.x = W / 2 - tf.width / 2;
            tf.y = H / 2 - tf.height / 2;
            
			Component.initStage(stage);
			
			new BasicScoreRecordViewer(this, 130, 110);
			new BasicScoreForm(this, 100, 150, score);
        }
    }
}

import __AS3__.vec.Vector;
import flash.display.Shape;
import flash.events.Event;

internal class Fish extends Shape
{
    public var _size:Number = 0;
    private var targetX:Number = 0;
    private var targetY:Number = 0;
    public var eaten:uint = 0;
    
    public function Fish(x:Number, y:Number, size:Number):void
    {
        this.x = x;
        this.y = y;
        this.size = size;
        
        addEventListener(Event.ENTER_FRAME, enterFrame);
    }
    
    public function set size(value:Number):void
    {
        _size = value;
        draw();
    }
    
    public function get size():Number
    {
        return _size;
    }
    
    private function draw():void
    {
        graphics.clear();
        graphics.beginFill(0x0, 1);
        graphics.drawCircle(0, 0, size);
        graphics.endFill();
    }
    
    public function move(x:Number, y:Number):void
    {
        targetX = x;
        targetY = y;
    }
    
    private function enterFrame(event:Event):void
    {
        x += (targetX - x) / 10;
        y += (targetY - y) / 10;
    }
    
    public function eat(food:Food):void
    {
        eaten++;
        var fishM:Number = Math.PI * Math.pow(size, 2);
        var foodM:Number = Math.PI * Math.pow(food.size, 2);
        foodM /= 1.5;
        size = Math.sqrt((fishM + foodM) / Math.PI);
        food.destroy();
        for each(food in Food.list)
            food.draw();
        dispatchEvent(new Event(Event.COMPLETE));
    }
    
    public function die():void
    {
        dispatchEvent(new Event(Event.UNLOAD));
        destroy();
    }
    
    public function destroy():void
    {
        removeEventListener(Event.ENTER_FRAME, enterFrame);
        parent.removeChild(this);
    }
}

internal class Food extends Shape
{
    public static var list:Vector.<Food> = new Vector.<Food>();
    
    private static const MAX_SPEED:Number = 1;
    private static const ACCELERATION:Number = 20;
    
    private var targetSpeedX:Number = 0;
    private var targetSpeedY:Number = 0;
    
    private var speedX:Number = 0;
    private var speedY:Number = 0;
    
    public var size:Number = 0;
    
    public function Food(x:Number, y:Number, size:Number):void
    {
        this.x = x;
        this.y = y;
        this.size = size;
        
        draw();
        addEventListener(Event.ENTER_FRAME, enterFrame);
        changeSpeed();
        list.push(this);
    }
    
    public function get eatable():Boolean
    {
        return Grow.fish.size > size;
    }
    
    public function get hit():Boolean
    {
        var dx:Number = x - Grow.fish.x;
        var dy:Number = y - Grow.fish.y;
        var s:Number = Grow.fish.size + size;
        return dx * dx + dy * dy < s*s;
    }
    
    public function draw():void
    {
        graphics.clear();
        graphics.beginFill(eatable ? 0x00ff00 : 0xff0000, 1);
        graphics.drawCircle(0, 0, size);
        graphics.endFill();
    }
    
    private function enterFrame(event:Event):void
    {
        speedX += (targetSpeedX - speedX) / ACCELERATION;
        speedY += (targetSpeedY - speedY) / ACCELERATION;
        x += speedX;
        y += speedY;
        
        if(x > Grow.W)
            x -= Grow.W;
        if(x < 0)
            x += Grow.W;
        if(y > Grow.H)
            y -= Grow.H;
        if(y < 0)
            y += Grow.H;
           
        if(!hit)
            return;
            
        if(eatable)
            Grow.fish.eat(this);
        else
            Grow.fish.die();
    }
    
    private function changeSpeed(... rest):void
    {
        targetSpeedX = Math.random() * MAX_SPEED * 2 - MAX_SPEED;
        targetSpeedY = Math.random() * MAX_SPEED * 2 - MAX_SPEED;
    }
    
    public function destroy():void
    {
        removeEventListener(Event.ENTER_FRAME, enterFrame);
        parent.removeChild(this);
        list.splice(list.indexOf(this), 1);
    }
}