/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g3Lu
 */

package
{
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.system.Security;
 
	[SWF(frameRate = 120)]
	public class Main extends Sprite
	{
		private const WIDTH:int = 465;
		private const HEIGHT:int = 465;
 
		private var bd:BitmapData;
 
		public function Main()
		{
			Security.loadPolicyFile("http://farm3.static.flickr.com/crossdomain.xml");
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
			loader.load(new URLRequest("http://farm3.static.flickr.com/2047/2280715132_f0a72c1088.jpg"), new LoaderContext(true));
		}
 
		private function initHandler(event:Event):void
		{
			var loader:Loader = event.currentTarget.loader;
 
			var matrix:Matrix = new Matrix();
			matrix.scale(WIDTH / loader.width, HEIGHT / loader.height);
 
			bd = new BitmapData(WIDTH, HEIGHT);
			bd.draw(loader, matrix);
			addChild(new Bitmap(bd));
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void
		{
			var copybd:BitmapData = bd.clone();
			var ty:int = 2;

			if (ty != 0)
			{
				bd.scroll(0, ty);
				if (ty > 0) bd.copyPixels(copybd, new Rectangle(0, HEIGHT - ty, WIDTH, ty), new Point());
				else bd.copyPixels(copybd, new Rectangle(0, 0, WIDTH, -ty), new Point(0, HEIGHT + ty));
				copybd = bd.clone();
			}
		}
	}
}
