/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g2Bg
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;

    public class FlashTest extends Sprite {
		
		private var _array:/*ObjData*/Array;
		private var _hitEffectArray:/*HitEffectData*/Array;
		
        public function FlashTest() {
			this.graphics.beginFill(0x0);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();

			_array = new Array();
			_hitEffectArray = new Array();
			for (var i:uint = 0; i < 50; ++i) {
				var objData:ObjData = new ObjData();
				{
					objData.pos.x = Math.random() * 465;
					objData.pos.y = Math.random() * 465;

					var deg:Number = Math.random() * 2 * Math.PI;
					var speed:Number = 5.0;
					objData.vel.x = speed * Math.cos(deg);
					objData.vel.y = speed * Math.sin(deg);
					
					var r:int = (128 + (Math.random() * 128));
					var g:int = (128 + (Math.random() * 128));
					var b:int = (128 + (Math.random() * 128));
					var color:uint = (r << 16) + (g << 8) + (b << 0);
					objData.color = color;
				}
				_array.push(objData);
			}
			
			this.addEventListener(Event.ENTER_FRAME, update);
			this.addEventListener(Event.ENTER_FRAME, draw);
        }

		private function update(e:Event):void {
			for (var i:uint = 0; i < _array.length; ++i) {
				var objData:ObjData = _array[i];
				
				objData.posLog.push(new Point(objData.pos.x, objData.pos.y));
				if (objData.posLog.length > 5) {
					objData.posLog.splice(0, 1);
				}
				
				objData.pos.x += objData.vel.x;
				objData.pos.y += objData.vel.y;
				
				if (objData.pos.x < 0) {
					objData.pos.x = 0;
					objData.vel.x *= -1;
				}
				if (objData.pos.x > 465) {
					objData.pos.x = 465;
					objData.vel.x *= -1;
				}
				if (objData.pos.y < 0) {
					objData.pos.y = 0;
					objData.vel.y *= -1;
				}
				if (objData.pos.y > 465) {
					objData.pos.y = 465;
					objData.vel.y *= -1;
				}
				
				for (var j:uint = i + 1; j < _array.length; ++j) {
					if (objData.pos.subtract(_array[j].pos).length < 5.0) {
						var hitEffectData:HitEffectData = new HitEffectData();
						hitEffectData.pos.x = (objData.pos.x + _array[j].pos.x) * 0.5;
						hitEffectData.pos.y = (objData.pos.y + _array[j].pos.y) * 0.5;
						
						var r:uint = (((objData.color >> 16) % 256) + ((_array[j].color >> 16) % 256)) / 2;
						var g:uint = (((objData.color >> 8) % 256) + ((_array[j].color >> 8) % 256)) / 2;
						var b:uint = (((objData.color >> 0) % 256) + ((_array[j].color >> 0) % 256)) / 2;
						var color:uint = (r << 16) + (g << 8) + (b << 0);
						
						hitEffectData.color = color;
						hitEffectData.lifetime = 20;
						
						_hitEffectArray.push(hitEffectData);
					}
				}
			}
			
			for (var k:uint = _hitEffectArray.length - 1; k >= 0; --k) {
				--_hitEffectArray[k].lifetime;
				if (_hitEffectArray[k].lifetime <= 0) {
					_hitEffectArray.splice(k, 1);
				}
			}
		}
		
		private function draw(e:Event):void {
			this.graphics.clear();
			
			this.graphics.beginFill(0x0);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();

			for each (var objData:ObjData in _array) {
				for (var i:uint = 0; i < objData.posLog.length; ++i) {
					var index:uint = objData.posLog.length - 1 - i;
					this.graphics.beginFill(objData.color, 1.0 - (0.2 * i));
					this.graphics.drawCircle(objData.posLog[index].x, objData.posLog[index].y, 2);
					this.graphics.endFill();
				}
			}

			for each (var hitEffectData:HitEffectData in _hitEffectArray) {
				this.graphics.lineStyle(2, hitEffectData.color, hitEffectData.lifetime * 0.025);
				this.graphics.drawCircle(hitEffectData.pos.x, hitEffectData.pos.y, 80 - (hitEffectData.lifetime * 4));
			}
		}
    }
}
import flash.geom.Point;

class ObjData {
	public var pos:Point = new Point();
	public var posLog:/*Point*/Array = new Array();
	public var vel:Point = new Point();
	public var color:uint = 0x000000;
}

class HitEffectData {
	public var pos:Point = new Point();
	public var color:uint = 0x000000;
	public var lifetime:int = 0;
}