/**
 * Copyright gggiyeok ( http://wonderfl.net/user/gggiyeok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g1tV
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * ...
     * @author ...
     */
    public class Outliner extends Sprite 
    {
        private var title:Title;        
        public function Outliner() {
            tabEnabled = false;
            tabChildren = false;
            title = new Title();
            title.addEventListener('ADD_NODE', addTitle);
            title.addEventListener('UPDATE', update);
            addChild(title);
        }
        
        private function update(e:Event):void 
        {
            var n:uint = numChildren;
            var yPos:uint = 0;
            for (var i:uint = 0; i < n; i++) {
                getChildAt(i).y = yPos;
                yPos += getChildAt(i).height;
            }
        }
        private function addTitle(e:Event):void {            
            title = new Title();
            title.addEventListener('ADD_NODE', addTitle);
            title.addEventListener('UPDATE', update);
            addChild(title);
            stage.focus = title.txt;
            title.setSelection(0, 0);
            title.y = height;            
        }
    }    
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.TextEvent;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.events.KeyboardEvent;
import flash.events.FocusEvent;
import flash.ui.Keyboard;
class Title extends Sprite {
    private var _txt:TextField;
    private var tf:TextFormat;   
    private var tabSpace:int = 20;
    private var _id:int = 0;
    private var child:Sprite;
    public function Title(w:uint=300, h:uint = 20) {
        _txt = new TextField();      
        _txt.border = true;
        _txt.type = TextFieldType.INPUT;
        _txt.width = w;
        _txt.height = h;
        tf = new TextFormat(null, 12);
        _txt.defaultTextFormat = tf;
        _txt.addEventListener(KeyboardEvent.KEY_DOWN, keyDown);        
       // _txt.addEventListener(FocusEvent.FOCUS_IN, waku);
        addChild(_txt);
        child = new Sprite();
        addChild(child);
        child.x = tabSpace;
        child.y = h;        
        addEventListener(Event.ADDED_TO_STAGE, addName);
    }    
    private function addName(e:Event):void {
        _txt.text = child.name + ' -> ' + name;
    }
    private function update(e:Event):void 
    {
        trace('update sub');
        var n:uint = child.numChildren;        
        var yPos:int = 0;
        for (var i:uint = 0; i < n; i++) {
            child.getChildAt(i).y = yPos;
            yPos += child.getChildAt(i).height;
        }
        dispatchEvent(new Event('UPDATE'));
        //drawWaku();
    }

    private function drawWaku():void {
        if(child.numChildren > 1){
            for (var i:uint = 0; i < numChildren; i++) {
                graphics.clear();
                graphics.lineStyle(1, 0xFF0000);
                graphics.moveTo(x, y);
                graphics.lineTo(x, y+height);                    
            }
        }
    }
    private function keyDown(e:KeyboardEvent):void 
    {
        if (e.keyCode == Keyboard.ENTER) {
            var subTitle:Title = new Title();
            subTitle.y = child.height;
            child.addChild(subTitle);
            stage.focus = subTitle.txt;
            subTitle.setSelection(0, 0);            
            subTitle.addEventListener('UPDATE', update);
            subTitle.addEventListener('ADD_NODE', addTitle);            
            var n:uint = child.numChildren;                    
            dispatchEvent(new Event('UPDATE'));            
        }else if (e.keyCode == Keyboard.TAB) {
            dispatchEvent(new Event('ADD_NODE'));
        }else if (e.keyCode == Keyboard.UP) {
            selectPrevTitle();
        }else if (e.keyCode == Keyboard.DOWN) {
            selectNextTitle();
        }
    }
    private function selectNextTitle():void {        
        var pT:Title = this;
        if (child.numChildren > 0) {                
            pT = Title(child.getChildAt(0));    
        }else {
            pT = findBegin(this);    
            if (pT == null) pT = this;
        }
        stage.focus = pT.txt;            
    }
    private function findBegin(node:Title):Title {    
        if (node == null) return null;
        var pT:Title;
        var cId:int = node.currentIndex();
        var endId:int = node.endIndex();
        if (cId < endId) {
            return node.getByIndex(cId + 1);
        }else {
            pT = node.getParent();
            return findBegin(pT);
        }
    }
    private function selectPrevTitle():void {
        var cId:int = currentIndex();
        var pT:Title = getByIndex(cId - 1);        
        if (pT != null) {
            if (pT.child.numChildren > 0) {                
                pT = findLast(pT.child);
            }
            stage.focus = pT.txt;            
        }else {
            if (Sprite(parent).parent is Title) {            
                stage.focus = Title(Sprite(parent).parent).txt;            
            }
        }
    }
    private function findLast(node:Sprite):Title {
        var lT:Title = node.getChildAt(node.numChildren - 1) as Title;
        if(lT.child.numChildren > 0){
            return findLast(lT.child);
        }
        return lT;
    }
    public function getParent():Title {
        if (Sprite(parent).parent is Title)    return Title(Sprite(parent).parent);
        return null;
    }
    public function endIndex():int {
        return Sprite(parent).numChildren-1;
    }
    public function currentIndex():int {
        return Sprite(parent).getChildIndex(this);
    }
    
    public function getByIndex(id:int):Title {
        if (id > -1 && id < Sprite(parent).numChildren) {
            return Sprite(parent).getChildAt(id) as Title;
        }
        return null;        
    }

    private function addTitle(e:Event):void {
        var subTitle:Title = new Title();
        child.addChild(subTitle);
        stage.focus = subTitle.txt;
        subTitle.setSelection(0, 0);
        subTitle.y = child.height;
        dispatchEvent(new Event('UPDATE'));
        subTitle.addEventListener('UPDATE', update);
        subTitle.addEventListener('ADD_NODE', addTitle);
        
    }
    public function set text(str:String):void {
        txt.text = str;
    }
    
    public function get id():int 
    {
        return _id;
    }
    
    public function set id(value:int):void 
    {
        _id = value;
    }
    
    public function get txt():TextField 
    {
        return _txt;
    }
    
    public function set txt(value:TextField):void 
    {
        _txt = value;
    }
    public function setSelection(begin:int, end:int):void {
        _txt.setSelection(begin, end);
    }
}