/**
 * Copyright Extra ( http://wonderfl.net/user/Extra )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g1gO
 */

// forked from wh0's forked from: CBC NET
// forked from Event's CBC NET
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;
    import flash.utils.*;
    
    import com.greensock.TweenLite;
    import com.greensock.easing.Linear;
    import com.greensock.easing.Quad;
    import com.greensock.plugins.TweenPlugin;
    import com.greensock.plugins.VolumePlugin;
    [SWF(frameRate=60)]
    public class FlashTest extends Sprite {
        
        private var logo:Bitmap;
        private var inverted:Bitmap;
        private var music:SoundChannel;
        private var cover:Sprite;
        private var description:TextField;
        private var imageContainer:Sprite;
        private var items:XMLList;
        private var images:Array;
        private var sounds:Array;
        private var remaining:int;
        private var current:int;
        
        public function FlashTest() {
            loaderInfo.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, function (e:UncaughtErrorEvent):void { Wonderfl.log(e.error); });
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            var l:Loader = new Loader();
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, logoComplete);
            l.load(new URLRequest('http://jsrun.it/static/assets/session5/cbcnet_logo.gif'));
            
            var s:Sound = new Sound(new URLRequest('http://www.apmmusic.com/audio/KPM/KPM_KPM_0730/KPM_KPM_0730_01401.mp3'));
            music = s.play(0, int.MAX_VALUE);
        }
        
        private function logoComplete(e:Event):void {
            var l:Loader = new Loader();
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, logoBytesComplete);
            l.loadBytes(e.target.bytes);
        }
        
        private function logoBytesComplete(e:Event):void {
            logo = e.target.content.getChildAt(0);
            logo.x = (stage.stageWidth - logo.width) >> 1;
            logo.y = (stage.stageHeight - logo.height) >> 1;
            
            inverted = new Bitmap(logo.bitmapData);
            inverted.transform.colorTransform = new ColorTransform(-1, -1, -1, 1, 255, 459, 510);
            inverted.alpha = 0;
            inverted.scaleX = inverted.scaleY = 0.9;
            inverted.x = (stage.stageWidth - inverted.width) / 2;
            inverted.y = (stage.stageHeight - inverted.height) / 2;
            TweenLite.to(inverted, 0.25, {alpha: 1, scaleX: 1, scaleY: 1, x: logo.x, y: logo.y, ease: Quad.easeOut, onComplete: invertedShowComplete});
            addChild(inverted);
        }
        
        private function invertedShowComplete():void {
            var sh:Shape = new Shape();
            sh.graphics.beginFill(0x000000);
            sh.graphics.moveTo(logo.x - 2 * logo.width, logo.y);
            sh.graphics.lineTo(logo.x, logo.y);
            sh.graphics.lineTo(logo.x - logo.width, logo.y + logo.height);
            sh.graphics.lineTo(logo.x - 2 * logo.width, logo.y + logo.height);
            sh.graphics.endFill();
            addChild(sh);
            
            logo.mask = sh;
            addChild(logo);
            
            var ul:URLLoader = new URLLoader(new URLRequest('http://png.altervista.org/Traduttore/lol.xml'));
            ul.addEventListener(Event.COMPLETE, feedComplete);
        }
        
        private function feedComplete(e:Event):void {
            var rss:XML = XML(e.target.data);
            items = rss..item;
            remaining = 2 * items.length();
            images = new Array();
            sounds = new Array();
            for each (var item:XML in items) {
                var l:Loader = new Loader();
                l.contentLoaderInfo.addEventListener(Event.COMPLETE, resourceComplete);
                l.load(new URLRequest(item.image), new LoaderContext(true)); // lol, image 14 is offsite
                images.push(l);
                var s:Sound = new Sound(new URLRequest('http://translate.google.com/translate_tts?tl=ja&q=' + encodeURIComponent(item.title)));
                s.addEventListener(Event.COMPLETE, resourceComplete);
                sounds.push(s);
            }
        }
        
        private function resourceComplete(e:Event):void {
            remaining--;
            TweenLite.to(logo.mask, 0.25, {x: 2 * logo.width - remaining * logo.width / items.length(), onComplete:moveMaskComplete});
        }
        
        private function moveMaskComplete():void {
            if (!remaining) allResourcesComplete();
        }
        
        private function allResourcesComplete():void {
            removeChild(inverted);
            inverted = null;
            removeChild(logo.mask);
            logo.mask = null;
            TweenLite.to(logo, 0.25, {alpha: 0, scaleX: 0.9, scaleY: 0.9, x: (stage.stageWidth - 0.9 * logo.width) / 2, y: (stage.stageHeight - 0.9 * logo.height) / 2, ease: Quad.easeIn, onComplete: logoHideComplete});
        }
        
        private function logoHideComplete():void {
            removeChild(logo);
            logo = null;
            
            imageContainer = new Sprite();
            addChild(imageContainer);
            
            cover = new Sprite();
            cover.graphics.beginFill(0x000000, 0.5);
            cover.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            cover.graphics.endFill();
            cover.y = stage.stageHeight;
            cover.buttonMode = true;
            cover.addEventListener(MouseEvent.CLICK, clickDescription);
            addChild(cover);
            
            description = new TextField();
            description.defaultTextFormat = new TextFormat('_sans', 13, 0xffffff);
            description.multiline = description.wordWrap = true;
            description.mouseEnabled = description.selectable = false;
            description.width = stage.stageWidth - 20;
            description.height = stage.stageHeight - 20;
            description.x = description.y = 10;
            cover.addChild(description);
            
            TweenPlugin.activate([VolumePlugin]);
            TweenLite.to(music, 1, {volume: 0.5, ease: Quad.easeOut});
            
            current = Math.random() * items.length();
            showItem();
        }
        
        private function clickDescription(e:MouseEvent):void {
            navigateToURL(new URLRequest(items[current].link), '_blank');
        }
        
        private function showItem():void {
            var sound:Sound = sounds[current];
            var length:Number = Math.max(sound.length, 5000);
            
            var image:Loader = images[current];
            var w:Number = image.width;
            var h:Number = image.height;
            var sf:Number = Math.max(stage.stageWidth / w, stage.stageHeight / h);
            var wf:Number = w * sf;
            var hf:Number = h * sf;
            var xf:Number = Math.random() * (stage.stageWidth - wf);
            var yf:Number = Math.random() * (stage.stageHeight - hf);
            var si:Number = sf * Math.pow(1.05, length / 1000);
            var wi:Number = w * si;
            var hi:Number = h * si;
            var xi:Number = Math.random() * (stage.stageWidth - wi);
            var yi:Number = Math.random() * (stage.stageHeight - hi);
            
            image.scaleX = image.scaleY = si;
            image.x = xi; image.y = yi;
            image.alpha = 0;
            (image.content as Bitmap).smoothing = true;
            imageContainer.addChild(image);
            TweenLite.to(image, length / 1000 + 2, {scaleX: sf, scaleY: sf, x: xf, y: yf, ease: Linear.easeNone});
            TweenLite.to(image, 2, {alpha: 1, ease: Quad.easeOut, overwrite: 0});
            
            var item:XML = items[current];
            description.text = item.description;
            var dy:Number = stage.stageHeight - description.textHeight - 24;
            
            setTimeout(function ():void {
                TweenLite.to(cover, 0.25, {y: dy, ease: Quad.easeOut});
            }, 750);
            
            setTimeout(function ():void {
                sound.play();
            }, 1000);
            
            setTimeout(function ():void {
                TweenLite.to(image, 1, {alpha: 0, ease: Quad.easeIn, overwrite: 0, onComplete: hideItem});
                TweenLite.to(cover, 0.25, {y: stage.stageHeight, ease: Quad.easeIn});
            }, length + 1000);
        }
        
        private function hideItem():void {
            var image:Loader = images[current];
            image.scaleX = image.scaleY = 1;
            imageContainer.removeChild(image);
            
            current = (current + 1) % items.length();
            
            showItem();
        }
        
    }
}