/**
 * Copyright picoru ( http://wonderfl.net/user/picoru )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/g1Lw
 */

// forked from cjcat2266's [Stardust] Turbulent Pixels
/**
 * Stardust Particle Engine
 * 
 * Homepage
 * 	http://code.google.com/p/stardust-particle-engine/
 * 
 * Documentation
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/docs/index.html
 * 
 * PDF Manual
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/manual/Stardust%20Particle%20Engine%20Manual.pdf
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.utils.getTimer;
	import flash.utils.Timer;
	import idv.cjcat.stardust.common.clocks.ImpulseClock;
	import idv.cjcat.stardust.twoD.renderers.PixelRenderer;
	
	[SWF(backgroundColor="#000000", frameRate=60)]
	
	public class Main extends Sprite {
		
		private const PARTICLE_COUNT:int = 600;
		
		private var emitter:PixelEmitter;
		private var noiseBMPD:BitmapData;
		private var canvasBMP:Bitmap;
		private var blurBMP:Bitmap;
		
		public function Main():void {
			canvasBMP = new Bitmap(new BitmapData(465, 465, true, 0));
			blurBMP = new Bitmap(new BitmapData(233, 233, false, 0));
			blurBMP.scaleX = blurBMP.scaleY = 2;
			addChild(blurBMP);
			addChild(canvasBMP);
			
			noiseBMPD = new BitmapData(233, 233, false, 0);
			var timer:Timer = new Timer(1000);
			timer.addEventListener(TimerEvent.TIMER, tick);
			timer.start();
			
			var clock:ImpulseClock = new ImpulseClock(PARTICLE_COUNT);
			emitter = new PixelEmitter(clock);
			var renderer:PixelRenderer = new PixelRenderer(canvasBMP.bitmapData);
			renderer.addEmitter(emitter);
			
			//injects particles into the emitter
			clock.impulse();
			
			addEventListener(Event.ENTER_FRAME, mainLoop);
			tick();
		}
		
		private function tick(e:Event = null):void {
			noiseBMPD.perlinNoise(150, 150, 1, getTimer(), true, true);
			emitter.field.update(noiseBMPD);
		}
		
		private var blur:BlurFilter = new BlurFilter(4, 4, 1);
		private var matrix:Matrix = new Matrix(0.5, 0, 0, 0.5);
		private function mainLoop(e:Event):void {
			blurBMP.bitmapData.applyFilter(blurBMP.bitmapData, blurBMP.bitmapData.rect, new Point(0, 0), blur);
			blurBMP.bitmapData.draw(canvasBMP.bitmapData, matrix);
			
			canvasBMP.bitmapData.fillRect(canvasBMP.bitmapData.rect, 0);
			emitter.step();
		}
	}
}

//------------------------------------------------------------------------------------------------

import flash.display.Shape;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.initializers.Color;
import idv.cjcat.stardust.common.initializers.Mass;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.Deflect;
import idv.cjcat.stardust.twoD.actions.Gravity;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.actions.SpeedLimit;
import idv.cjcat.stardust.twoD.deflectors.WrappingBox;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.fields.BitmapField;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.zones.RectZone;

//------------------------------------------------------------------------------------------------

//I have no idea why this line must be added in order to compile successfully on Wonderfl.
//Just ignore this class :p
class BugFixer extends Shape { public function BugFixer() { } }

//------------------------------------------------------------------------------------------------

class PixelEmitter extends Emitter2D {
	
	public var field:BitmapField;
	
	public function PixelEmitter(clock:Clock) {
		super(clock);
		
		//initializers
		addInitializer(new Color(0x00CCFF));
		addInitializer(new Mass(new UniformRandom(3, 1)));
		addInitializer(new Position(new RectZone(0, 0, 465, 465)));
		
		//actions
		var deflect:Deflect = new Deflect();
		deflect.addDeflector(new WrappingBox(0, 0, 465, 465));
		
		var gravity:Gravity = new Gravity();
		field = new BitmapField();
		field.scaleX = field.scaleY = 2;
		field.massless = false;
		gravity.addField(field);
		
		addAction(deflect);
		addAction(gravity);
		addAction(new SpeedLimit(3));
		addAction(new Move());
	}
}