/**
 * Copyright k3lab ( http://wonderfl.net/user/k3lab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fzS0
 */

// forked from checkmate's Saqoosha challenge for amateurs
package {
    import flash.display.*;
    import flash.geom.*;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.utils.getTimer;
    [SWF(width="465", height="465", frameRate="60")]
    public class Main extends Sprite {
        private var num:int = 1000;
        private var canvas:BitmapData;
        private var clones:BitmapData;
        private var clt:ColorTransform = new ColorTransform(1, 1, 1, 1, 0, -10,-20, -10);
        private var xArr:Array = []
        private var yArr:Array = []
        private var grad:Gradation;
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            grad = new Gradation(0xFFFF00, 0x00FF, 0xFF00FF);  
            canvas = new BitmapData(465, 465, false, 0);
            var canvasbmp:Bitmap = addChild(new Bitmap(canvas)) as Bitmap; 
            canvasbmp.blendMode = "add"; 
            clones = canvas.clone();
            addChild(new Bitmap(clones)) as Bitmap
            addEventListener(Event.ENTER_FRAME, update);
        }
        private function update(e:Event):void {
            clones.lock();
            canvas.lock();
            var r:Number = getTimer() * 2.5;
            var d:Number = 1000 + Math.sin( r % 1000 / 1000 * 180 * Math.PI / 180) * 255;
            for (var i:int = 0; i <num ; i++) {
                var a:Number = Math.sin( r % 10000 / 10000 * 360 * Math.PI / 180) * 6;
                var b:Number = Math.cos( r % 23000 / 23000 * 360 * Math.PI / 180) * 6;
                var c:Number = Math.sin( r % 13000 / 13000 * 360 * Math.PI / 180) * 3;
                xArr[i] = int(i / 2 + Math.sin(Math.PI + (r + i * a) % 6500 / 6500 * 360 / 180) * 200) * Math.sin(( -r) / 1000 + i / 4) / 2 + 240;
                yArr[i] = int(i / 3 + Math.sin(Math.PI + (r + i * c) % 4500 / 4500 * 360 / 180) * 400) * Math.cos(( -r) / 1000 + i / 4) / (3 + b) + 240;
                canvas.setPixel(xArr[i]+0.5, yArr[i]+0.5, grad.getColor(i/(num)));
            }
            clones.draw(canvas,null,new ColorTransform(100*d,10,10),"add");
            canvas.applyFilter(canvas, canvas.rect, new Point(Math.sin(d)*2,d/190*35-200), new BlurFilter(Math.sin(d)*20, 20, 1));
            clones.colorTransform(clones.rect, clt);
            canvas.colorTransform(canvas.rect, clt);
            clones.unlock();
            canvas.unlock();
        }	
    }	
}


import frocessing.color.ColorLerp;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

class Gradation {
    
    private var _colors:Array;
    private var _easing:IEasing;
    
    public function Gradation(...args) {
        _colors = args.concat();
        _easing = Linear.linear;
    }
    
    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }
    
    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        if (alpha == 0) {
            return _colors[idx];
        } else {
            return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
        }
    }
}