/**
 * Copyright hacker_9l_djtra ( http://wonderfl.net/user/hacker_9l_djtra )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fyfH
 */

// forked from matsu4512's パーティクル時計
package {
	import __AS3__.vec.Vector;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.utils.Timer;
	
	[SWF(backgroundColor=0x000000, width=512, height=512, frameRate=30)]

	public class ParticleTimer extends Sprite
	{
		//時間を取得するための変数
		private var date:Date;
		
		//パーティクルを桁ごとに管理
		private var second1_vec:Vector.<Particle>;
		private var second2_vec:Vector.<Particle>;
		private var minute1_vec:Vector.<Particle>;
		private var minute2_vec:Vector.<Particle>;
		private var hour1_vec:Vector.<Particle>;
		private var hour2_vec:Vector.<Particle>;
		
		//座標取得のためのテキストフィールド
		private var second1_txt:TextField;
		private var second2_txt:TextField;
		private var minute1_txt:TextField;
		private var minute2_txt:TextField;
		private var hour1_txt:TextField;
		private var hour2_txt:TextField;
		
		private var cur_s1:uint;
		private var cur_m1:uint;
		private var cur_h1:uint;
		private var cur_s2:uint;
		private var cur_m2:uint;
		private var cur_h2:uint;
		
		//文字のサイズ
		private const SIZE:Number = 100;
		
		private var num:uint=1000;
		
		private var view:Bitmap;
		private var bmpData:BitmapData;
		private var timeBmpData:BitmapData;
		
		private var timer:Timer;
		
		private const WIDTH:Number=512;
		private const HEIGHT:Number=512;
		
		public function ParticleTimer()
		{

			
			if(stage){
				init();
			}else{
				addEventListener(Event.ADDED_TO_STAGE, init);
			}
		}
		
		private function init(event:Event = null):void{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			bmpData = new BitmapData(WIDTH, HEIGHT, false, 0x000000);
			view = new Bitmap(bmpData);
			view.filters = [new BlurFilter(5, 5, 1)];
			addChild(view);
			
			init_text();
			
			timer = new Timer(1000);
			timer.addEventListener(TimerEvent.TIMER, time_loop);
			timer.start();
			
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(event:Event):void{
			bmpData.fillRect(bmpData.rect, 0x000000);
			var p:Particle;
			
			for(var i:uint = 0; i < second1_vec.length; i++){
				p = second1_vec[i];
				p.x += (p.toX - p.x)*0.2;
				p.y += (p.toY - p.y)*0.2;
				if(Math.sqrt((Math.pow(p.x - p.toX, 2) + Math.pow(p.y - p.toY, 2))) < 1){
					p.x = p.toX;
					p.y = p.toY;
				}
				bmpData.setPixel(p.x, p.y, 0xFFFFFF);
			}
			
			for(i = 0; i < second2_vec.length; i++){
				p = second2_vec[i];
				p.x += (p.toX - p.x)*0.2;
				p.y += (p.toY - p.y)*0.2;
				if(Math.sqrt((Math.pow(p.x - p.toX, 2) + Math.pow(p.y - p.toY, 2))) < 1){
					p.x = p.toX;
					p.y = p.toY;
				}
				bmpData.setPixel(p.x, p.y, 0xFFFFFF);
			}
			
			for(i = 0; i < minute1_vec.length; i++){
				p = minute1_vec[i];
				p.x += (p.toX - p.x)*0.2;
				p.y += (p.toY - p.y)*0.2;
				if(Math.sqrt((Math.pow(p.x - p.toX, 2) + Math.pow(p.y - p.toY, 2))) < 1){
					p.x = p.toX;
					p.y = p.toY;
				}
				bmpData.setPixel(p.x, p.y, 0xFFFFFF);
			}
			
			for(i = 0; i < minute2_vec.length; i++){
				p = minute2_vec[i];
				p.x += (p.toX - p.x)*0.2;
				p.y += (p.toY - p.y)*0.2;
				if(Math.sqrt((Math.pow(p.x - p.toX, 2) + Math.pow(p.y - p.toY, 2))) < 1){
					p.x = p.toX;
					p.y = p.toY;
				}
				bmpData.setPixel(p.x, p.y, 0xFFFFFF);
			}
			
			for(i = 0; i < hour1_vec.length; i++){
				p = hour1_vec[i];
				p.x += (p.toX - p.x)*0.2;
				p.y += (p.toY - p.y)*0.2;
				if(Math.sqrt((Math.pow(p.x - p.toX, 2) + Math.pow(p.y - p.toY, 2))) < 1){
					p.x = p.toX;
					p.y = p.toY;
				}
				bmpData.setPixel(p.x, p.y, 0xFFFFFF);
			}
			
			for(i = 0; i < hour2_vec.length; i++){
				p = hour2_vec[i];
				p.x += (p.toX - p.x)*0.2;
				p.y += (p.toY - p.y)*0.2;
				if(Math.sqrt((Math.pow(p.x - p.toX, 2) + Math.pow(p.y - p.toY, 2))) < 1){
					p.x = p.toX;
					p.y = p.toY;
				}
				bmpData.setPixel(p.x, p.y, 0xFFFFFF);
			}
		}
		
		private function time_loop(event:TimerEvent):void{
			date = new Date();
			
			if(cur_s1 != date.seconds%10){
				cur_s1 = date.seconds%10;
				second1_txt.text = (cur_s1).toString();
				updateParticle(second1_txt, second1_vec, 400, 200);
			}
			if(cur_s2 != Math.floor(date.seconds/10)){
				cur_s2 = date.seconds/10;
				second2_txt.text = (cur_s2).toString();
				updateParticle(second2_txt, second2_vec, 350, 200);
			}
			if(cur_m1 != date.minutes%10){
				cur_m1 = date.minutes%10;
				minute1_txt.text = (cur_m1).toString();
				updateParticle(minute1_txt, minute1_vec, 250, 200);
			}
			if(cur_m2 != Math.floor(date.minutes/10)){
				cur_m2 = date.minutes/10;
				minute2_txt.text = (cur_m2).toString();
				updateParticle(minute2_txt, minute2_vec, 200, 200);
			}
			if(cur_h1 != date.hours%10){
				cur_h1 = date.hours%10;
				hour1_txt.text = (cur_h1).toString();
				updateParticle(hour1_txt, hour1_vec, 100, 200);
			}
			if(cur_h2 != Math.floor(date.hours/10)){
				cur_h2 = date.hours/10;
				hour2_txt.text = (cur_h2).toString();
				updateParticle(hour2_txt, hour2_vec, 50, 200);
			}
		}	
			
		//パーティクルの初期化
		private function init_text():void{
			
			second1_vec = new Vector.<Particle>();
			second2_vec = new Vector.<Particle>();
			minute1_vec = new Vector.<Particle>();
			minute2_vec = new Vector.<Particle>();
			hour1_vec = new Vector.<Particle>();
			hour2_vec = new Vector.<Particle>();
			
			second1_txt = new TextField();
			second2_txt = new TextField();
			minute1_txt = new TextField();
			minute2_txt = new TextField();
			hour1_txt = new TextField();
			hour2_txt = new TextField();
			second1_txt.defaultTextFormat = second2_txt.defaultTextFormat = minute1_txt.defaultTextFormat
			= minute2_txt.defaultTextFormat = hour1_txt.defaultTextFormat = hour2_txt.defaultTextFormat = new TextFormat("Swis721 BdRndBT", SIZE, 0x000000);
			second1_txt.autoSize = second2_txt.autoSize = minute1_txt.autoSize = minute2_txt.autoSize
			= hour1_txt.autoSize = hour2_txt.autoSize = TextFieldAutoSize.LEFT;
			
			date = new Date();
			cur_s1 = date.seconds%10;
			cur_s2 = date.seconds/10;
			cur_m1 = date.minutes%10;
			cur_m2 = date.minutes/10;
			cur_h1 = date.hours%10;
			cur_h2 = date.hours/10;
			
			second1_txt.text = (cur_s1).toString();
			second2_txt.text = (cur_s2).toString();
			minute1_txt.text = (cur_m1).toString();
			minute2_txt.text = (cur_m2).toString();
			hour1_txt.text = (cur_h1).toString();
			hour2_txt.text = (cur_h2).toString();
			
			init_particle(second1_txt, second1_vec, 400, 200);
			init_particle(second2_txt, second2_vec, 350, 200);
			init_particle(minute1_txt, minute1_vec, 250, 200);
			init_particle(minute2_txt, minute2_vec, 200, 200);
			init_particle(hour1_txt, hour1_vec, 100, 200);
			init_particle(hour2_txt, hour2_vec, 50, 200);
		}
		
		private function init_particle(text:TextField, vec:Vector.<Particle>, xx:Number, yy:Number):void{
			timeBmpData = new BitmapData(text.textWidth, text.textHeight, false, 0xFFFFFF);
			timeBmpData.draw(text);
			
			var p:Particle;
			
			for(var i:uint = 0; i < timeBmpData.width; i++){
				for(var j:uint = 0; j < timeBmpData.height; j++){
					if(timeBmpData.getPixel(i, j) < 0x00FFFF){
						p = new Particle();
						p.x = p.toX = i+xx;
						p.y = p.toY = j+yy;
						
						bmpData.setPixel(p.x, p.y, 0xFFFFFF);
						vec.push(p);
					}
				}
			}
		}
		
		//パーティクルの位置などの更新
		private function updateParticle(text:TextField, vec:Vector.<Particle>, xx:Number, yy:Number):void{
			timeBmpData = new BitmapData(text.textWidth, text.textHeight, false, 0xFFFFFF);
			timeBmpData.draw(text);
			var p:Particle;
			var k:uint = 0;
			for(var i:uint = 0; i < timeBmpData.width; i++){
				for(var j:uint = 0; j < timeBmpData.height; j++){
					if(timeBmpData.getPixel(i, j) == 0x000000){
						if(vec.length != k){
							p = vec[k];
							p.toX = i + xx;
							p.toY = j + yy;
							k++;
						}else{
							p = new Particle();
							p.x = xx+text.textWidth/2;
							p.y = yy+text.textHeight/2;
							p.toX = i + xx;
							p.toY = j + yy;
							vec.push(p);
							k++;
						}
					}
				}				
			}
			if(k < vec.length){
				vec.splice(k, vec.length-k);
			}
		}
	}
}

class Particle{
	public var x:Number;
	public var y:Number;
	public var toX:Number;
	public var toY:Number;
}