/**
 * Copyright Karl94 ( http://wonderfl.net/user/Karl94 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fySk
 */

// forked from clockmaker's closure graphics
// forked from Altschuler's flash on 2010-1-29
package{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import frocessing.color.ColorHSV;
	
	[SWF(backgroundColor=0, frameRate=24)]
	public class FlashTest extends Sprite{
		private var n:Number = Math.PI/3;
		private var v:Number = 0.0002;
		private var left:Boolean = false;
		private const r:uint = uint(Math.min(stage.stageWidth, stage.stageHeight) / 2);
		
		public function FlashTest(){
			this.addEventListener(Event.ENTER_FRAME, draw);
			this.stage.addEventListener(Event.MOUSE_LEAVE, onMouseLeave);
			this.stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
		
		private function draw(e:Event):void{
			var h:ColorHSV = new ColorHSV();
			var i:uint;
			n += left?(v *= 0.95):v;
			with(this.graphics){
				clear();
				moveTo(r, r);
				for(i = 1; i < r; i++){
					h.h = i/r * 135 + n * 4000;
					lineStyle(1, /*0xFFFFFF*/h.value32);
					lineTo(
						r + (i * Math.cos(/*i + */(i * n))),
						r + (i * Math.sin(/*i + */(i * n))) );
				}
			}
		}
		
		private function onMouseLeave(e:Event):void{
			left = true;
		}
		
		private function onMouseMove(e:MouseEvent):void{
			left = false;
			v = (e.stageX-r)/100000;
		}
	}
}