/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fyRk
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=188
    public class Euler188 extends Sprite {
        private var _tf : TextField;
  
        public function Euler188() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
//            _tf.appendText("" + inv(1777, 100000000) + "\n");
//            _tf.appendText("" + expmod(1777, 87955697, 100000000) + "\n");
            _tf.appendText("" + solve(1777, 100000000, 1855) + "\n");
            var g : int = getTimer();
            _tf.appendText("" + (g - s) + " ms\n");
        }
        
        // a↑↑c mod b を求める。
        // a^t=1(mod b)となるtを探し、
        // tを法として、求めた値をaの指数として再び使うことで、
        // a↑↑n(mod t)をn=1から順に再帰的に求めていく。
        // 最後だけbを法として求める。
        private function solve(a : int, b : int, c : int) : int
        {
            var iv : int = inv(a, b);
            var t : int = 1;
            for(var i : int = 1;i < c;i++){
                t = expmod(a, t, iv);
            }
            return expmod(a, t, b);
        }
        
        private function expmod(a : int, b : int, m : int) : int
        {
            var ret : Number = 1;
            var mul : Number = a;
            for(var n : int = b;n > 0;n>>>=1){
                if((n & 1) == 1){
                    ret *= mul;
                    ret %= m;
                }
                mul *= mul;
                mul %= m;
            }
            return ret;
        }
        
        private function inv(n : int, m : int) : int
        {
            var q : Number = n;
            for(var i : int = 1;i <= m;i++){
                if(q == 1){
                    return i;
                }
                q *= n;
                q %= m;
            }
            return -1;
        }
    }
}